/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.blocks.mermaid_block.MermaidTile;
import alexthw.ars_elemental.common.entity.ai.DolphinJumpGoal;
import alexthw.ars_elemental.common.entity.ai.FollowBoatGoalM;
import alexthw.ars_elemental.common.entity.ai.HybridStrollGoal;
import alexthw.ars_elemental.common.entity.ai.MermaidAi;
import alexthw.ars_elemental.common.entity.ai.MermaidChannelGoal;
import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.registry.ModItems;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.api.util.SummonUtil;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.compat.PatchouliHandler;
import com.hollingsworth.arsnouveau.common.entity.goal.GoBackHomeGoal;
import com.hollingsworth.arsnouveau.common.items.data.ICharmSerializable;
import com.hollingsworth.arsnouveau.common.items.data.PersistentFamiliarData;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MermaidEntity
extends PathfinderMob
implements GeoEntity,
IAnimationListener,
IDispellable,
ICharmSerializable {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Boolean> CHANNELING = SynchedEntityData.defineId(MermaidEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> CHANNELING_ENTITY = SynchedEntityData.defineId(MermaidEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> TAMED = SynchedEntityData.defineId(MermaidEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> JUMPING = SynchedEntityData.defineId(MermaidEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> COLOR = SynchedEntityData.defineId(MermaidEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Optional<BlockPos>> HOME = SynchedEntityData.defineId(MermaidEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private final RawAnimation swim = RawAnimation.begin().thenLoop("swim");
    private final RawAnimation idle = RawAnimation.begin().thenLoop("idle");
    public int channelCooldown;
    AnimationController<MermaidEntity> actions;
    int animTicks;
    boolean taming;
    static final RandomSource mermaidRandom = RandomSource.createNewThreadLocalInstance();

    public MermaidEntity(EntityType<? extends PathfinderMob> p_21683_, Level p_21684_) {
        super(p_21683_, p_21684_);
        this.moveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.1f, 0.7f, false);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 10);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public MermaidEntity(Level level, boolean tamed) {
        this((EntityType<? extends PathfinderMob>)((EntityType)ModEntities.SIREN_ENTITY.get()), level);
        this.setTamed(tamed);
    }

    @NotNull
    protected Brain<?> makeBrain(@NotNull Dynamic<?> p_149138_) {
        return MermaidAi.makeBrain((Brain<MermaidEntity>)this.brainProvider().makeBrain(p_149138_));
    }

    @NotNull
    public Brain<MermaidEntity> getBrain() {
        return super.getBrain();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new HybridStrollGoal(this, 1.0, 40));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(4, (Goal)new DolphinJumpGoal(this, 10));
        this.goalSelector.addGoal(5, (Goal)new GoBackHomeGoal((Mob)this, this::getHome, 20, () -> this.getHome() != null));
        this.goalSelector.addGoal(8, (Goal)new FollowBoatGoalM(this, () -> this.getHome() == null));
        this.goalSelector.addGoal(5, (Goal)new MermaidChannelGoal(this));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.channelCooldown > 0) {
            --this.channelCooldown;
        }
        SummonUtil.healOverTime((LivingEntity)this);
        if (!this.level().isClientSide && this.level().getGameTime() % 10L == 0L && this.getName().getString().toLowerCase(Locale.ROOT).equals("jeb_")) {
            this.entityData.set(COLOR, (Object)Variants.random().toString());
        }
        if (this.level().isClientSide && this.isChanneling() && this.getChannelEntity() != -1) {
            Entity entity = this.level().getEntity(this.getChannelEntity());
            if (entity == null || entity.isRemoved()) {
                return;
            }
            Vec3 vec = entity.position();
            this.level().addParticle(GlowParticleData.createData((ParticleColor)MermaidTile.shrineParticle), (double)((float)vec.x) - Math.sin((double)ClientInfo.ticksInGame / 8.0), (double)((float)vec.y) + Math.sin((double)ClientInfo.ticksInGame / 5.0) / 8.0 + 0.5, (double)((float)vec.z) - Math.cos((double)ClientInfo.ticksInGame / 8.0), 0.0, 0.0, 0.0);
        }
    }

    public void die(@NotNull DamageSource source) {
        if (!this.level().isClientSide && this.isTamed()) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.SIREN_CHARM.get());
            stack.set((Supplier)DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)new PersistentFamiliarData().setColor(this.getColor()).setName(this.getCustomName()));
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack));
        }
        super.die(source);
    }

    public boolean hurt(@Nonnull DamageSource source, float p_70097_2_) {
        return SummonUtil.canSummonTakeDamage((DamageSource)source) && super.hurt(source, p_70097_2_);
    }

    public boolean checkSpawnObstruction(LevelReader pLevel) {
        return pLevel.isUnobstructed((Entity)this);
    }

    public int getMaxAirSupply() {
        return 6000;
    }

    public boolean removeWhenFarAway(double dist) {
        return !this.isTamed();
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    public int getBaseExperienceReward() {
        return 0;
    }

    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.isRemoved()) {
            return false;
        }
        if (!this.level().isClientSide && this.isTamed()) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.SIREN_CHARM.get());
            stack.set((Supplier)DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)new PersistentFamiliarData().setColor(this.getColor()).setName(this.getCustomName()));
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack));
            ParticleUtil.spawnPoof((ServerLevel)((ServerLevel)this.level()), (BlockPos)this.blockPosition());
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        return this.isTamed();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "idle", 0, this::idle));
        this.actions = new AnimationController((GeoAnimatable)this, "actions", 10, e -> e.setAndContinue(this.getDeltaMovement().length() > 0.0 || this.level().isClientSide && PatchouliHandler.isPatchouliWorld() ? this.swim : this.idle));
        data.add(this.actions);
    }

    private PlayState idle(AnimationState<MermaidEntity> event) {
        PlayState result = PlayState.CONTINUE;
        if (this.level().isClientSide && PatchouliHandler.isPatchouliWorld()) {
            event.setAndContinue(RawAnimation.begin().thenLoop("ground"));
        } else if (this.isJumping()) {
            event.setAndContinue(RawAnimation.begin().thenLoop("jump"));
        } else if (this.getDeltaMovement().y > 0.3) {
            this.setJump(true);
            event.setAndContinue(RawAnimation.begin().thenLoop("jump"));
        } else if (this.onGround() && !this.isInWater()) {
            event.setAndContinue(RawAnimation.begin().thenLoop("ground"));
        } else {
            event.setAndContinue(RawAnimation.begin().thenLoop("floating"));
        }
        return result;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public static AttributeSupplier createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FOLLOW_RANGE, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.4f).add(Attributes.STEP_HEIGHT, 1.5).build();
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HOME, Optional.empty());
        builder.define(TAMED, (Object)false);
        builder.define(JUMPING, (Object)false);
        builder.define(COLOR, (Object)Variants.random().toString());
        builder.define(CHANNELING, (Object)false);
        builder.define(CHANNELING_ENTITY, (Object)-1);
    }

    public boolean isJumping() {
        return (Boolean)this.entityData.get(JUMPING);
    }

    public void setJump(boolean is) {
        this.entityData.set(JUMPING, (Object)is);
    }

    public boolean isTamed() {
        return (Boolean)this.entityData.get(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.entityData.set(TAMED, (Object)tamed);
    }

    public void setHome(BlockPos home) {
        this.entityData.set(HOME, Optional.of(home));
    }

    @Nullable
    public BlockPos getHome() {
        return ((Optional)this.entityData.get(HOME)).orElse(null);
    }

    @Nullable
    public MermaidTile getShrine() {
        BlockEntity blockEntity;
        BlockPos homePos = this.getHome();
        if (homePos == null || !((blockEntity = this.level().getBlockEntity(homePos)) instanceof MermaidTile)) {
            return null;
        }
        MermaidTile shrine = (MermaidTile)blockEntity;
        return shrine;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        NBTUtil.storeBlockPos((CompoundTag)tag, (String)"home", (BlockPos)this.getHome());
        tag.putBoolean("tamed", ((Boolean)this.entityData.get(TAMED)).booleanValue());
        tag.putString("color", (String)this.entityData.get(COLOR));
        tag.putBoolean("channeling", ((Boolean)this.entityData.get(CHANNELING)).booleanValue());
        tag.putInt("cooldown", this.channelCooldown);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (NBTUtil.hasBlockPos((CompoundTag)tag, (String)"home")) {
            this.entityData.set(HOME, Optional.of(NBTUtil.getBlockPos((CompoundTag)tag, (String)"home")));
        }
        this.setTamed(tag.getBoolean("tamed"));
        this.entityData.set(COLOR, (Object)tag.getString("color"));
        this.channelCooldown = tag.getInt("cooldown");
    }

    public int getMaxSpawnClusterSize() {
        return 3;
    }

    public static boolean checkSurfaceWaterAnimalSpawnRules(LevelAccessor levelAccessor, BlockPos pos) {
        int i = levelAccessor.getSeaLevel() + 15;
        int j = i - 30;
        boolean f1 = pos.getY() >= j && pos.getY() <= i;
        boolean beach = (levelAccessor.getBlockState(pos.below()).is(BlockTags.DIRT) || levelAccessor.getBlockState(pos.below()).is(Blocks.SAND) || levelAccessor.getBlockState(pos.below()).is(Blocks.SANDSTONE)) && levelAccessor.getRawBrightness(pos, 0) > 8;
        boolean sea = levelAccessor.getFluidState(pos.below()).is(FluidTags.WATER) && levelAccessor.getBlockState(pos.above()).is(Blocks.WATER);
        return f1 && (beach || sea);
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new MermaidPathNavigation<MermaidEntity>(this, pLevel);
    }

    public void startAnimation(int arg) {
    }

    public boolean isPushedByFluid(@NotNull FluidType type) {
        return false;
    }

    public boolean isChanneling() {
        return (Boolean)this.entityData.get(CHANNELING);
    }

    public void setChanneling(boolean channeling) {
        this.entityData.set(CHANNELING, (Object)channeling);
    }

    public int getChannelEntity() {
        return (Integer)this.entityData.get(CHANNELING_ENTITY);
    }

    public void setChannelingEntity(int entityID) {
        this.entityData.set(CHANNELING_ENTITY, (Object)entityID);
    }

    public void travel(@NotNull Vec3 pTravelVector) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), pTravelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(pTravelVector);
        }
    }

    protected void customServerAiStep() {
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        MermaidAi.updateActivity(this);
    }

    public void aiStep() {
        super.aiStep();
        if (this.isJumping() && this.animTicks <= 30) {
            ++this.animTicks;
        }
        if (this.animTicks > 30) {
            this.setJump(false);
            this.animTicks = 0;
            if (!this.isTamed() && this.taming) {
                this.taming = false;
                ItemStack stack = new ItemStack((ItemLike)ModItems.SIREN_SHARDS.get(), 1 + this.level().random.nextInt(2));
                stack.set((Supplier)DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)new PersistentFamiliarData().setColor(this.getColor()).setName(this.getCustomName()));
                this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), stack));
                ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)((PlayerTrigger)ANCriteriaTriggers.POOF_MOB.get()), (ServerLevel)((ServerLevel)this.level()), (BlockPos)this.getOnPos(), (int)10);
                this.remove(Entity.RemovalReason.DISCARDED);
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ILLUSIONER_MIRROR_MOVE, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    @NotNull
    public InteractionResult interactAt(@NotNull Player pPlayer, @NotNull Vec3 pVec, @NotNull InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND || pPlayer.getCommandSenderWorld().isClientSide) {
            return InteractionResult.PASS;
        }
        ItemStack stack = pPlayer.getItemInHand(hand);
        if (this.isTamed()) {
            String color = Variants.getColorFromStack(stack);
            if (color != null && !this.getColor().equals(color)) {
                this.setColor(color);
                stack.shrink(1);
                return InteractionResult.SUCCESS;
            }
        } else if (stack.getItem() == Items.SEA_PICKLE && !this.taming) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.8, 0.0));
            this.setJump(true);
            this.markHurt();
            this.taming = true;
            stack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        return super.interactAt(pPlayer, pVec, hand);
    }

    public void fromCharmData(PersistentFamiliarData data) {
        this.setColor(data.color());
        this.setCustomName(data.name());
    }

    public String getColor() {
        return (String)this.entityData.get(COLOR);
    }

    public void setColor(String color) {
        this.entityData.set(COLOR, (Object)color);
    }

    public ResourceLocation getTexture() {
        return ArsElemental.prefix("textures/entity/mermaid_" + (this.getColor().isEmpty() ? Variants.KELP.toString() : this.getColor()) + ".png");
    }

    public static enum Variants {
        KELP,
        BUBBLE,
        FIRE,
        TUBE,
        HORN,
        BRAIN;


        public static String getColorFromStack(ItemStack stack) {
            if (stack.getItem() == Items.KELP) {
                return KELP.toString();
            }
            if (stack.getItem() == Items.BUBBLE_CORAL) {
                return BUBBLE.toString();
            }
            if (stack.getItem() == Items.HORN_CORAL) {
                return HORN.toString();
            }
            if (stack.getItem() == Items.TUBE_CORAL) {
                return TUBE.toString();
            }
            if (stack.getItem() == Items.FIRE_CORAL) {
                return FIRE.toString();
            }
            if (stack.getItem() == Items.BRAIN_CORAL) {
                return BRAIN.toString();
            }
            return null;
        }

        public static Variants random() {
            Map<Integer, Variants> ordinalMap = Arrays.stream(Variants.values()).collect(Collectors.toMap(Enum::ordinal, var -> var, (a, b) -> b));
            return ordinalMap.get(mermaidRandom.nextInt(ordinalMap.size()));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class MermaidPathNavigation<E extends PathfinderMob>
    extends WaterBoundPathNavigation {
        public MermaidPathNavigation(E p_149218_, Level p_149219_) {
            super(p_149218_, p_149219_);
        }

        protected boolean canUpdatePath() {
            return true;
        }

        @NotNull
        protected PathFinder createPathFinder(int p_149222_) {
            this.nodeEvaluator = new AmphibiousNodeEvaluator(true);
            return new PathFinder(this.nodeEvaluator, p_149222_);
        }
    }
}

