/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.client;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.client.CurioHolderScreen;
import alexthw.ars_elemental.client.ElementalTurretRenderer;
import alexthw.ars_elemental.client.PrismRenderer;
import alexthw.ars_elemental.client.SpikeRenderer;
import alexthw.ars_elemental.client.firenando.FirenandoFamiliarRenderer;
import alexthw.ars_elemental.client.firenando.FirenandoRenderer;
import alexthw.ars_elemental.client.mages.MageRenderer;
import alexthw.ars_elemental.client.mermaid.MermaidRenderer;
import alexthw.ars_elemental.client.particle.SparkParticle;
import alexthw.ars_elemental.client.particle.VenomParticle;
import alexthw.ars_elemental.client.summons.DireWolfRenderer;
import alexthw.ars_elemental.common.CasterHolderContainer;
import alexthw.ars_elemental.common.CurioHolderContainer;
import alexthw.ars_elemental.common.entity.spells.EntityLerpedProjectile;
import alexthw.ars_elemental.common.items.CurioHolder;
import alexthw.ars_elemental.network.OpenCurioBagPacket;
import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.registry.ModParticles;
import alexthw.ars_elemental.registry.ModRegistry;
import alexthw.ars_elemental.registry.ModTiles;
import com.hollingsworth.arsnouveau.api.item.inv.SlotReference;
import com.hollingsworth.arsnouveau.client.renderer.entity.RenderSpell;
import com.hollingsworth.arsnouveau.client.renderer.entity.RenderSummonSkeleton;
import com.hollingsworth.arsnouveau.client.renderer.entity.WealdWalkerModel;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.network.Networking;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.CamelRenderer;
import net.minecraft.client.renderer.entity.DolphinRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LightningBoltRenderer;
import net.minecraft.client.renderer.entity.StriderRenderer;
import net.minecraft.client.renderer.entity.UndeadHorseRenderer;
import net.minecraft.client.renderer.entity.VexRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

@EventBusSubscriber(modid="ars_elemental", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    static final ResourceLocation SkeletalHorseTexture = ResourceLocation.withDefaultNamespace((String)"textures/entity/horse/horse_skeleton.png");
    static final ResourceLocation VhexTexture = ArsElemental.prefix("textures/entity/vhex.png");
    public static final KeyMapping CURIO_BAG_KEYBINDING = new KeyMapping("key.ars_elemental.open_pouch", 74, "key.category.ars_nouveau.general");

    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticles.SPARK.get(), SparkParticle::factory);
        event.registerSpriteSet((ParticleType)ModParticles.VENOM.get(), VenomParticle::factory);
    }

    @SubscribeEvent
    public static void bindRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModTiles.ELEMENTAL_TURRET.get(), ElementalTurretRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModTiles.ADVANCED_PRISM.get(), PrismRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SIREN_ENTITY.get(), MermaidRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SIREN_FAMILIAR.get(), MermaidRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.FIRENANDO_ENTITY.get(), FirenandoRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.FIRENANDO_FAMILIAR.get(), FirenandoFamiliarRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.SKELEHORSE_SUMMON.get(), manager -> new UndeadHorseRenderer(manager, ModelLayers.SKELETON_HORSE){

            @NotNull
            public ResourceLocation getTextureLocation(@NotNull AbstractHorse pEntity) {
                return SkeletalHorseTexture;
            }
        });
        event.registerEntityRenderer((EntityType)ModEntities.CAMEL_SUMMON.get(), manager -> new CamelRenderer(manager, ModelLayers.CAMEL));
        event.registerEntityRenderer((EntityType)ModEntities.DIREWOLF_SUMMON.get(), DireWolfRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.WSKELETON_SUMMON.get(), renderManagerIn -> new RenderSummonSkeleton(renderManagerIn){

            @NotNull
            public ResourceLocation getTextureLocation(@NotNull AbstractSkeleton entity) {
                return ResourceLocation.withDefaultNamespace((String)"textures/entity/skeleton/wither_skeleton.png");
            }
        });
        event.registerEntityRenderer((EntityType)ModEntities.DOLPHIN_SUMMON.get(), DolphinRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.STRIDER_SUMMON.get(), StriderRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.VHEX_SUMMON.get(), manager -> new VexRenderer(manager){

            @NotNull
            public ResourceLocation getTextureLocation(@NotNull Vex p_110775_1_) {
                return VhexTexture;
            }
        });
        event.registerEntityRenderer((EntityType)ModEntities.FLASHING_WEALD_WALKER.get(), v -> new GeoEntityRenderer(v, (GeoModel)new WealdWalkerModel("flashing_weald")));
        event.registerEntityRenderer((EntityType)ModEntities.FIRE_MAGE.get(), MageRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.WATER_MAGE.get(), MageRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.AIR_MAGE.get(), MageRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.EARTH_MAGE.get(), MageRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.LINGER_MAGNET.get(), ClientEvents::projectileRender);
        event.registerEntityRenderer((EntityType)ModEntities.FLASH_LIGHTNING.get(), LightningBoltRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.DRIPSTONE_SPIKE.get(), SpikeRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ICE_SPIKE.get(), renderManager -> new SpikeRenderer(renderManager, ArsElemental.prefix("textures/entity/ice_spike.png")));
        event.registerEntityRenderer((EntityType)ModEntities.LERP_PROJECTILE.get(), m -> new EntityRenderer<EntityLerpedProjectile>(m){

            @NotNull
            public ResourceLocation getTextureLocation(@NotNull EntityLerpedProjectile pEntity) {
                return ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"textures/entity/spell_proj.png");
            }
        });
    }

    @SubscribeEvent
    public static void initItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, color) -> color > 0 ? -1 : ((DyeColor)stack.getOrDefault(DataComponents.BASE_COLOR, (Object)DyeColor.RED)).getTextureDiffuseColor() + -16777216, new ItemLike[]{(ItemLike)ModItems.CASTER_BAG.get()});
    }

    @SubscribeEvent
    public static void registerKeyBindings(RegisterKeyMappingsEvent event) {
        event.register(CURIO_BAG_KEYBINDING);
    }

    @SubscribeEvent
    public static void bindContainerRenderers(RegisterMenuScreensEvent event) {
        event.register((MenuType)ModRegistry.CURIO_HOLDER.get(), (screenContainer, inv, titleIn) -> new CurioHolderScreen<CurioHolderContainer>((CurioHolderContainer)screenContainer, inv, titleIn, ArsElemental.prefix("textures/gui/curio_bag.png"), 175, 163));
        event.register((MenuType)ModRegistry.CASTER_HOLDER.get(), (screenContainer, inv, titleIn) -> new CurioHolderScreen<CasterHolderContainer>((CasterHolderContainer)screenContainer, inv, titleIn, ArsElemental.prefix("textures/gui/curio_bag_2.png"), 175, 217));
    }

    @NotNull
    private static EntityRenderer<EntityProjectileSpell> projectileRender(EntityRendererProvider.Context renderManager) {
        return new RenderSpell(renderManager, ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"textures/entity/spell_proj.png"));
    }

    public void openBackpackGui(ClientTickEvent.Post event) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            SlotReference backpack;
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer playerEntity = minecraft.player;
            if (!(minecraft.screen instanceof CurioHolderScreen) && playerEntity != null && CURIO_BAG_KEYBINDING.isDown() && !(backpack = CurioHolder.isEquipped((Player)playerEntity)).isEmpty()) {
                Networking.sendToServer((CustomPacketPayload)new OpenCurioBagPacket());
            }
        }
    }
}

