/*
 * Decompiled with CFR 0.152.
 */
package lyrellion.ars_elemancy.util;

import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.IFilter;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.NotNull;

public class GlyphEffectUtil {
    public static void placeBlocks(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver, BlockState toPlace) {
        for (BlockPos pos : SpellUtil.calcAOEBlocks((LivingEntity)shooter, (BlockPos)rayTraceResult.getBlockPos(), (BlockHitResult)rayTraceResult, (SpellStats)spellStats)) {
            BlockState state;
            pos = rayTraceResult.isInside() ? pos : pos.relative(rayTraceResult.getDirection());
            if (!BlockUtil.destroyRespectsClaim((Entity)shooter, (Level)world, (BlockPos)pos) || !(state = world.getBlockState(pos)).canBeReplaced() || !world.isUnobstructed(toPlace, pos, CollisionContext.of((Entity)shooter))) continue;
            world.setBlockAndUpdate(pos, toPlace);
            ShapersFocus.tryPropagateBlockSpell((BlockHitResult)new BlockHitResult(new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5), rayTraceResult.getDirection(), pos, false), (Level)world, (Entity)shooter, (SpellContext)spellContext, (SpellResolver)resolver);
        }
    }

    public static boolean hasFollowingEffect(SpellContext spellContext, AbstractEffect toFind) {
        for (AbstractSpellPart part : spellContext.getSpell().unsafeList().subList(spellContext.getCurrentIndex(), spellContext.getSpell().size())) {
            if (!(part instanceof AbstractEffect)) continue;
            if (part != toFind) break;
            return true;
        }
        return false;
    }

    public static boolean checkIgnoreFilters(Entity e, Set<IFilter> filters) {
        boolean flag = true;
        if (filters == null) {
            return true;
        }
        for (IFilter spellPart : filters) {
            flag &= spellPart.shouldAffect((HitResult)new EntityHitResult(e), e.level());
        }
        return !flag;
    }

    public static Set<IFilter> getFilters(List<AbstractSpellPart> recipe, int index) {
        HashSet<IFilter> list = new HashSet<IFilter>();
        for (AbstractSpellPart glyph : recipe.subList(index, recipe.size())) {
            if (glyph instanceof AbstractCastMethod) continue;
            if (glyph instanceof IFilter) {
                IFilter filter = (IFilter)glyph;
                list.add(filter);
                continue;
            }
            if (!(glyph instanceof AbstractEffect)) continue;
            break;
        }
        return list;
    }

    public static Predicate<Entity> getFilterPredicate(Spell spell, Predicate<Entity> defaultFilter) {
        Set<IFilter> set = GlyphEffectUtil.getFilters(spell.unsafeList(), 0);
        if (set.isEmpty()) {
            return defaultFilter;
        }
        return entity -> !GlyphEffectUtil.checkIgnoreFilters(entity, set);
    }
}

