/*
 * Decompiled with CFR 0.152.
 */
package lyrellion.ars_elemancy.datagen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import lyrellion.ars_elemancy.datagen.AEAdvancementsProvider;
import lyrellion.ars_elemancy.datagen.AEApparatusProvider;
import lyrellion.ars_elemancy.datagen.AEBlockStateProvider;
import lyrellion.ars_elemancy.datagen.AECasterTomeProvider;
import lyrellion.ars_elemancy.datagen.AECurioProvider;
import lyrellion.ars_elemancy.datagen.AEGlyphProvider;
import lyrellion.ars_elemancy.datagen.AEImbuementProvider;
import lyrellion.ars_elemancy.datagen.AEItemModelProvider;
import lyrellion.ars_elemancy.datagen.AELootTables;
import lyrellion.ars_elemancy.datagen.AEPatchouliProvider;
import lyrellion.ars_elemancy.datagen.AETagsProvider;
import lyrellion.ars_elemancy.datagen.ModRecipeProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="ars_elemancy", bus=EventBusSubscriber.Bus.MOD)
public class Datagen {
    public static CompletableFuture<HolderLookup.Provider> provider;
    public static PackOutput output;

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        provider = event.getLookupProvider();
        output = gen.getPackOutput();
        gen.addProvider(event.includeClient(), (DataProvider)new AEBlockStateProvider(gen, existingFileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new AEItemModelProvider(gen, existingFileHelper));
        AETagsProvider.AEBlockTagsProvider BTP = new AETagsProvider.AEBlockTagsProvider(gen, provider, existingFileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)BTP);
        gen.addProvider(event.includeServer(), (DataProvider)new AETagsProvider.AEItemTagsProvider(gen, provider, BTP, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new AETagsProvider.AEEntityTagProvider(gen, provider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new AETagsProvider.AEDamageTypeProvider(gen, provider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(gen, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new AELootTables(gen, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new AEImbuementProvider(gen));
        gen.addProvider(event.includeServer(), (DataProvider)new AEGlyphProvider(gen));
        gen.addProvider(event.includeServer(), (DataProvider)new AEApparatusProvider(gen));
        gen.addProvider(event.includeServer(), (DataProvider)new AEPatchouliProvider(gen));
        gen.addProvider(event.includeServer(), (DataProvider)new AECurioProvider(output, existingFileHelper, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new AEAdvancementsProvider(output, provider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new AECasterTomeProvider(gen));
    }

    public static <T> Collection<T> takeAll(Collection<T> src, Predicate<T> predicate) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!predicate.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            return Collections.emptyList();
        }
        return ret;
    }
}

