/*
 * Decompiled with CFR 0.152.
 */
package lyrellion.ars_elemancy.common.items.armor;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.registries.DeferredRegister;

public class AAMaterials {
    public static final DeferredRegister<ArmorMaterial> A_MATERIALS = DeferredRegister.create((Registry)BuiltInRegistries.ARMOR_MATERIAL, (String)"ars_elemancy");
    public static final EnumMap<ArmorItem.Type, Integer> ARMOR_SLOT_PROTECTION = (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 2);
        map.put(ArmorItem.Type.LEGGINGS, 5);
        map.put(ArmorItem.Type.CHESTPLATE, 6);
        map.put(ArmorItem.Type.HELMET, 2);
        map.put(ArmorItem.Type.BODY, 4);
    });
    public static final Holder<ArmorMaterial> FIRE = A_MATERIALS.register("medium_fire", () -> new ArmorMaterial(ARMOR_SLOT_PROTECTION, 40, (Holder)new Holder.Direct((Object)SoundEvents.GENERIC_BURN), () -> Ingredient.EMPTY, List.of(), 2.0f, 0.0f));
    public static final Holder<ArmorMaterial> WATER = A_MATERIALS.register("medium_water", () -> new ArmorMaterial(ARMOR_SLOT_PROTECTION, 40, (Holder)new Holder.Direct((Object)SoundEvents.BREWING_STAND_BREW), () -> Ingredient.EMPTY, List.of(), 2.0f, 0.0f));
    public static final Holder<ArmorMaterial> EARTH = A_MATERIALS.register("medium_earth", () -> new ArmorMaterial(ARMOR_SLOT_PROTECTION, 40, (Holder)new Holder.Direct((Object)SoundEvents.ANVIL_PLACE), () -> Ingredient.EMPTY, List.of(), 2.0f, 0.02f));
    public static final Holder<ArmorMaterial> AIR = A_MATERIALS.register("medium_air", () -> new ArmorMaterial(ARMOR_SLOT_PROTECTION, 40, SoundEvents.ARMOR_EQUIP_ELYTRA, () -> Ingredient.EMPTY, List.of(), 2.0f, 0.0f));
    public static final Holder<ArmorMaterial> TEMPEST = AAMaterials.registerMerged("tempest", (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_ELYTRA, () -> Ingredient.EMPTY, List.of(), AIR, WATER);
    public static final Holder<ArmorMaterial> SILT = AAMaterials.registerMerged("silt", (Holder<SoundEvent>)new Holder.Direct((Object)SoundEvents.ANVIL_PLACE), () -> Ingredient.EMPTY, List.of(), AIR, EARTH);
    public static final Holder<ArmorMaterial> MIRE = AAMaterials.registerMerged("mire", (Holder<SoundEvent>)new Holder.Direct((Object)SoundEvents.ANVIL_PLACE), () -> Ingredient.EMPTY, List.of(), EARTH, WATER);
    public static final Holder<ArmorMaterial> VAPOR = AAMaterials.registerMerged("vapor", (Holder<SoundEvent>)new Holder.Direct((Object)SoundEvents.GENERIC_BURN), () -> Ingredient.EMPTY, List.of(), FIRE, WATER);
    public static final Holder<ArmorMaterial> LAVA = AAMaterials.registerMerged("lava", (Holder<SoundEvent>)new Holder.Direct((Object)SoundEvents.GENERIC_BURN), () -> Ingredient.EMPTY, List.of(), FIRE, EARTH);
    public static final Holder<ArmorMaterial> CINDER = AAMaterials.registerMerged("cinder", (Holder<SoundEvent>)new Holder.Direct((Object)SoundEvents.GENERIC_BURN), () -> Ingredient.EMPTY, List.of(), AIR, FIRE);
    public static final Holder<ArmorMaterial> ELEMANCER = AAMaterials.registerMerged("elemancer", (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GENERIC, () -> Ingredient.EMPTY, List.of(), FIRE, WATER, EARTH, AIR);

    @SafeVarargs
    private static Holder<ArmorMaterial> registerMerged(String name, Holder<SoundEvent> equipSound, Supplier<Ingredient> repairIngredient, List<ArmorMaterial.Layer> layers, Holder<ArmorMaterial> ... materials) {
        return switch (materials.length) {
            case 0 -> throw new RuntimeException("registerMerged was called with 0 materials to merge");
            case 1 -> materials[0];
            default -> A_MATERIALS.register(name, () -> {
                ArmorMaterial first = (ArmorMaterial)materials[0].value();
                HashMap<ArmorItem.Type, Integer> defense = new HashMap<ArmorItem.Type, Integer>(first.defense());
                int enchantmentValue = first.enchantmentValue();
                float toughness = first.toughness();
                float knockbackResistance = first.knockbackResistance();
                for (int i = 1; i < materials.length; ++i) {
                    ArmorMaterial next = (ArmorMaterial)materials[i].value();
                    for (Map.Entry entry : next.defense().entrySet()) {
                        defense.compute((ArmorItem.Type)entry.getKey(), (k, v) -> Math.max(v, (Integer)entry.getValue()));
                    }
                    enchantmentValue = Math.max(enchantmentValue, next.enchantmentValue());
                    toughness = Math.max(toughness, next.toughness());
                    knockbackResistance = Math.max(knockbackResistance, next.knockbackResistance());
                }
                int finalEnchantmentValue = enchantmentValue;
                float finalToughness = toughness;
                float finalKnockbackResistance = knockbackResistance;
                return new ArmorMaterial(defense, finalEnchantmentValue, equipSound, repairIngredient, layers, finalToughness, finalKnockbackResistance);
            });
        };
    }
}

