/*
 * Decompiled with CFR 0.152.
 */
package lyrellion.ars_elemancy;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    public static final Common COMMON;
    public static final ModConfigSpec COMMON_SPEC;
    public static final Client CLIENT;
    public static final ModConfigSpec CLIENT_SPEC;

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        Pair specClientPair = new ModConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ModConfigSpec)specClientPair.getRight();
        CLIENT = (Client)specClientPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.ConfigValue<Double> MajorFocusDiscount;
        public final ModConfigSpec.ConfigValue<Boolean> EnableRegenBonus;
        public static ModConfigSpec.IntValue ARMOR_MAX_MANA;
        public static ModConfigSpec.IntValue ARMOR_MANA_REGEN;

        public Common(ModConfigSpec.Builder builder) {
            builder.comment("Enable or disable the passive bonus of the foci").push("Elemental Spell Foci - Abilities");
            this.MajorFocusDiscount = builder.comment("Adjust this value to define how much the matching spell cost gets discounted by the greater focus").defineInRange("elemental_maj_focus_discount", 0.25, 0.0, 0.99);
            this.EnableRegenBonus = builder.comment("Enable regen bonus under special conditions").define("regen_bonus", true);
            builder.pop();
            builder.comment("Adjust these values to balance how much a spell gets amplified by the matching spell focus, doubled for major foci.").push("Elemental Spell Foci - Amplify");
            builder.comment("Adjust Elemental Armor Mana Buffs").push("Elemental Armors");
            ARMOR_MAX_MANA = builder.comment("Max mana bonus for each elemental armor piece").defineInRange("armorMaxMana", 100, 0, 10000);
            ARMOR_MANA_REGEN = builder.comment("Mana regen bonus for each elemental armor piece").defineInRange("armorManaRegen", 4, 0, 100);
            builder.pop();
        }
    }

    public static class Client {
        public static ModConfigSpec.ConfigValue<Boolean> EnableSFRendering;

        public Client(ModConfigSpec.Builder builder) {
            builder.push("Visual Configs");
            EnableSFRendering = builder.comment("Enables the rendering of the spell focus while equipped").define("Enable SpellFocusRender", true);
            builder.pop();
        }
    }
}

