/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.mixin.wixie;

import com.github.jarva.arsadditions.common.util.IWixieOutputStorage;
import com.hollingsworth.arsnouveau.api.item.inv.FilterableItemHandler;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.recipe.CraftingManager;
import com.hollingsworth.arsnouveau.api.util.InvUtil;
import com.hollingsworth.arsnouveau.api.util.NearbyPlayerCache;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={CraftingManager.class})
public class CraftingManagerMixin {
    @WrapOperation(method={"completeCraft"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z")})
    private boolean onCompleteCraft(Level instance, Entity entity, Operation<Boolean> original, @Local(argsOnly=true) WixieCauldronTile tile) {
        if (tile instanceof IWixieOutputStorage) {
            IWixieOutputStorage storage = (IWixieOutputStorage)tile;
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                BlockPos pos = storage.ars_additions$getOutputStorage();
                if (pos == null) {
                    return (Boolean)original.call(new Object[]{instance, entity});
                }
                ItemStack item = itemEntity.getItem();
                if (item.isEmpty()) {
                    return (Boolean)original.call(new Object[]{instance, entity});
                }
                @Nullable IItemHandler capability = (IItemHandler)instance.getCapability(Capabilities.ItemHandler.BLOCK, pos, null);
                if (capability == null) {
                    storage.ars_additions$setOutputStorage(null);
                    return (Boolean)original.call(new Object[]{instance, entity});
                }
                FilterableItemHandler handler = new FilterableItemHandler(capability, InvUtil.filtersOnTile((BlockEntity)tile));
                InventoryManager manager = new InventoryManager(List.of(handler));
                ItemStack rem = manager.insertStack(item);
                if (!rem.isEmpty()) {
                    itemEntity.setItem(rem);
                    return (Boolean)original.call(new Object[]{instance, entity});
                }
                if (instance instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)instance;
                    this.spawnFlyingItem(serverLevel, pos, tile.getBlockPos(), item.copy());
                }
                return true;
            }
        }
        return (Boolean)original.call(new Object[]{instance, entity});
    }

    private void spawnFlyingItem(ServerLevel level, BlockPos to, BlockPos from, ItemStack stack) {
        if (!NearbyPlayerCache.isPlayerNearby((BlockPos)to, (ServerLevel)level, (int)64)) {
            return;
        }
        BlockPos above = from.above();
        EntityFlyingItem flyingItem = new EntityFlyingItem((Level)level, new Vec3((double)above.getX() + 0.5, (double)above.getY(), (double)above.getZ() + 0.5).add(ParticleUtil.inRange((double)-0.25, (double)0.25), 0.0, ParticleUtil.inRange((double)-0.25, (double)0.25)), new Vec3((double)to.getX() + 0.5, (double)to.getY(), (double)to.getZ() + 0.5).add(ParticleUtil.inRange((double)-0.25, (double)0.25), 0.0, ParticleUtil.inRange((double)-0.25, (double)0.25)));
        flyingItem.getEntityData().set(EntityFlyingItem.HELD_ITEM, (Object)stack.copy());
        level.addFreshEntity((Entity)flyingItem);
    }
}

