/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen.recipes;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.recipe.imbuement.BulkScribingRecipe;
import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;

public class BulkScribingProvider
extends SimpleDataProvider {
    public List<BulkScribingRecipe> recipes = new ArrayList<BulkScribingRecipe>();

    public BulkScribingProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput pOutput) {
        this.addEntries();
        for (BulkScribingRecipe recipe : this.recipes) {
            Path path = BulkScribingProvider.getRecipePath(this.output, recipe.id().getPath());
            BulkScribingRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)recipe).result().ifPresent(json -> this.saveStable(pOutput, (JsonElement)json, path));
        }
    }

    protected void addEntries() {
        this.addEntry("bulk_scriber");
    }

    private void addEntry(String id) {
        this.recipes.add(new BulkScribingRecipe(ArsAdditions.prefix(id)));
    }

    protected static Path getRecipePath(Path path, String id) {
        return path.resolve("data/ars_additions/recipe/bulk_scribing/" + id + ".json");
    }

    public String getName() {
        return "Bulk Scribing Datagen";
    }
}

