/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen.client;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.github.jarva.arsadditions.setup.registry.names.AddonBlockNames;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.common.block.SconceBlock;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.items.PerkItem;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemRegistryWrapper;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class BlockStateDatagen
extends BlockStateProvider {
    private final ExistingFileHelper fileHelper;

    public BlockStateDatagen(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "ars_additions", exFileHelper);
        this.fileHelper = exFileHelper;
    }

    /*
     * WARNING - void declaration
     */
    protected void registerStatesAndModels() {
        void var5_30;
        void var5_28;
        void var5_26;
        Block[] decorativeSourcestone;
        for (Supplier supplier : GlyphRegistry.getGlyphItemMap().values()) {
            ResourceLocation spellPart = ((Glyph)supplier.get()).spellPart.getRegistryName();
            if (!spellPart.getNamespace().equals("ars_additions")) continue;
            this.itemModels().basicItem(spellPart);
        }
        for (RitualTablet ritualTablet : RitualRegistry.getRitualItemMap().values()) {
            ResourceLocation ritualName = ritualTablet.ritual.getRegistryName();
            if (!ritualName.getNamespace().equals("ars_additions")) continue;
            this.itemModels().basicItem((Item)ritualTablet);
        }
        for (PerkItem perkItem : PerkRegistry.getPerkItemMap().values()) {
            ResourceLocation perkName = perkItem.perk.getRegistryName();
            if (!perkName.getNamespace().equals("ars_additions")) continue;
            this.itemModels().basicItem((Item)perkItem);
        }
        for (ItemRegistryWrapper itemRegistryWrapper : AddonItemRegistry.DATAGEN_ITEMS) {
            this.itemModels().basicItem((Item)itemRegistryWrapper.get());
        }
        for (Block block : decorativeSourcestone = AddonBlockRegistry.getBlocks(AddonBlockNames.DECORATIVE_SOURCESTONES)) {
            this.simpleBlockWithItem(block);
        }
        this.simpleBlockWithItem((Block)AddonBlockRegistry.SOURCE_SPAWNER.get(), "cutout");
        this.wallBlockAndItem("sourcestone_wall", ArsNouveau.prefix((String)"sourcestone_large_bricks"));
        this.wallBlockAndItem("polished_sourcestone_wall", ArsNouveau.prefix((String)"smooth_sourcestone_large_bricks"));
        this.wallBlockAndItem("cracked_sourcestone_wall", ArsAdditions.prefix("cracked_sourcestone"));
        this.wallBlockAndItem("cracked_polished_sourcestone_wall", ArsAdditions.prefix("cracked_polished_sourcestone"));
        this.buttonBlockAndItem("sourcestone_button", ArsNouveau.prefix((String)"sourcestone"));
        this.buttonBlockAndItem("polished_sourcestone_button", ArsNouveau.prefix((String)"smooth_sourcestone"));
        for (String string : AddonBlockNames.LANTERNS) {
            this.lanternAndItem(string);
        }
        for (String string : AddonBlockNames.MAGELIGHT_LANTERNS) {
            this.lanternAndItem(string);
        }
        for (String string : AddonBlockNames.CHAINS) {
            this.chainAndItem(string);
        }
        ModelFile.ExistingModelFile existingModelFile = new ModelFile.ExistingModelFile(this.getTextureLoc((Block)BlockRegistry.ENCHANTING_APP_BLOCK.get()), this.fileHelper);
        this.getVariantBuilder((Block)AddonBlockRegistry.WIXIE_ENCHANTING.get()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)existingModelFile)});
        this.simpleBlockItem((Block)AddonBlockRegistry.WIXIE_ENCHANTING.get(), (ModelFile)new ModelFile.ExistingModelFile(this.key((Block)BlockRegistry.ENCHANTING_APP_BLOCK.get()).withPrefix("item/"), this.fileHelper));
        String[] stringArray = AddonBlockNames.DOORS;
        int n = stringArray.length;
        boolean bl = false;
        while (var5_26 < n) {
            String door = stringArray[var5_26];
            this.doorAndItem(door);
            ++var5_26;
        }
        stringArray = AddonBlockNames.TRAPDOORS;
        n = stringArray.length;
        boolean bl2 = false;
        while (var5_28 < n) {
            String trapdoor = stringArray[var5_28];
            this.trapdoorAndItem(trapdoor);
            ++var5_28;
        }
        stringArray = AddonBlockNames.CARPETS;
        n = stringArray.length;
        boolean bl3 = false;
        while (var5_30 < n) {
            String carpet = stringArray[var5_30];
            this.carpetAndItem(carpet);
            ++var5_30;
        }
    }

    private void carpetAndItem(String carpetName) {
        CarpetBlock block = (CarpetBlock)AddonBlockRegistry.getBlock(carpetName);
        ResourceLocation loc = this.key((Block)block);
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(loc.withPrefix("block/").toString(), this.mcLoc("block/carpet"))).texture("wool", this.getTextureLoc((Block)block));
        this.getVariantBuilder((Block)block).forAllStatesExcept(arg_0 -> BlockStateDatagen.lambda$carpetAndItem$0((ModelFile)model, arg_0), new Property[0]);
        this.itemModels().withExistingParent(loc.withPrefix("item/").toString(), model.getLocation());
    }

    private void simpleBlockWithItem(Block block) {
        this.simpleBlockWithItem(block, null);
    }

    private void simpleBlockWithItem(Block block, String renderType) {
        BlockModelBuilder model = (BlockModelBuilder)this.cubeAll(block);
        if (renderType != null) {
            model = (BlockModelBuilder)model.renderType(renderType);
        }
        this.simpleBlockWithItem(block, (ModelFile)model);
    }

    private void doorAndItem(String doorName) {
        DoorBlock block = (DoorBlock)AddonBlockRegistry.getBlock(doorName);
        this.doorBlockWithRenderType(block, this.getTextureLoc((Block)block).withSuffix("_bottom"), this.getTextureLoc((Block)block).withSuffix("_top"), "cutout");
        this.itemModels().basicItem(block.asItem());
    }

    private void trapdoorAndItem(String trapdoorName) {
        TrapDoorBlock block = (TrapDoorBlock)AddonBlockRegistry.getBlock(trapdoorName);
        this.trapdoorBlockWithRenderType(block, this.getTextureLoc((Block)block), true, "cutout");
        ResourceLocation loc = this.key((Block)block);
        this.itemModels().withExistingParent(loc.toString(), this.getTextureLoc((Block)block).withSuffix("_bottom"));
    }

    private void chainAndItem(String chainName) {
        ChainBlock block = (ChainBlock)AddonBlockRegistry.getBlock(chainName);
        ResourceLocation texture = this.getTextureLoc((Block)block);
        ModelBuilder chain = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.key((Block)block).getPath(), this.mcLoc("block/chain"))).texture("particle", texture)).texture("all", texture)).renderType("cutout");
        this.getVariantBuilder((Block)block).forAllStatesExcept(arg_0 -> BlockStateDatagen.lambda$chainAndItem$1((ModelFile)chain, arg_0), new Property[]{ChainBlock.WATERLOGGED});
        this.itemModels().basicItem(block.asItem());
    }

    private void lanternAndItem(String lanternName) {
        LanternBlock block = (LanternBlock)AddonBlockRegistry.getBlock(lanternName);
        ResourceLocation texture = this.getTextureLoc((Block)block);
        ModelFile lantern = this.lanternModel((Block)block, false, texture);
        ModelFile lanternHanging = this.lanternModel((Block)block, true, texture);
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            boolean hanging = (Boolean)state.getValue((Property)LanternBlock.HANGING);
            return ConfiguredModel.builder().modelFile(hanging ? lanternHanging : lantern).build();
        }, new Property[]{LanternBlock.WATERLOGGED, SconceBlock.LIGHT_LEVEL});
        this.itemModels().basicItem(block.asItem());
    }

    private ModelFile lanternModel(Block block, boolean isHanging, ResourceLocation texture) {
        String path = this.key(block).getPath();
        Object name = isHanging ? path + "_hanging" : path;
        return ((BlockModelBuilder)this.models().singleTexture((String)name, this.mcLoc("block" + (isHanging ? "/template_hanging_lantern" : "/template_lantern")), "lantern", texture)).renderType("cutout");
    }

    private void wallBlockAndItem(String wallName, ResourceLocation texture) {
        WallBlock block = (WallBlock)AddonBlockRegistry.getBlock(wallName);
        texture = texture.withPrefix("block/");
        String name = this.key((Block)block).toString().replace("_wall", "");
        this.wallBlock(block, name, texture);
        ModelBuilder inventory = this.models().wallInventory(name + "_inventory", texture);
        this.simpleBlockItem((Block)block, (ModelFile)inventory);
    }

    private void buttonBlockAndItem(String buttonName, ResourceLocation texture) {
        ButtonBlock block = (ButtonBlock)AddonBlockRegistry.getBlock(buttonName);
        texture = texture.withPrefix("block/");
        String name = this.key((Block)block).toString();
        this.buttonBlock(block, texture);
        ModelBuilder inventory = this.models().buttonInventory(name + "_inventory", texture);
        this.simpleBlockItem((Block)block, (ModelFile)inventory);
    }

    public ResourceLocation key(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public ResourceLocation getTextureLoc(Block block) {
        return this.key(block).withPrefix("block/");
    }

    private static /* synthetic */ ConfiguredModel[] lambda$chainAndItem$1(ModelFile chain, BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)ChainBlock.AXIS);
        return ConfiguredModel.builder().modelFile(chain).rotationX(axis == Direction.Axis.X || axis == Direction.Axis.Z ? 90 : 0).rotationY(axis == Direction.Axis.X ? 90 : 0).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$carpetAndItem$0(ModelFile model, BlockState state) {
        return ConfiguredModel.builder().modelFile(model).build();
    }
}

