/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.recipe.imbuement;

import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonRecipeRegistry;
import com.hollingsworth.arsnouveau.api.imbuement_chamber.IImbuementRecipe;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.ItemCasterProvider;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.common.block.tile.ImbuementTile;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public record ImbueSpellScrollRecipe(ResourceLocation id) implements IImbuementRecipe
{
    public boolean matches(ImbuementTile imbuementTile, Level pLevel) {
        ItemStack reagent = imbuementTile.stack;
        Item item = reagent.getItem();
        if (!(item instanceof ItemCasterProvider)) {
            return false;
        }
        ItemCasterProvider casterProvider = (ItemCasterProvider)item;
        AbstractCaster reagentCaster = casterProvider.getSpellCaster(reagent);
        return imbuementTile.getPedestalItems().isEmpty() && reagent.is((Item)ItemsRegistry.SPELL_PARCHMENT.get()) && reagentCaster.getSpell().isValid();
    }

    public ItemStack assemble(ImbuementTile imbuementTile, HolderLookup.Provider provider) {
        ItemStack result = new ItemStack((ItemLike)AddonItemRegistry.IMBUED_SPELL_PARCHMENT.get());
        result.set((Supplier)DataComponentRegistry.SPELL_CASTER, (Object)((SpellCaster)imbuementTile.stack.get((Supplier)DataComponentRegistry.SPELL_CASTER)));
        return result;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public int getSourceCost(ImbuementTile imbuementTile) {
        ItemStack reagent = imbuementTile.stack;
        Item item = reagent.getItem();
        if (!(item instanceof ItemCasterProvider)) {
            return 10000;
        }
        ItemCasterProvider casterProvider = (ItemCasterProvider)item;
        return casterProvider.getSpellCaster(reagent).getSpell().getCost() * 10;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AddonRecipeRegistry.IMBUE_SCROLL_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)AddonRecipeRegistry.IMBUE_SCROLL_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<ImbueSpellScrollRecipe> {
        public static final MapCodec<ImbueSpellScrollRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(ImbueSpellScrollRecipe::id)).apply((Applicative)instance, ImbueSpellScrollRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ImbueSpellScrollRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ImbueSpellScrollRecipe::id, ImbueSpellScrollRecipe::new);

        public MapCodec<ImbueSpellScrollRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ImbueSpellScrollRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

