/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.client.gui;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.setup.networking.TeleportNexusPacket;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.hollingsworth.arsnouveau.client.gui.Color;
import com.hollingsworth.arsnouveau.common.items.data.WarpScrollData;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.ItemStackHandler;

public class WarpNexusScreen
extends Screen {
    private final ContainerLevelAccess access;
    private final ItemStackHandler handler;
    private int maxScale;
    private float scaleFactor;
    public int leftStart;
    public int topStart = 0;

    public WarpNexusScreen(ContainerLevelAccess access, ItemStackHandler itemStackHandler) {
        super((Component)Component.literal((String)"Warp Nexus"));
        this.access = access;
        this.handler = itemStackHandler;
    }

    protected void init() {
        super.init();
        this.maxScale = this.getMaxAllowedScale();
        this.scaleFactor = 1.0f;
        if (this.minecraft == null) {
            return;
        }
        ClientLevel level = this.minecraft.level;
        if (level == null) {
            return;
        }
        this.leftStart = this.width / 2 - 150;
        int slots = this.handler.getSlots();
        HashMap<Integer, ItemStack> filled = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < slots; ++i) {
            ItemStack scroll = this.handler.getStackInSlot(i);
            if (scroll.is(Items.AIR)) continue;
            filled.put(i, scroll);
        }
        if (filled.isEmpty()) {
            this.minecraft.setScreen(null);
            PortUtil.sendMessage((Entity)this.minecraft.player, (Component)Component.translatable((String)"chat.ars_additions.warp_nexus.no_scrolls"));
            PortUtil.sendMessage((Entity)this.minecraft.player, (Component)Component.translatable((String)"chat.ars_additions.warp_nexus.no_scrolls.instruction", (Object[])new Object[]{this.minecraft.options.keyShift.getKey().getDisplayName(), this.minecraft.options.keyUse.getKey().getDisplayName()}));
            return;
        }
        int n = this.height / 2;
        Objects.requireNonNull(this.font);
        this.topStart = n - (16 + 9 + filled.size() * 25 + 20) / 2;
        int index = 0;
        for (Map.Entry entry : filled.entrySet()) {
            int i = (Integer)entry.getKey();
            ItemStack scroll = (ItemStack)entry.getValue();
            Objects.requireNonNull(this.font);
            this.addRenderableWidget((GuiEventListener)new Button(this, this.leftStart + 50, this.topStart + 16 + 9 + index * 25, 200, 20, this.getDisplayName(scroll), button -> {
                this.access.execute((_level, pos) -> TeleportNexusPacket.teleport(i, pos));
                this.minecraft.setScreen(null);
            }, Supplier::get){
                public static final WidgetSprites SPRITES = new WidgetSprites(ArsAdditions.prefix("widget/button"), ResourceLocation.withDefaultNamespace((String)"widget/button_disabled"), ArsAdditions.prefix("widget/button_highlighted"));

                protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                    Minecraft minecraft = Minecraft.getInstance();
                    guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
                    RenderSystem.enableBlend();
                    RenderSystem.enableDepthTest();
                    guiGraphics.blitSprite(SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
                    guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                    int i = this.getFGColor();
                    this.renderString(guiGraphics, minecraft.font, i | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
                }

                private int getTextureY() {
                    int i = 0;
                    if (!this.active) {
                        i = 2;
                    } else if (this.isHoveredOrFocused()) {
                        i = 1;
                    }
                    return i * 20;
                }
            });
            ++index;
        }
    }

    private Component getDisplayName(ItemStack stack) {
        if (stack.has(DataComponents.CUSTOM_NAME)) {
            return stack.getHoverName();
        }
        WarpScrollData data = (WarpScrollData)stack.getOrDefault((Supplier)DataComponentRegistry.WARP_SCROLL, (Object)new WarpScrollData(null, null, null, true));
        if (!data.isValid()) {
            return stack.getDisplayName();
        }
        BlockPos pos = (BlockPos)data.pos().get();
        return Component.translatable((String)"tooltip.ars_additions.reliquary.marked.location", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()});
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (((Boolean)this.access.evaluate((level, pos) -> !level.getBlockState(pos).is((Block)AddonBlockRegistry.WARP_NEXUS.get()) || this.minecraft.player.blockPosition().distToCenterSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) > Math.pow(this.minecraft.player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue(), 2.0), (Object)true)).booleanValue()) {
            this.minecraft.setScreen(null);
            return;
        }
        PoseStack matrixStack = guiGraphics.pose();
        matrixStack.pushPose();
        if (this.scaleFactor != 1.0f) {
            matrixStack.scale(this.scaleFactor, this.scaleFactor, this.scaleFactor);
            mouseX = (int)((float)mouseX / this.scaleFactor);
            mouseY = (int)((float)mouseY / this.scaleFactor);
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderAfterScale(guiGraphics, mouseX, mouseY, partialTick);
        matrixStack.popPose();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderAfterScale(guiGraphics, mouseX, mouseY, partialTick);
    }

    private int getMaxAllowedScale() {
        return this.minecraft.getWindow().calculateScale(0, this.minecraft.isEnforceUnicode());
    }

    public void renderAfterScale(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.topStart >= 0) {
            guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)"Warp Nexus"), this.width / 2, this.topStart + 8, new Color(255, 255, 255).getRGB());
        }
    }
}

