/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.areas_common_neoforge.functions;

import com.natamus.collective_common_neoforge.functions.NumberFunctions;
import com.natamus.collective_common_neoforge.functions.SignFunctions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.level.block.entity.SignBlockEntity;

public class ZoneFunctions {
    public static final List<String> zonePrefixes = new ArrayList<String>(Arrays.asList("[na]", "[area]", "[region]", "[zone]"));

    public static boolean hasZonePrefix(String line) {
        for (String prefix : zonePrefixes) {
            if (!line.toLowerCase().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasZonePrefix(SignBlockEntity signentity) {
        int i = -1;
        Iterator iterator = SignFunctions.getSignText((SignBlockEntity)signentity).iterator();
        if (iterator.hasNext()) {
            String line = (String)iterator.next();
            if (++i == 0 && ZoneFunctions.hasZonePrefix(line)) {
                return true;
            }
        }
        return false;
    }

    public static Integer getRadius(String line) {
        for (String prefix : zonePrefixes) {
            if (!line.startsWith(prefix)) continue;
            String[] linespl = line.split("]");
            if (linespl.length < 2) {
                return -1;
            }
            String rest = linespl[1].trim();
            try {
                if (!NumberFunctions.isNumeric((String)rest)) continue;
                return Integer.parseInt(rest);
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        }
        return -1;
    }

    public static String getZoneRGB(String line) {
        String prefix = "[rgb]";
        if (line.startsWith(prefix)) {
            String[] linespl = line.split("]");
            if (linespl.length < 2) {
                return "";
            }
            String rest = linespl[1].replace(" ", "");
            String[] restspl = rest.split(",");
            if (restspl.length != 3) {
                return "";
            }
            for (String value : restspl) {
                if (NumberFunctions.isNumeric((String)value)) continue;
                return "";
            }
            return rest;
        }
        return "";
    }
}

