/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.aprilfools_common_forge.util;

import com.natamus.aprilfools_common_forge.config.ConfigHandler;
import com.natamus.aprilfools_common_forge.data.Variables;
import com.natamus.collective_common_forge.data.GlobalVariables;
import java.time.LocalDate;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.Level;

public class Util {
    public static boolean areAprilFoolsFeaturesEnabled() {
        if (!ConfigHandler.enableOnlyOnApril1st) {
            return true;
        }
        return Variables.itIsAprilFoolsDay;
    }

    public static boolean isAprilFoolsDay() {
        LocalDate today = LocalDate.now();
        return today.getMonthValue() == 4 && today.getDayOfMonth() == 1;
    }

    public static double setExtraAprilFoolsChance(double chance) {
        if (!Variables.itIsAprilFoolsDay) {
            return chance;
        }
        double multiplier = ConfigHandler.april1stChanceMultiplier;
        if (multiplier <= 0.0) {
            return chance;
        }
        return chance * multiplier;
    }

    public static Holder<MobEffect> getRandomMobEffect(Level level) {
        Registry mobEffectRegistry = level.registryAccess().registryOrThrow(Registries.MOB_EFFECT);
        return mobEffectRegistry.wrapAsHolder((Object)((MobEffect)mobEffectRegistry.get((ResourceLocation)Util.getRandomSetElement(mobEffectRegistry.keySet()))));
    }

    static <E> E getRandomSetElement(Set<E> set) {
        return set.stream().skip(GlobalVariables.random.nextInt(set.size())).findFirst().orElse(null);
    }
}

