/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.recipe;

import net.mehvahdjukaar.amendments.common.item.DyeBottleItem;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class DyeBottleRecipe
extends CustomRecipe {
    public DyeBottleRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        Item item;
        boolean hasDyableItem = false;
        ItemStack dyeBottle = ItemStack.EMPTY;
        for (ItemStack itemstack : input.items()) {
            if (itemstack.isEmpty() || (item = itemstack.getItem()) != ModRegistry.DYE_BOTTLE_ITEM.get()) continue;
            if (!dyeBottle.isEmpty()) {
                return false;
            }
            dyeBottle = itemstack;
        }
        if (dyeBottle.isEmpty()) {
            return false;
        }
        for (ItemStack itemstack : input.items()) {
            if (itemstack.isEmpty()) continue;
            item = itemstack.getItem();
            if (!itemstack.is(ItemTags.DYEABLE) && BlocksColorAPI.changeColor((Item)item, (DyeColor)DyeBottleItem.getClosestDye(dyeBottle)) == null) continue;
            if (hasDyableItem) {
                return false;
            }
            hasDyableItem = true;
        }
        return hasDyableItem;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack result;
        ItemStack leather = ItemStack.EMPTY;
        ItemStack dyeBottle = ItemStack.EMPTY;
        for (ItemStack itemstack : input.items()) {
            if (itemstack.isEmpty()) continue;
            Item item = itemstack.getItem();
            if (item == ModRegistry.DYE_BOTTLE_ITEM.get()) {
                dyeBottle = itemstack;
                continue;
            }
            leather = itemstack;
        }
        if (leather.is(ItemTags.DYEABLE)) {
            result = leather.copy();
            DyedItemColor colorComponent = (DyedItemColor)leather.get(DataComponents.DYED_COLOR);
            if (colorComponent != null) {
                int mixedColor = DyeBottleItem.mixColor(((DyedItemColor)dyeBottle.get(DataComponents.DYED_COLOR)).rgb(), colorComponent.rgb(), 1, 1);
                result.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(mixedColor, true));
            } else {
                result.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(((DyedItemColor)dyeBottle.get(DataComponents.DYED_COLOR)).rgb(), true));
            }
        } else {
            result = BlocksColorAPI.changeColor((Item)leather.getItem(), (DyeColor)DyeBottleItem.getClosestDye(dyeBottle)).getDefaultInstance();
            result.applyComponents(leather.getComponents());
        }
        return result;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height > 2;
    }

    public String getGroup() {
        return "dye_bottle";
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRegistry.DYE_BOTTLE_RECIPE.get();
    }
}

