/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.network;

import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.common.block.BoilingWaterCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public record ClientBoundPlaySplashParticlesMessage(Vec3 hitPos, double speed, float width) implements Message
{
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ClientBoundPlaySplashParticlesMessage> TYPE = Message.makeType((ResourceLocation)Amendments.res("client_bound_play_splash_particles"), ClientBoundPlaySplashParticlesMessage::new);

    public ClientBoundPlaySplashParticlesMessage(FriendlyByteBuf buffer) {
        this(buffer.readVec3(), buffer.readDouble(), buffer.readFloat());
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeVec3(this.hitPos);
        buf.writeDouble(this.speed);
        buf.writeFloat(this.width);
    }

    public void handle(Message.Context context) {
        this.doOnClient();
    }

    /*
     * Enabled aggressive block sorting
     */
    @OnlyIn(value=Dist.CLIENT)
    public void doOnClient() {
        ClientLevel level = Minecraft.getInstance().level;
        BlockPos pos = BlockPos.containing((Position)this.hitPos);
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof ModCauldronBlock) {
            ModCauldronBlock mc = (ModCauldronBlock)block;
            block = level.getBlockEntity(pos);
            if (block instanceof LiquidCauldronBlockTile) {
                LiquidCauldronBlockTile tile = (LiquidCauldronBlockTile)block;
                int color = tile.getSoftFluidTank().getCachedParticleColor((BlockAndTintGetter)level, pos);
                int light = tile.getSoftFluidTank().getFluidValue().getEmissivity();
                this.playSplashAnimation((Level)level, pos, color, light);
                return;
            }
        }
        if (!(state.getBlock() instanceof BoilingWaterCauldronBlock)) return;
        int color = BoilingWaterCauldronBlock.getWaterColor(state, (BlockAndTintGetter)level, pos, 1);
        this.playSplashAnimation((Level)level, pos, color, 0);
    }

    public void playSplashAnimation(Level level, BlockPos pos, int color, int light) {
        RandomSource rand = level.random;
        float radius = 1.5f;
        ClientBoundPlaySplashParticlesMessage.spawnSplashParticles(level, this.hitPos, pos, rand, color, light, (ParticleOptions)ModRegistry.BOILING_PARTICLE.get(), radius, this.width);
        ClientBoundPlaySplashParticlesMessage.spawnSplashParticles(level, this.hitPos, pos, rand, color, light, (ParticleOptions)ModRegistry.SPLASH_PARTICLE.get(), radius, this.width);
    }

    public static void spawnSplashParticles(Level level, Vec3 hitPos, BlockPos pos, RandomSource rand, int color, int light, ParticleOptions particleOptions, float radius, float width) {
        float mx = (float)pos.getX() + 0.125f;
        float Mx = (float)(pos.getX() + 1) - 0.125f;
        float mz = (float)pos.getZ() + 0.125f;
        float Mz = (float)(pos.getZ() + 1) - 0.125f;
        double surface = hitPos.y();
        int i = 0;
        while ((float)i < 1.0f + width * 20.0f) {
            double x = hitPos.x() + (rand.nextDouble() - 0.5) * (double)width * (double)radius;
            double z = hitPos.z() + (rand.nextDouble() - 0.5) * (double)width * (double)radius;
            if (x >= (double)mx && x <= (double)Mx && z >= (double)mz && z <= (double)Mz) {
                level.addParticle(particleOptions, x, surface, z, (double)color, surface, (double)light);
            }
            ++i;
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE.type();
    }
}

