/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common;

import java.util.Optional;
import net.mehvahdjukaar.amendments.common.block.DirectionalCakeBlock;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.DummyBlockGetter;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CakeRegistry
extends BlockTypeRegistry<CakeType> {
    public static final CakeRegistry INSTANCE = new CakeRegistry();
    public static final CakeType VANILLA = new CakeType(ResourceLocation.withDefaultNamespace((String)"cake"), Blocks.CAKE);

    private CakeRegistry() {
        super(CakeType.class, "cake");
    }

    public CakeType getDefaultType() {
        return VANILLA;
    }

    public Optional<CakeType> detectTypeFromBlock(Block block, ResourceLocation blockId) {
        String namespace;
        BlockState def;
        if ((block instanceof CakeBlock || blockId.getPath().contains("cake") && block.defaultBlockState().hasProperty((Property)CakeBlock.BITES)) && !(block instanceof DirectionalCakeBlock) && !(block instanceof EntityBlock) && (def = block.defaultBlockState()).getShape(DummyBlockGetter.INSTANCE, BlockPos.ZERO).bounds().equals((Object)Blocks.CAKE.defaultBlockState().getShape(DummyBlockGetter.INSTANCE, BlockPos.ZERO).bounds()) && !(namespace = blockId.getNamespace()).equals("tconstruct") && !namespace.equals("enigmaticlegacy")) {
            return Optional.of(new CakeType(blockId, block));
        }
        return Optional.empty();
    }

    public static class CakeType
    extends BlockType {
        public final Block cake;

        public CakeType(ResourceLocation name, Block cake) {
            super(name);
            this.cake = cake;
        }

        public String getTranslationKey() {
            return "cake";
        }

        public ItemLike mainChild() {
            return this.cake;
        }

        protected void initializeChildrenBlocks() {
            this.addChild("cake", this.cake);
        }

        protected void initializeChildrenItems() {
        }
    }
}

