/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.util.rituals;

import java.util.Objects;
import net.alshanex.alshanex_familiars.util.rituals.ItemMultiSet;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class RitualRecipe {
    private final Item centralItem;
    private final ItemMultiSet inputItems;

    public RitualRecipe(Item centralItem, ItemMultiSet inputItems) {
        this.centralItem = centralItem;
        this.inputItems = inputItems;
    }

    public Item getCentralItem() {
        return this.centralItem;
    }

    public ItemMultiSet getInputItems() {
        return this.inputItems;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.create();
        for (Item item : this.inputItems.getUniqueItems()) {
            if (item == null) continue;
            int count = this.inputItems.getCount(item);
            for (int i = 0; i < count; ++i) {
                Ingredient ingredient = Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)item)});
                ingredients.add((Object)ingredient);
            }
        }
        return ingredients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RitualRecipe that = (RitualRecipe)o;
        if (!Objects.equals(this.centralItem, that.centralItem)) {
            return false;
        }
        return Objects.equals(this.inputItems, that.inputItems);
    }

    public int hashCode() {
        int result = this.centralItem != null ? this.centralItem.hashCode() : 0;
        result = 31 * result + (this.inputItems != null ? this.inputItems.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RitualRecipe{centralItem=" + String.valueOf(this.centralItem) + ", inputItems=" + String.valueOf(this.inputItems) + "}";
    }
}

