/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.util.rituals;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.item.Item;

public class ItemMultiSet {
    private final Map<Item, Integer> itemCounts = new HashMap<Item, Integer>();

    public ItemMultiSet() {
    }

    public ItemMultiSet(Iterable<Item> items) {
        for (Item item : items) {
            this.add(item);
        }
    }

    public void add(Item item) {
        this.itemCounts.put(item, this.itemCounts.getOrDefault(item, 0) + 1);
    }

    public int getCount(Item item) {
        return this.itemCounts.getOrDefault(item, 0);
    }

    public boolean containsAll(ItemMultiSet other) {
        for (Map.Entry<Item, Integer> entry : other.itemCounts.entrySet()) {
            if (this.getCount(entry.getKey()) >= entry.getValue()) continue;
            return false;
        }
        return true;
    }

    public Iterable<Item> getUniqueItems() {
        return this.itemCounts.keySet();
    }

    public int size() {
        return this.itemCounts.values().stream().mapToInt(Integer::intValue).sum();
    }

    public boolean isEmpty() {
        return this.itemCounts.isEmpty();
    }

    public Map<Item, Integer> getItemCounts() {
        return new HashMap<Item, Integer>(this.itemCounts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemMultiSet that = (ItemMultiSet)o;
        if (this.itemCounts.size() != that.itemCounts.size()) {
            return false;
        }
        for (Map.Entry<Item, Integer> entry : this.itemCounts.entrySet()) {
            Item item = entry.getKey();
            Integer count = entry.getValue();
            if (count.equals(that.itemCounts.getOrDefault(item, 0))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (Map.Entry<Item, Integer> entry : this.itemCounts.entrySet()) {
            result = 31 * result + Objects.hashCode(entry.getKey()) * entry.getValue();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ItemMultiSet{");
        for (Map.Entry<Item, Integer> entry : this.itemCounts.entrySet()) {
            sb.append(entry.getKey()).append("\u00d7").append(entry.getValue()).append(", ");
        }
        if (!this.itemCounts.isEmpty()) {
            sb.setLength(sb.length() - 2);
        }
        sb.append("}");
        return sb.toString();
    }
}

