/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.item;

import java.util.List;
import javax.annotation.Nullable;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.registry.DataComponentRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FamiliarTomeItem
extends Item {
    public FamiliarTomeItem(Item.Properties properties) {
        super(properties.stacksTo(1).rarity(Rarity.UNCOMMON));
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack;
        Level worldIn;
        Direction facing;
        BlockPos pos;
        Player player = context.getPlayer();
        if (!this.release(player, pos = context.getClickedPos(), facing = context.getClickedFace(), worldIn = context.getLevel(), stack = context.getItemInHand())) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        if (!this.capture(stack, target, playerIn)) {
            return InteractionResult.FAIL;
        }
        playerIn.swing(hand);
        playerIn.setItemInHand(hand, stack);
        return InteractionResult.SUCCESS;
    }

    public boolean capture(ItemStack stack, LivingEntity target, Player player) {
        AbstractSpellCastingPet pet;
        if (target.getCommandSenderWorld().isClientSide) {
            return false;
        }
        if (!(target instanceof AbstractSpellCastingPet) || (pet = (AbstractSpellCastingPet)target).getSummoner() == null || !pet.getSummoner().is((Entity)player)) {
            return false;
        }
        if (this.containsEntity(stack)) {
            return false;
        }
        CompoundTag nbt = new CompoundTag();
        if (target.hasCustomName()) {
            nbt.putString("name", target.getCustomName().getString());
        }
        nbt.putFloat("currentHealth", target.getHealth());
        nbt.putString("entity", EntityType.getKey((EntityType)target.getType()).toString());
        ((AbstractSpellCastingPet)target).setTarget(null);
        ((AbstractSpellCastingPet)target).cancelCast();
        target.saveWithoutId(nbt);
        stack.set(DataComponentRegistry.FAMILIAR_TOME, (Object)nbt);
        target.remove(Entity.RemovalReason.DISCARDED);
        return true;
    }

    public boolean release(Player player, BlockPos pos, Direction facing, Level worldIn, ItemStack stack) {
        AbstractSpellCastingPet pet;
        if (player.getCommandSenderWorld().isClientSide) {
            return false;
        }
        if (!this.containsEntity(stack)) {
            return false;
        }
        Entity entity = this.getEntityFromStack(stack, worldIn, true);
        if (entity instanceof AbstractSpellCastingPet && (pet = (AbstractSpellCastingPet)entity).getSummoner() != null && !pet.getSummoner().is((Entity)player)) {
            return false;
        }
        if (stack.has(DataComponentRegistry.FAMILIAR_TOME)) {
            CompoundTag nbt = (CompoundTag)stack.get(DataComponentRegistry.FAMILIAR_TOME);
            float currentHealth = nbt.getFloat("currentHealth");
            if (entity instanceof AbstractSpellCastingPet) {
                AbstractSpellCastingPet pet2 = (AbstractSpellCastingPet)entity;
                pet2.setHealth(currentHealth);
            }
        }
        BlockPos blockPos = pos.relative(facing);
        entity.absMoveTo((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5, 0.0f, 0.0f);
        stack.remove(DataComponentRegistry.FAMILIAR_TOME);
        worldIn.addFreshEntity(entity);
        return true;
    }

    public boolean containsEntity(ItemStack stack) {
        return !stack.isEmpty() && stack.has(DataComponentRegistry.FAMILIAR_TOME);
    }

    @Nullable
    public Entity getEntityFromStack(ItemStack stack, Level world, boolean withInfo) {
        CompoundTag nbt;
        EntityType type;
        if (stack.has(DataComponentRegistry.FAMILIAR_TOME) && (type = (EntityType)EntityType.byString((String)(nbt = (CompoundTag)stack.get(DataComponentRegistry.FAMILIAR_TOME)).getString("entity")).orElse(null)) != null) {
            Entity entity = type.create(world);
            if (withInfo) {
                entity.load(nbt);
            } else if (!type.canSummon()) {
                return null;
            }
            return entity;
        }
        return null;
    }

    public String getID(ItemStack stack) {
        CompoundTag nbt = (CompoundTag)stack.get(DataComponentRegistry.FAMILIAR_TOME);
        if (nbt.contains("name")) {
            return nbt.getString("name");
        }
        return nbt.getString("entity");
    }

    public Component getName(ItemStack stack) {
        if (!this.containsEntity(stack)) {
            return Component.translatable((String)super.getDescriptionId(stack));
        }
        return Component.translatable((String)super.getDescriptionId(stack)).append(" (" + this.getID(stack) + ")");
    }

    public void appendHoverText(@NotNull ItemStack itemStack, Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag flag) {
        super.appendHoverText(itemStack, context, lines, flag);
        if (itemStack.has(DataComponentRegistry.FAMILIAR_TOME)) {
            CompoundTag nbt = (CompoundTag)itemStack.get(DataComponentRegistry.FAMILIAR_TOME);
            float currentHealth = nbt.getFloat("currentHealth");
            int enragedStacks = nbt.getInt("enragedStacks");
            boolean canBlock = nbt.getBoolean("isBlocking");
            String chanceToBlock = canBlock ? "10% chance to block an incoming attack" : "0% chance to block an incoming attack";
            int armorStacks = nbt.getInt("armorStacks");
            lines.add((Component)Component.literal((String)("Current health: " + currentHealth)).withStyle(ChatFormatting.GREEN));
            lines.add((Component)Component.literal((String)("Additional armor points: " + armorStacks)).withStyle(ChatFormatting.AQUA));
            lines.add((Component)Component.literal((String)("Enraged stacks: " + enragedStacks)).withStyle(ChatFormatting.LIGHT_PURPLE));
            lines.add((Component)Component.literal((String)chanceToBlock).withStyle(ChatFormatting.GOLD));
        }
    }
}

