/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.event;

import io.redspace.ironsspellbooks.api.events.SpellOnCastEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.network.SyncManaPacket;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.Random;
import net.alshanex.alshanex_familiars.entity.BardPetEntity;
import net.alshanex.alshanex_familiars.entity.PlaguePetEntity;
import net.alshanex.alshanex_familiars.entity.ScorcherPetEntity;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.entity.generic.AbstractTerrestrianSpellCastingPet;
import net.alshanex.alshanex_familiars.registry.AFSchoolRegistry;
import net.alshanex.alshanex_familiars.registry.EntityRegistry;
import net.alshanex.alshanex_familiars.registry.ItemRegistry;
import net.alshanex.alshanex_familiars.util.CurioUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="alshanex_familiars")
public class ServerEvents {
    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        AbstractSpellCastingPet pet;
        LivingEntity entity = event.getEntity();
        if (!entity.level.isClientSide && entity instanceof AbstractSpellCastingPet && (pet = (AbstractSpellCastingPet)entity).getSummoner() != null && (livingEntity = pet.getSummoner()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
            if (CurioUtils.isWearingCurio(pet.getSummoner(), (Item)ItemRegistry.COMPLETE_SOUL_CURIO.get()) && magicData.getMana() >= 80.0f) {
                pet.setHealth(pet.getMaxHealth() / 2.0f);
                float newMana = Math.max(magicData.getMana() - 80.0f, 0.0f);
                magicData.setMana(newMana);
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncManaPacket(magicData), (CustomPacketPayload[])new CustomPacketPayload[0]);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onSpellCasted(SpellOnCastEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!player2.level.isClientSide && player2.getMainHandItem().is((Item)ItemRegistry.BARD_HARP.get()) && event.getSchoolType() == AFSchoolRegistry.SOUND.get()) {
                int radiusSqr = 16;
                player2.level.getEntitiesOfClass(LivingEntity.class, new AABB(player2.position().subtract(4.0, 4.0, 4.0), player2.position().add(4.0, 4.0, 4.0)), livingEntity -> {
                    AbstractSpellCastingPet pet;
                    return livingEntity instanceof AbstractSpellCastingPet && (pet = (AbstractSpellCastingPet)((Object)livingEntity)).getSummoner() == null && ServerEvents.horizontalDistanceSqr(livingEntity, player2.position()) < (float)radiusSqr;
                }).forEach(livingEntity -> {
                    BardPetEntity bard = new BardPetEntity((EntityType<? extends AbstractTerrestrianSpellCastingPet>)((EntityType)EntityRegistry.BARD_PET.get()), player.level);
                    bard.setPos(livingEntity.getX(), livingEntity.getY(), livingEntity.getZ());
                    bard.setYRot(livingEntity.getYRot());
                    player.level.addFreshEntity((Entity)bard);
                    MagicManager.spawnParticles((Level)player.level, (ParticleOptions)new BlastwaveParticleOptions(AFSchoolRegistry.SOUND.get().getTargetingColor(), 2.0f), (double)livingEntity.getX(), (double)(livingEntity.getY() + (double)0.165f), (double)livingEntity.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
                    livingEntity.remove(Entity.RemovalReason.DISCARDED);
                });
            }
        }
    }

    private static float horizontalDistanceSqr(LivingEntity livingEntity, Vec3 vec3) {
        double dx = livingEntity.getX() - vec3.x;
        double dz = livingEntity.getZ() - vec3.z;
        return (float)(dx * dx + dz * dz);
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingDamageEvent.Pre event) {
        LivingEntity entity;
        AbstractSpellCastingPet pet;
        LivingEntity livingEntity;
        if (event.getEntity() instanceof ScorcherPetEntity && event.getSource().getEntity() != null && (livingEntity = event.getSource().getEntity()) instanceof LivingEntity) {
            LivingEntity entity2 = livingEntity;
            entity2.setRemainingFireTicks(100);
        }
        if ((livingEntity = event.getEntity()) instanceof PlaguePetEntity) {
            Entity entity3;
            pet = (PlaguePetEntity)livingEntity;
            if (event.getSource().getEntity() != null && (entity3 = event.getSource().getEntity()) instanceof LivingEntity) {
                entity = (LivingEntity)entity3;
                Vec3 vec3 = entity.getDeltaMovement();
                double d0 = entity.getX() + vec3.x - pet.getX();
                double d1 = entity.getEyeY() - (double)1.1f - pet.getY();
                double d2 = entity.getZ() + vec3.z - pet.getZ();
                double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                Holder holder = Potions.STRONG_POISON;
                ThrownPotion thrownpotion = new ThrownPotion(pet.level(), (LivingEntity)pet);
                thrownpotion.setItem(PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)holder));
                thrownpotion.setXRot(thrownpotion.getXRot() - -20.0f);
                thrownpotion.shoot(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
                pet.triggerAnim("block_controller", "block");
                pet.level().addFreshEntity((Entity)thrownpotion);
            }
        }
        if ((entity = event.getEntity()) instanceof AbstractSpellCastingPet) {
            Random random;
            pet = (AbstractSpellCastingPet)entity;
            if (pet.getEnragedStacks() > 0 && (random = new Random()).nextInt(100) < 10) {
                pet.setEnragedStacks(pet.getEnragedStacks() - 1);
                pet.addEffect(new MobEffectInstance((Holder)MobEffectRegistry.HEARTSTOP, 100, 0, false, false, true));
                pet.triggerAnim("interact_controller", "interact");
                MagicManager.spawnParticles((Level)pet.level(), (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.BLOOD.get()).getTargetingColor(), 2.0f), (double)pet.getX(), (double)(pet.getY() + (double)0.165f), (double)pet.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
            }
            if (pet.getIsBlocking().booleanValue() && (random = new Random()).nextInt(100) <= 10) {
                event.setNewDamage(0.0f);
                pet.triggerAnim("block_controller", "block");
                MagicManager.spawnParticles((Level)pet.level(), (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.EVOCATION.get()).getTargetingColor(), 2.0f), (double)pet.getX(), (double)(pet.getY() + (double)0.165f), (double)pet.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
                pet.level().playSound(null, pet.getX(), pet.getY(), pet.getZ(), SoundEvents.SHIELD_BLOCK, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }
}

