/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.event;

import io.redspace.ironsspellbooks.player.KeyState;
import java.util.ArrayList;
import net.alshanex.alshanex_familiars.event.KeyMappings;
import net.alshanex.alshanex_familiars.network.SummonPetPackage;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="alshanex_familiars", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ClientEvents {
    private static final ArrayList<KeyState> KEY_STATES = new ArrayList();
    private static final KeyState TRINKET_SUMMON_STATE = ClientEvents.register(KeyMappings.FAMILIAR_TRINKET_KEYMAP);

    private static KeyState register(KeyMapping key) {
        KeyState k = new KeyState(key);
        KEY_STATES.add(k);
        return k;
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        ClientEvents.handleInputEvent(event.getKey(), event.getAction());
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton.Pre event) {
        ClientEvents.handleInputEvent(event.getButton(), event.getAction());
    }

    private static void handleInputEvent(int button, int action) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        if (TRINKET_SUMMON_STATE.wasPressed() && minecraft.screen == null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SummonPetPackage(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        ClientEvents.update();
    }

    private static void update() {
        for (KeyState k : KEY_STATES) {
            k.update();
        }
    }
}

