/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity.generic;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericCopyOwnerTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericFollowOwnerGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtTargetGoal;
import io.redspace.ironsspellbooks.spells.ender.TeleportSpell;
import io.redspace.ironsspellbooks.spells.fire.BurningDashSpell;
import io.redspace.ironsspellbooks.util.OwnerHelper;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.alshanex.alshanex_familiars.registry.ItemRegistry;
import net.alshanex.alshanex_familiars.util.CurioUtils;
import net.alshanex.alshanex_familiars.util.ModTags;
import net.alshanex.alshanex_familiars.util.PetAnimationUtils;
import net.alshanex.alshanex_familiars.util.PetAttributesHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AbstractSpellCastingPet
extends PathfinderMob
implements GeoEntity,
IMagicEntity,
IMagicSummon {
    private static final EntityDataAccessor<Boolean> DATA_CANCEL_CAST = SynchedEntityData.defineId(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> DATA_IS_SITTING;
    protected final MagicData playerMagicData = new MagicData(true);
    private static final EntityDataAccessor<Optional<UUID>> DATA_ID_OWNER_UUID;
    private static final EntityDataAccessor<Boolean> DATA_BLOCKING;
    private static final EntityDataAccessor<Integer> DATA_ENRAGED;
    private static final EntityDataAccessor<Integer> DATA_ARMOR;
    private static final EntityDataAccessor<Integer> DATA_HEALTH;
    private static final EntityDataAccessor<Boolean> DATA_IMPOSTOR;
    protected LivingEntity cachedSummoner;
    @org.jetbrains.annotations.Nullable
    protected SpellData castingSpell;
    public boolean hasUsedSingleAttack;
    protected boolean recreateSpell;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected AbstractSpell lastCastSpellType = SpellRegistry.none();
    protected AbstractSpell instantCastSpellType = SpellRegistry.none();
    protected boolean cancelCastAnimation = false;
    protected boolean animatingLegs = false;
    protected final RawAnimation idle = RawAnimation.begin().thenLoop("idle");
    protected final RawAnimation walk = RawAnimation.begin().thenLoop("walk");
    protected final RawAnimation attack = RawAnimation.begin().thenPlay("skill");
    protected final RawAnimation longCast = RawAnimation.begin().thenPlay("long_cast");
    protected final RawAnimation interact = RawAnimation.begin().thenPlay("interact");
    protected final RawAnimation stomp = RawAnimation.begin().thenPlay("stomp");
    protected final RawAnimation spawn = RawAnimation.begin().thenPlay("spawn");
    protected final AnimationController animationControllerInstantCast = new AnimationController((GeoAnimatable)this, "instant_casting", 0, this::instantCastingPredicate);
    protected final AnimationController animationControllerLongCast = new AnimationController((GeoAnimatable)this, "long_casting", 0, this::longCastingPredicate);

    protected AbstractSpellCastingPet(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.playerMagicData.setSyncedData(new SyncedSpellData((LivingEntity)this));
        this.lookControl = this.createLookControl();
    }

    protected void setRandomImpostor() {
        Random rand = new Random();
        if ((double)rand.nextFloat() <= 0.1) {
            this.setIsImpostor(true);
            if (this.getIsImpostor().booleanValue()) {
                this.goalSelector.addGoal(3, (Goal)new StealItemsWhenNotWatchedGoal(this, this, 3.0));
            }
        }
    }

    public boolean getHasUsedSingleAttack() {
        return this.hasUsedSingleAttack;
    }

    public void setHasUsedSingleAttack(boolean hasUsedSingleAttack) {
        this.hasUsedSingleAttack = hasUsedSingleAttack;
    }

    public Vec3 getPassengerRidingPosition(Entity pEntity) {
        return super.getPassengerRidingPosition(pEntity);
    }

    public void rideTick() {
        super.rideTick();
        Entity entity = this.getVehicle();
        if (entity instanceof PathfinderMob) {
            PathfinderMob pathfindermob = (PathfinderMob)entity;
            pathfindermob.yBodyRot = this.yBodyRot;
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new TeleportToOwnerGoal(this, this, this::getSummoner, 20.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new GenericFollowOwnerGoal((PathfinderMob)this, this::getSummoner, (double)1.2f, 10.0f, 3.0f, false, Float.MAX_VALUE));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new GenericOwnerHurtByTargetGoal((Mob)this, this::getSummoner));
        this.targetSelector.addGoal(2, (Goal)new GenericOwnerHurtTargetGoal((Mob)this, this::getSummoner));
        this.targetSelector.addGoal(3, (Goal)new GenericCopyOwnerTargetGoal((PathfinderMob)this, this::getSummoner));
        this.targetSelector.addGoal(4, (Goal)new GenericHurtByTargetGoal((PathfinderMob)this, entity -> entity == this.getSummoner()).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public boolean isAlliedTo(Entity pEntity) {
        return super.isAlliedTo(pEntity) || this.isAlliedHelper(pEntity);
    }

    public void setOwnerUUID(@org.jetbrains.annotations.Nullable UUID uuid) {
        this.entityData.set(DATA_ID_OWNER_UUID, Optional.ofNullable(uuid));
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(DATA_ID_OWNER_UUID)).orElseGet(() -> ((Optional)this.entityData.get(DATA_ID_OWNER_UUID)).orElse(null));
    }

    public void setEnragedStacks(Integer level) {
        this.entityData.set(DATA_ENRAGED, (Object)level);
    }

    public Integer getEnragedStacks() {
        return (Integer)this.entityData.get(DATA_ENRAGED);
    }

    public void setArmorStacks(Integer level) {
        this.entityData.set(DATA_ARMOR, (Object)level);
    }

    public Integer getArmorStacks() {
        return (Integer)this.entityData.get(DATA_ARMOR);
    }

    public void setHealthStacks(Integer level) {
        this.entityData.set(DATA_HEALTH, (Object)level);
    }

    public Integer getHealthStacks() {
        return (Integer)this.entityData.get(DATA_HEALTH);
    }

    public void setIsBlocking(Boolean level) {
        this.entityData.set(DATA_BLOCKING, (Object)level);
    }

    public Boolean getIsBlocking() {
        return (Boolean)this.entityData.get(DATA_BLOCKING);
    }

    public void setIsImpostor(Boolean level) {
        this.entityData.set(DATA_IMPOSTOR, (Object)level);
    }

    public Boolean getIsImpostor() {
        return (Boolean)this.entityData.get(DATA_IMPOSTOR);
    }

    public void setSitting(Boolean level) {
        if (level.booleanValue()) {
            this.clearMovementGoals();
            this.navigation.stop();
            this.setTarget(null);
        } else {
            this.restoreMovementGoals();
            this.navigation.recomputePath();
        }
        this.entityData.set(DATA_IS_SITTING, (Object)level);
    }

    public Boolean getIsSitting() {
        return (Boolean)this.entityData.get(DATA_IS_SITTING);
    }

    protected void clearMovementGoals() {
        this.goalSelector.removeAllGoals(goal -> goal instanceof GenericFollowOwnerGoal);
    }

    protected void restoreMovementGoals() {
        this.goalSelector.addGoal(7, (Goal)new GenericFollowOwnerGoal((PathfinderMob)this, this::getSummoner, (double)1.2f, 10.0f, 3.0f, false, Float.MAX_VALUE));
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.isInvulnerableTo(pSource)) {
            return false;
        }
        if (!this.level().isClientSide) {
            this.setSitting(false);
        }
        return super.hurt(pSource, pAmount);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        AbstractSpellCastingPet pet;
        Entity entity;
        if (source.getEntity() != null && source.getEntity().is((Entity)this.getSummoner())) {
            return true;
        }
        if (source.getEntity() != null && (entity = source.getEntity()) instanceof AbstractSpellCastingPet && (pet = (AbstractSpellCastingPet)entity).getSummoner() != null && pet.getSummoner().is((Entity)this.getSummoner())) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_ID_OWNER_UUID, Optional.empty());
        pBuilder.define(DATA_BLOCKING, (Object)false);
        pBuilder.define(DATA_ENRAGED, (Object)0);
        pBuilder.define(DATA_ARMOR, (Object)0);
        pBuilder.define(DATA_HEALTH, (Object)0);
        pBuilder.define(DATA_CANCEL_CAST, (Object)false);
        pBuilder.define(DATA_IS_SITTING, (Object)false);
        pBuilder.define(DATA_IMPOSTOR, (Object)false);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        super.onSyncedDataUpdated(pKey);
        if (!this.level().isClientSide) {
            return;
        }
        if (pKey.id() == DATA_CANCEL_CAST.id()) {
            this.cancelCast();
        }
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        this.playerMagicData.getSyncedData().saveNBTData(pCompound, (HolderLookup.Provider)this.level().registryAccess());
        pCompound.putBoolean("usedSpecial", this.hasUsedSingleAttack);
        if (this.getOwnerUUID() != null) {
            pCompound.putUUID("ownerUUID", this.getOwnerUUID());
        } else {
            pCompound.putString("ownerUUID", "null");
        }
        pCompound.putInt("enragedStacks", this.getEnragedStacks().intValue());
        pCompound.putBoolean("isBlocking", this.getIsBlocking().booleanValue());
        pCompound.putInt("armorStacks", this.getArmorStacks().intValue());
        pCompound.putInt("healthStacks", this.getHealthStacks().intValue());
        pCompound.putBoolean("Sitting", this.getIsSitting().booleanValue());
        pCompound.putBoolean("isImpostor", this.getIsImpostor().booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        SyncedSpellData syncedSpellData = new SyncedSpellData((LivingEntity)this);
        syncedSpellData.loadNBTData(pCompound, (HolderLookup.Provider)this.level().registryAccess());
        if (syncedSpellData.isCasting()) {
            this.recreateSpell = true;
        }
        this.playerMagicData.setSyncedData(syncedSpellData);
        this.hasUsedSingleAttack = pCompound.getBoolean("usedSpecial");
        if (pCompound.contains("ownerUUID")) {
            String ownerUUIDString = pCompound.getString("ownerUUID");
            if (!"null".equals(ownerUUIDString)) {
                this.setOwnerUUID(pCompound.getUUID("ownerUUID"));
            } else {
                this.setOwnerUUID(null);
            }
        }
        if (pCompound.contains("enragedStacks")) {
            this.setEnragedStacks(pCompound.getInt("enragedStacks"));
        }
        if (pCompound.contains("isBlocking")) {
            this.setIsBlocking(pCompound.getBoolean("isBlocking"));
        }
        if (pCompound.contains("armorStacks")) {
            this.setArmorStacks(pCompound.getInt("armorStacks"));
        }
        if (pCompound.contains("healthStacks")) {
            this.setHealthStacks(pCompound.getInt("healthStacks"));
        }
        if (pCompound.contains("Sitting")) {
            this.setSitting(pCompound.getBoolean("Sitting"));
        }
        if (pCompound.contains("isImpostor")) {
            this.setIsImpostor(pCompound.getBoolean("isImpostor"));
        }
    }

    public LivingEntity getSummoner() {
        return OwnerHelper.getAndCacheOwner((Level)this.level(), (LivingEntity)this.cachedSummoner, (UUID)this.getOwnerUUID());
    }

    public void die(DamageSource pDamageSource) {
        if (this.getSummoner() != null) {
            this.onDeathHelper();
        }
        super.die(pDamageSource);
    }

    public void onUnSummon() {
    }

    protected LookControl createLookControl() {
        return new LookControl((Mob)this){

            protected boolean resetXRotOnTick() {
                return AbstractSpellCastingPet.this.getTarget() == null;
            }
        };
    }

    protected MoveControl createMoveControl() {
        return new MoveControl(this, (Mob)this){

            protected float rotlerp(float pSourceAngle, float pTargetAngle, float pMaximumChange) {
                double d1;
                double d0 = this.wantedX - this.mob.getX();
                if (d0 * d0 + (d1 = this.wantedZ - this.mob.getZ()) * d1 < 0.5) {
                    return pSourceAngle;
                }
                return super.rotlerp(pSourceAngle, pTargetAngle, pMaximumChange * 0.25f);
            }
        };
    }

    public MagicData getMagicData() {
        return this.playerMagicData;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.noCulling = this.isAnimating();
        }
        if (this.getSummoner() != null && this.tickCount % 10 == 0) {
            if (CurioUtils.isWearingCurio(this.getSummoner(), (Item)ItemRegistry.FAMILIAR_SPELLBOOK.get())) {
                PetAttributesHelper.applyAttributes(this);
            } else {
                PetAttributesHelper.removeAttributes(this);
            }
        }
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.MAX_HEALTH, 50.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public boolean canBeLeashed() {
        return false;
    }

    public void checkDespawn() {
        if (this.getSummoner() == null) {
            super.checkDespawn();
        }
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.getSummoner() != null && this.getSummoner().is((Entity)player) && itemstack.is(Items.STICK)) {
            this.setSitting(this.getIsSitting() == false);
            return InteractionResult.SUCCESS;
        }
        if (!this.level().isClientSide) {
            if (this.getOwnerUUID() != null) {
                if (this.getOwnerUUID().equals(player.getUUID())) {
                    this.triggerAnim("interact_controller", "interact");
                    if (itemstack.is((Item)ItemRegistry.BLUEBERRY.get())) {
                        itemstack.shrink(1);
                        ItemStack stack = new ItemStack((ItemLike)ItemRegistry.MEMORY_FRAGMENT.get());
                        this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack));
                        if (this.getHealth() < this.getMaxHealth()) {
                            this.heal(4.0f);
                            this.gameEvent((Holder)GameEvent.EAT);
                        }
                        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                    }
                    if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                        this.heal(4.0f);
                        itemstack.consume(1, (LivingEntity)player);
                        this.spawnEatingParticles();
                        this.gameEvent((Holder)GameEvent.EAT);
                        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                    }
                }
            } else if (itemstack.is(ModTags.FAMILIAR_TAMING)) {
                itemstack.consume(1, (LivingEntity)player);
                this.tryToTame(player);
                return InteractionResult.SUCCESS;
            }
        }
        return super.mobInteract(player, hand);
    }

    protected boolean isFood(ItemStack item) {
        return item.is(Items.APPLE);
    }

    protected void tryToTame(Player player) {
        if (this.random.nextInt(10) == 0) {
            this.spawnTamingParticles(true);
            this.navigation.stop();
            this.setTarget(null);
            this.setOwnerUUID(player.getUUID());
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.triggerAdvancement(serverPlayer);
            }
        } else {
            this.spawnTamingParticles(false);
        }
    }

    protected void triggerAdvancement(ServerPlayer player) {
    }

    protected void spawnTamingParticles(boolean tamed) {
        SimpleParticleType particleoptions = ParticleTypes.HEART;
        if (!tamed) {
            particleoptions = ParticleTypes.SMOKE;
        }
        int count = 16;
        float radius = 1.25f;
        for (int i = 0; i < count; ++i) {
            double theta = Math.toRadians(360 / count) * (double)i;
            double x = Math.cos(theta) * (double)radius;
            double z = Math.sin(theta) * (double)radius;
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)particleoptions, (double)(this.position().x + x), (double)this.position().y, (double)(this.position().z + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (boolean)false);
        }
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        this.triggerAnim("spawn_controller", "spawn");
    }

    protected void spawnEatingParticles() {
        SimpleParticleType particleoptions = ParticleTypes.HEART;
        int count = 3;
        float radius = 0.5f;
        for (int i = 0; i < count; ++i) {
            double theta = Math.toRadians(360 / count) * (double)i;
            double x = Math.cos(theta) * (double)radius;
            double z = Math.sin(theta) * (double)radius;
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)particleoptions, (double)(this.position().x + x), (double)this.position().y, (double)(this.position().z + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (boolean)false);
        }
    }

    public void cancelCast() {
        if (this.isCasting()) {
            if (this.level().isClientSide) {
                this.cancelCastAnimation = true;
            } else {
                this.entityData.set(DATA_CANCEL_CAST, (Object)((Boolean)this.entityData.get(DATA_CANCEL_CAST) == false ? 1 : 0));
            }
            this.castComplete();
        }
    }

    public void castComplete() {
        if (!this.level().isClientSide) {
            if (this.castingSpell != null) {
                this.castingSpell.getSpell().onServerCastComplete(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData, false);
            }
        } else {
            this.playerMagicData.resetCastingState();
        }
        this.castingSpell = null;
    }

    public void setSyncedSpellData(SyncedSpellData syncedSpellData) {
        if (!this.level().isClientSide) {
            return;
        }
        boolean isCasting = this.playerMagicData.isCasting();
        this.playerMagicData.setSyncedData(syncedSpellData);
        this.castingSpell = this.playerMagicData.getCastingSpell();
        if (this.castingSpell == null) {
            return;
        }
        if (!this.playerMagicData.isCasting() && isCasting) {
            this.castComplete();
        } else if (this.playerMagicData.isCasting() && !isCasting) {
            AbstractSpell spell = this.playerMagicData.getCastingSpell().getSpell();
            this.initiateCastSpell(spell, this.playerMagicData.getCastingSpellLevel());
            if (this.castingSpell.getSpell().getCastType() == CastType.INSTANT) {
                this.instantCastSpellType = this.castingSpell.getSpell();
                this.castingSpell.getSpell().onClientPreCast(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, InteractionHand.MAIN_HAND, this.playerMagicData);
                this.castComplete();
            }
        }
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.recreateSpell) {
            this.recreateSpell = false;
            SyncedSpellData syncedSpellData = this.playerMagicData.getSyncedData();
            this.setSyncedSpellData(syncedSpellData);
        }
        if (this.castingSpell == null) {
            return;
        }
        this.playerMagicData.handleCastDuration();
        if (this.playerMagicData.isCasting()) {
            this.castingSpell.getSpell().onServerCastTick(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData);
        }
        this.forceLookAtTarget(this.getTarget());
        if (this.playerMagicData.getCastDurationRemaining() <= 0) {
            if (this.castingSpell.getSpell().getCastType() == CastType.LONG || this.castingSpell.getSpell().getCastType() == CastType.INSTANT) {
                this.castingSpell.getSpell().onCast(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, CastSource.MOB, this.playerMagicData);
            }
            this.castComplete();
        } else if (this.castingSpell.getSpell().getCastType() == CastType.CONTINUOUS && (this.playerMagicData.getCastDurationRemaining() + 1) % 10 == 0) {
            this.castingSpell.getSpell().onCast(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, CastSource.MOB, this.playerMagicData);
        }
    }

    public void initiateCastSpell(AbstractSpell spell, int spellLevel) {
        if (spell == SpellRegistry.none()) {
            this.castingSpell = null;
            return;
        }
        if (this.level().isClientSide) {
            this.cancelCastAnimation = false;
        }
        this.castingSpell = new SpellData(spell, spellLevel);
        if (this.getTarget() != null) {
            this.forceLookAtTarget(this.getTarget());
        }
        if (!this.level().isClientSide && !this.castingSpell.getSpell().checkPreCastConditions(this.level(), spellLevel, (LivingEntity)this, this.playerMagicData)) {
            this.castingSpell = null;
            return;
        }
        if (spell == SpellRegistry.TELEPORT_SPELL.get() || spell == SpellRegistry.FROST_STEP_SPELL.get()) {
            this.setTeleportLocationBehindTarget(10);
        } else if (spell == SpellRegistry.BLOOD_STEP_SPELL.get()) {
            this.setTeleportLocationBehindTarget(3);
        } else if (spell == SpellRegistry.BURNING_DASH_SPELL.get()) {
            this.setBurningDashDirectionData();
        }
        this.playerMagicData.initiateCast(this.castingSpell.getSpell(), this.castingSpell.getLevel(), this.castingSpell.getSpell().getEffectiveCastTime(this.castingSpell.getLevel(), (LivingEntity)this), CastSource.MOB, SpellSelectionManager.MAINHAND);
        if (!this.level().isClientSide) {
            this.castingSpell.getSpell().onServerPreCast(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData);
        }
    }

    public void notifyDangerousProjectile(Projectile projectile) {
    }

    public boolean isCasting() {
        return this.playerMagicData.isCasting();
    }

    public boolean setTeleportLocationBehindTarget(int distance) {
        LivingEntity target = this.getTarget();
        boolean valid = false;
        if (target != null) {
            Vec3 rotation = target.getLookAngle().normalize().scale((double)(-distance));
            Vec3 pos = target.position();
            Vec3 teleportPos = rotation.add(pos);
            for (int i = 0; i < 24; ++i) {
                Vec3 randomness = Utils.getRandomVec3((double)(0.15f * (float)i)).multiply(1.0, 0.0, 1.0);
                teleportPos = Utils.moveToRelativeGroundLevel((Level)this.level(), (Vec3)target.position().subtract(new Vec3(0.0, 0.0, (double)((float)distance / (float)(i / 7 + 1))).yRot(-(target.getYRot() + (float)(i * 45)) * ((float)Math.PI / 180))).add(randomness), (int)5);
                teleportPos = new Vec3(teleportPos.x, teleportPos.y + (double)0.1f, teleportPos.z);
                AABB reposBB = this.getBoundingBox().move(teleportPos.subtract(this.position()));
                if (this.level().collidesWithSuffocatingBlock((Entity)this, reposBB.inflate((double)-0.05f))) continue;
                valid = true;
                break;
            }
            if (valid) {
                this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(teleportPos));
            } else {
                this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(this.position()));
            }
        } else {
            this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(this.position()));
        }
        return valid;
    }

    public void setBurningDashDirectionData() {
        this.playerMagicData.setAdditionalCastData((ICastData)new BurningDashSpell.BurningDashDirectionOverrideCastData());
    }

    protected void forceLookAtTarget(LivingEntity target) {
        if (target != null) {
            double d0 = target.getX() - this.getX();
            double d2 = target.getZ() - this.getZ();
            double d1 = target.getEyeY() - this.getEyeY();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
            float f1 = (float)(-(Mth.atan2((double)d1, (double)d3) * 57.2957763671875));
            this.setXRot(f1 % 360.0f);
            this.setYRot(f % 360.0f);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(this.animationControllerInstantCast);
        controllerRegistrar.add(this.animationControllerLongCast);
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "idle", 0, this::idlePredicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "interact_controller", state -> PlayState.STOP).triggerableAnim("interact", this.interact));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "spawn_controller", state -> PlayState.STOP).triggerableAnim("spawn", this.spawn));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "block_controller", state -> PlayState.STOP).triggerableAnim("block", this.attack));
    }

    protected PlayState idlePredicate(AnimationState event) {
        if (this.isAnimating()) {
            return PlayState.STOP;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(this.walk);
            return PlayState.CONTINUE;
        }
        if (!event.isMoving()) {
            event.getController().setAnimation(this.idle);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    protected PlayState instantCastingPredicate(AnimationState event) {
        if (this.cancelCastAnimation) {
            return PlayState.STOP;
        }
        AnimationController controller = event.getController();
        if (this.instantCastSpellType != SpellRegistry.none() && controller.getAnimationState() == AnimationController.State.STOPPED) {
            this.setStartAnimationFromSpell(controller, this.instantCastSpellType);
            this.instantCastSpellType = SpellRegistry.none();
        }
        return PlayState.CONTINUE;
    }

    protected PlayState longCastingPredicate(AnimationState event) {
        AnimationController controller = event.getController();
        if (this.cancelCastAnimation || controller.getAnimationState() == AnimationController.State.STOPPED && (!this.isCasting() || this.castingSpell == null || this.castingSpell.getSpell().getCastType() != CastType.LONG)) {
            return PlayState.STOP;
        }
        if (this.isCasting() && controller.getAnimationState() == AnimationController.State.STOPPED) {
            this.setStartAnimationFromSpell(controller, this.castingSpell.getSpell());
        }
        return PlayState.CONTINUE;
    }

    protected void setStartAnimationFromSpell(AnimationController controller, AbstractSpell spell) {
        spell.getCastStartAnimation().getForMob().ifPresentOrElse(animationBuilder -> {
            controller.forceAnimationReset();
            if (PetAnimationUtils.isLongAnimCast(spell)) {
                controller.setAnimation(this.longCast);
            } else if (spell == SpellRegistry.STOMP_SPELL.get()) {
                controller.setAnimation(this.stomp);
            } else {
                controller.setAnimation(this.attack);
            }
            this.lastCastSpellType = spell;
            this.cancelCastAnimation = false;
            this.animatingLegs = false;
        }, () -> {
            this.cancelCastAnimation = true;
        });
    }

    public boolean isAnimating() {
        return this.isCasting() || this.animationControllerLongCast.getAnimationState() != AnimationController.State.STOPPED || this.animationControllerInstantCast.getAnimationState() != AnimationController.State.STOPPED;
    }

    public boolean shouldAlwaysAnimateHead() {
        return false;
    }

    public boolean shouldPointArmsWhileCasting() {
        return false;
    }

    public boolean shouldBeExtraAnimated() {
        return true;
    }

    public boolean shouldAlwaysAnimateLegs() {
        return !this.animatingLegs;
    }

    public boolean bobBodyWhileWalking() {
        return true;
    }

    public boolean shouldSheathSword() {
        return false;
    }

    static {
        DATA_ID_OWNER_UUID = SynchedEntityData.defineId(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
        DATA_BLOCKING = SynchedEntityData.defineId(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        DATA_ENRAGED = SynchedEntityData.defineId(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.INT);
        DATA_ARMOR = SynchedEntityData.defineId(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.INT);
        DATA_HEALTH = SynchedEntityData.defineId(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.INT);
        DATA_IS_SITTING = SynchedEntityData.defineId(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        DATA_IMPOSTOR = SynchedEntityData.defineId(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    }

    protected class StealItemsWhenNotWatchedGoal
    extends Goal {
        private final AbstractSpellCastingPet mob;
        private final double searchRadius;
        private ItemEntity targetItem;
        private int stealingTime;
        private final int STEALING_DURATION = 20;

        public StealItemsWhenNotWatchedGoal(AbstractSpellCastingPet this$0, AbstractSpellCastingPet mob, double searchRadius) {
            this.mob = mob;
            this.searchRadius = searchRadius;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.mob.getIsSitting().booleanValue()) {
                return false;
            }
            List nearbyItems = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(this.searchRadius), this::isDesirableItem);
            if (nearbyItems.isEmpty()) {
                return false;
            }
            if (this.isAnyPlayerWatching()) {
                return false;
            }
            this.targetItem = (ItemEntity)nearbyItems.get(0);
            double closestDistance = this.mob.distanceToSqr((Entity)this.targetItem);
            for (int i = 1; i < nearbyItems.size(); ++i) {
                ItemEntity item = (ItemEntity)nearbyItems.get(i);
                double distance = this.mob.distanceToSqr((Entity)item);
                if (!(distance < closestDistance)) continue;
                this.targetItem = item;
                closestDistance = distance;
            }
            return true;
        }

        public void start() {
            this.stealingTime = 0;
        }

        public boolean canContinueToUse() {
            return this.targetItem != null && this.targetItem.isAlive() && !this.isAnyPlayerWatching() && this.stealingTime < 20;
        }

        public void tick() {
            this.mob.getLookControl().setLookAt(this.targetItem.getX(), this.targetItem.getY(), this.targetItem.getZ());
            ++this.stealingTime;
            if (this.stealingTime >= 20) {
                this.mob.level().playSound(null, this.mob.getX(), this.mob.getY(), this.mob.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.NEUTRAL, 0.5f, 1.0f);
                this.targetItem.discard();
                this.targetItem = null;
            }
        }

        public void stop() {
            this.targetItem = null;
            this.stealingTime = 0;
        }

        private boolean isDesirableItem(ItemEntity itemEntity) {
            return itemEntity != null && itemEntity.isAlive() && (itemEntity.getItem().is(Items.GOLD_NUGGET) || itemEntity.getItem().is(Items.EMERALD));
        }

        private boolean isAnyPlayerWatching() {
            List nearbyPlayers = this.mob.level().getEntitiesOfClass(Player.class, new AABB(this.mob.getX() - 16.0, this.mob.getY() - 16.0, this.mob.getZ() - 16.0, this.mob.getX() + 16.0, this.mob.getY() + 16.0, this.mob.getZ() + 16.0));
            for (Player player : nearbyPlayers) {
                if (!player.isAlive() || player.isSpectator() || !this.isInPlayerFieldOfView(player)) continue;
                return true;
            }
            return false;
        }

        private boolean isInPlayerFieldOfView(Player player) {
            Vec3 playerViewVector = player.getViewVector(1.0f).normalize();
            Vec3 playerToMobVector = new Vec3(this.mob.getX() - player.getX(), this.mob.getEyeY() - player.getEyeY(), this.mob.getZ() - player.getZ());
            double distanceSquared = playerToMobVector.lengthSqr();
            playerToMobVector = playerToMobVector.normalize();
            if (distanceSquared < 4.0) {
                return true;
            }
            double dotProduct = playerViewVector.dot(playerToMobVector);
            return dotProduct > -0.1 && player.hasLineOfSight((Entity)this.mob);
        }
    }

    public class TeleportToOwnerGoal
    extends Goal {
        private final AbstractSpellCastingPet mob;
        @Nullable
        private LivingEntity owner;
        private Supplier<LivingEntity> ownerGetter;
        private float teleportDistance;

        public TeleportToOwnerGoal(AbstractSpellCastingPet this$0, AbstractSpellCastingPet pTamable, Supplier<LivingEntity> ownerGetter, float teleportDistance) {
            this.mob = pTamable;
            this.ownerGetter = ownerGetter;
            this.teleportDistance = teleportDistance;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingentity = this.ownerGetter.get();
            if (livingentity == null) {
                return false;
            }
            if (this.mob.distanceToSqr((Entity)livingentity) < (double)(this.teleportDistance * this.teleportDistance)) {
                return false;
            }
            if (this.mob.getIsSitting().booleanValue()) {
                return false;
            }
            this.owner = livingentity;
            return true;
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }

        public void tick() {
            boolean flag = this.shouldTryTeleportToOwner();
            if (!flag) {
                this.mob.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.mob.getMaxHeadXRot());
            } else {
                this.tryToTeleportToOwner();
            }
        }

        public void tryToTeleportToOwner() {
            LivingEntity livingentity = this.ownerGetter.get();
            if (livingentity != null) {
                this.teleportToAroundBlockPos(livingentity.blockPosition());
            }
        }

        public boolean shouldTryTeleportToOwner() {
            LivingEntity livingentity = this.ownerGetter.get();
            return livingentity != null && this.mob.distanceToSqr((Entity)livingentity) >= (double)(this.teleportDistance * this.teleportDistance);
        }

        private void teleportToAroundBlockPos(BlockPos pPos) {
            for (int i = 0; i < 10; ++i) {
                int j = this.mob.getRandom().nextIntBetweenInclusive(-3, 3);
                int k = this.mob.getRandom().nextIntBetweenInclusive(-3, 3);
                if (Math.abs(j) < 2 && Math.abs(k) < 2) continue;
                int l = this.mob.getRandom().nextIntBetweenInclusive(-1, 1);
                if (!this.maybeTeleportTo(pPos.getX() + j, pPos.getY() + l, pPos.getZ() + k)) continue;
                return;
            }
        }

        private boolean maybeTeleportTo(int pX, int pY, int pZ) {
            if (!this.canTeleportTo(new BlockPos(pX, pY, pZ))) {
                return false;
            }
            this.mob.moveTo((double)pX + 0.5, pY, (double)pZ + 0.5, this.mob.getYRot(), this.mob.getXRot());
            return true;
        }

        private boolean canTeleportTo(BlockPos pPos) {
            PathType pathtype = WalkNodeEvaluator.getPathTypeStatic((Mob)this.mob, (BlockPos)pPos);
            if (pathtype != PathType.WALKABLE) {
                return false;
            }
            BlockState blockstate = this.mob.level().getBlockState(pPos.below());
            if (blockstate.getBlock() instanceof LeavesBlock) {
                return false;
            }
            BlockPos blockpos = pPos.subtract((Vec3i)this.mob.blockPosition());
            return this.mob.level().noCollision((Entity)this.mob, this.mob.getBoundingBox().move(blockpos));
        }
    }

    protected class ApplyRandomEffectGoal
    extends Goal {
        private final AbstractSpellCastingPet entity;
        private final Supplier<LivingEntity> targetEntity;
        private final List<MobEffectInstance> effectHolders;
        private final int interval;
        private int tickCounter;

        public ApplyRandomEffectGoal(AbstractSpellCastingPet entity, Supplier<LivingEntity> targetEntity, List<MobEffectInstance> effectHolders, int interval) {
            this.entity = entity;
            this.targetEntity = targetEntity;
            this.effectHolders = effectHolders;
            this.interval = interval;
            this.tickCounter = 0;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity owner = this.targetEntity.get();
            if (owner == null) {
                return false;
            }
            if (this.horizontalDistanceSqr(owner, this.entity.position()) > 400.0f) {
                return false;
            }
            return ++this.tickCounter >= this.interval;
        }

        private float horizontalDistanceSqr(LivingEntity livingEntity, Vec3 vec3) {
            double dx = livingEntity.getX() - vec3.x;
            double dz = livingEntity.getZ() - vec3.z;
            return (float)(dx * dx + dz * dz);
        }

        public void start() {
            this.tickCounter = 0;
            AbstractSpellCastingPet.this.triggerAnim("interact_controller", "interact");
            LivingEntity owner = this.targetEntity.get();
            int randomIndex = ThreadLocalRandom.current().nextInt(this.effectHolders.size());
            AbstractSpellCastingPet.this.triggerAnim("interact_controller", "interact");
            owner.addEffect(this.effectHolders.get(randomIndex));
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }
    }
}

