/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.List;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.entity.generic.AbstractTerrestrianSpellCastingPet;
import net.alshanex.alshanex_familiars.registry.ItemRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PlaguePetEntity
extends AbstractTerrestrianSpellCastingPet {
    public static final ResourceLocation textureResource = new ResourceLocation("alshanex_familiars", "textures/entity/plague_pet.png");

    public PlaguePetEntity(EntityType<? extends AbstractTerrestrianSpellCastingPet> pEntityType, Level pLevel) {
        super((EntityType<? extends AbstractSpellCastingPet>)pEntityType, pLevel);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.25, 50, 75).setSpells(List.of((AbstractSpell)SpellRegistry.ACID_ORB_SPELL.get(), (AbstractSpell)SpellRegistry.FIREFLY_SWARM_SPELL.get(), (AbstractSpell)SpellRegistry.POISON_SPLASH_SPELL.get()), List.of((AbstractSpell)SpellRegistry.HEAL_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.BLIGHT_SPELL.get(), (AbstractSpell)SpellRegistry.HEARTSTOP_SPELL.get())).setSingleUseSpell((AbstractSpell)SpellRegistry.HEAL_SPELL.get(), 400, 500, 4, 5));
    }

    @Override
    protected void clearMovementGoals() {
        super.clearMovementGoals();
        this.goalSelector.removeAllGoals(goal -> goal instanceof WizardAttackGoal);
    }

    @Override
    protected void restoreMovementGoals() {
        super.restoreMovementGoals();
        this.goalSelector.addGoal(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.25, 50, 75).setSpells(List.of((AbstractSpell)SpellRegistry.ACID_ORB_SPELL.get(), (AbstractSpell)SpellRegistry.FIREFLY_SWARM_SPELL.get(), (AbstractSpell)SpellRegistry.POISON_SPLASH_SPELL.get()), List.of((AbstractSpell)SpellRegistry.HEAL_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.BLIGHT_SPELL.get(), (AbstractSpell)SpellRegistry.HEARTSTOP_SPELL.get())).setSingleUseSpell((AbstractSpell)SpellRegistry.HEAL_SPELL.get(), 400, 500, 4, 5));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.MAX_HEALTH, 50.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
    }

    @Override
    protected boolean isFood(ItemStack item) {
        return item.is((Item)ItemRegistry.SPIDER_FANG.get());
    }

    @Override
    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.getSummoner() != null) {
            MagicManager.spawnParticles((Level)this.level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.NATURE.get()).getTargetingColor(), 2.0f), (double)this.getX(), (double)(this.getY() + (double)0.165f), (double)this.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tickCount % 8 == 0) {
            if (this.getSummoner() != null && this.horizontalDistanceSqr(this.getSummoner(), this.position()) < 400.0f && this.getSummoner().hasEffect(MobEffects.POISON)) {
                this.getSummoner().removeEffect(MobEffects.POISON);
            }
            this.removeEffect(MobEffects.POISON);
            if (this.getSummoner() != null && this.horizontalDistanceSqr(this.getSummoner(), this.position()) < 400.0f) {
                if (this.getSummoner().hasEffect((Holder)MobEffectRegistry.SPIDER_ASPECT)) {
                    if (this.getSummoner().getEffect((Holder)MobEffectRegistry.SPIDER_ASPECT).getDuration() < 500) {
                        this.getSummoner().addEffect(new MobEffectInstance((Holder)MobEffectRegistry.SPIDER_ASPECT, 500 - this.getSummoner().getEffect((Holder)MobEffectRegistry.SPIDER_ASPECT).getDuration(), 0, false, false, true));
                    }
                } else {
                    this.getSummoner().addEffect(new MobEffectInstance((Holder)MobEffectRegistry.SPIDER_ASPECT, 500, 0, false, false, true));
                }
            }
            this.addEffect(new MobEffectInstance((Holder)MobEffectRegistry.SPIDER_ASPECT, 15, 0, false, false, true));
        }
    }

    private float horizontalDistanceSqr(LivingEntity livingEntity, Vec3 vec3) {
        double dx = livingEntity.getX() - vec3.x;
        double dz = livingEntity.getZ() - vec3.z;
        return (float)(dx * dx + dz * dz);
    }
}

