/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import net.alshanex.alshanex_familiars.advancements.SimpleAdvancementTrigger;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.entity.generic.AbstractTerrestrianSpellCastingPet;
import net.alshanex.alshanex_familiars.registry.CriteriaTriggersRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;

public class DruidPetEntity
extends AbstractTerrestrianSpellCastingPet {
    public static final ResourceLocation textureResource = new ResourceLocation("alshanex_familiars", "textures/entity/druid_pet.png");

    public DruidPetEntity(EntityType<? extends AbstractTerrestrianSpellCastingPet> pEntityType, Level pLevel) {
        super((EntityType<? extends AbstractSpellCastingPet>)pEntityType, pLevel);
        this.setRandomImpostor();
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.25, 100, 150).setSpells(List.of((AbstractSpell)SpellRegistry.FIREFLY_SWARM_SPELL.get(), (AbstractSpell)SpellRegistry.LOB_CREEPER_SPELL.get()), List.of((AbstractSpell)SpellRegistry.CHAIN_CREEPER_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.OAKSKIN_SPELL.get(), (AbstractSpell)SpellRegistry.BLIGHT_SPELL.get(), (AbstractSpell)SpellRegistry.SLOW_SPELL.get())).setSingleUseSpell((AbstractSpell)SpellRegistry.ROOT_SPELL.get(), 340, 400, 8, 10));
        this.goalSelector.addGoal(11, (Goal)new ApplyBonemealGoal(this, this::getSummoner, 300));
        this.goalSelector.addGoal(12, (Goal)new CustomBreedGoal(this, this));
    }

    @Override
    protected void clearMovementGoals() {
        super.clearMovementGoals();
        this.goalSelector.removeAllGoals(goal -> goal instanceof WizardAttackGoal || goal instanceof ApplyBonemealGoal || goal instanceof CustomBreedGoal);
    }

    @Override
    protected void restoreMovementGoals() {
        super.restoreMovementGoals();
        this.goalSelector.addGoal(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.25, 100, 150).setSpells(List.of((AbstractSpell)SpellRegistry.FIREFLY_SWARM_SPELL.get(), (AbstractSpell)SpellRegistry.LOB_CREEPER_SPELL.get()), List.of((AbstractSpell)SpellRegistry.CHAIN_CREEPER_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.OAKSKIN_SPELL.get(), (AbstractSpell)SpellRegistry.BLIGHT_SPELL.get(), (AbstractSpell)SpellRegistry.SLOW_SPELL.get(), (AbstractSpell)SpellRegistry.INVISIBILITY_SPELL.get())).setSingleUseSpell((AbstractSpell)SpellRegistry.ROOT_SPELL.get(), 340, 400, 8, 10));
        this.goalSelector.addGoal(11, (Goal)new ApplyBonemealGoal(this, this::getSummoner, 300));
        this.goalSelector.addGoal(12, (Goal)new CustomBreedGoal(this, this));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.MAX_HEALTH, 50.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
    }

    @Override
    protected boolean isFood(ItemStack item) {
        return item.is(ItemTags.SAPLINGS);
    }

    @Override
    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.getSummoner() != null) {
            MagicManager.spawnParticles((Level)this.level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.NATURE.get()).getTargetingColor(), 2.0f), (double)this.getX(), (double)(this.getY() + (double)0.165f), (double)this.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    @Override
    protected void triggerAdvancement(ServerPlayer player) {
        ((SimpleAdvancementTrigger)((Object)CriteriaTriggersRegistry.TAMING_DRUID_TRIGGER.get())).trigger(player);
    }

    protected class ApplyBonemealGoal
    extends Goal {
        private final AbstractSpellCastingPet controllerEntity;
        private final Supplier<LivingEntity> targetEntity;
        private final int interval;
        private int tickCounter;

        public ApplyBonemealGoal(AbstractSpellCastingPet controllerEntity, Supplier<LivingEntity> targetEntity, int interval) {
            this.controllerEntity = controllerEntity;
            this.interval = interval;
            this.targetEntity = targetEntity;
            this.tickCounter = 0;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            LivingEntity owner = this.targetEntity.get();
            if (owner == null || !(owner instanceof Player)) {
                return false;
            }
            return this.controllerEntity.isAlive() && owner.isAlive();
        }

        public void tick() {
            ++this.tickCounter;
            if (this.tickCounter >= this.interval) {
                this.tickCounter = 0;
                BlockPos targetPos = this.controllerEntity.blockPosition();
                Level level = this.controllerEntity.level();
                Player player = (Player)this.targetEntity.get();
                DruidPetEntity.this.triggerAnim("interact_controller", "interact");
                for (int x = -5; x <= 5; ++x) {
                    for (int y = -5; y <= 5; ++y) {
                        for (int z = -5; z <= 5; ++z) {
                            BlockPos currentPos = targetPos.offset(x, y, z);
                            if (!this.applyBonemeal(level, currentPos, player) || level.isClientSide) continue;
                            level.levelEvent(1505, currentPos, 15);
                        }
                    }
                }
            }
        }

        boolean applyBonemeal(Level level, BlockPos pos, Player player) {
            BonemealableBlock bonemealableblock;
            BlockState blockstate = level.getBlockState(pos);
            BonemealEvent event = EventHooks.fireBonemealEvent((Player)player, (Level)level, (BlockPos)pos, (BlockState)blockstate, (ItemStack)new ItemStack((ItemLike)Items.BONE_MEAL));
            if (event.isCanceled()) {
                return event.isSuccessful();
            }
            Block block = blockstate.getBlock();
            if (block instanceof BonemealableBlock && (bonemealableblock = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, pos, blockstate) && !(bonemealableblock instanceof TallGrassBlock) && bonemealableblock != Blocks.FERN && !(bonemealableblock instanceof GrassBlock)) {
                if (level instanceof ServerLevel && bonemealableblock.isBonemealSuccess(level, level.random, pos, blockstate)) {
                    bonemealableblock.performBonemeal((ServerLevel)level, level.random, pos, blockstate);
                }
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }
    }

    protected class CustomBreedGoal
    extends Goal {
        private final AbstractSpellCastingPet pet;
        private Animal animal;

        public CustomBreedGoal(DruidPetEntity this$0, AbstractSpellCastingPet pet) {
            this.pet = pet;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.animal != null) {
                return false;
            }
            this.animal = this.pet.level().getEntitiesOfClass(Animal.class, this.pet.getBoundingBox().inflate(10.0), a -> a.canFallInLove() && !a.isPanicking() && !a.isBaby() && a.getAge() == 0).stream().min(Comparator.comparingDouble(arg_0 -> ((AbstractSpellCastingPet)this.pet).distanceTo(arg_0))).orElse(null);
            return this.animal != null;
        }

        public boolean canContinueToUse() {
            return this.animal != null && this.animal.isAlive() && this.animal.canFallInLove();
        }

        public void start() {
            this.pet.getNavigation().moveTo((Entity)this.animal, 1.0);
        }

        public void tick() {
            if (this.animal == null) {
                return;
            }
            if ((double)this.pet.distanceTo((Entity)this.animal) < 2.0) {
                this.pet.getLookControl().setLookAt((Entity)this.animal, 10.0f, 10.0f);
                if (this.animal.canFallInLove() && this.animal.getAge() == 0) {
                    this.animal.setInLove(null);
                }
            } else {
                this.pet.getNavigation().moveTo((Entity)this.animal, 1.0);
            }
        }

        public void stop() {
            this.animal = null;
        }
    }
}

