/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.block.pedestal.PedestalTile;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.BlockRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.alshanex.alshanex_familiars.advancements.SimpleAdvancementTrigger;
import net.alshanex.alshanex_familiars.entity.generic.AbstractFlyingSpellCastingPet;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.registry.CriteriaTriggersRegistry;
import net.alshanex.alshanex_familiars.registry.PetSpellRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ArchmagePetEntity
extends AbstractFlyingSpellCastingPet {
    public static final ResourceLocation textureResource = new ResourceLocation("alshanex_familiars", "textures/entity/archmage_pet.png");

    public ArchmagePetEntity(EntityType<? extends AbstractFlyingSpellCastingPet> pEntityType, Level pLevel) {
        super((EntityType<? extends AbstractSpellCastingPet>)pEntityType, pLevel);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 30, 40).setSpells(List.of((AbstractSpell)SpellRegistry.MAGIC_MISSILE_SPELL.get(), (AbstractSpell)SpellRegistry.FIREBOLT_SPELL.get(), (AbstractSpell)SpellRegistry.ICICLE_SPELL.get(), (AbstractSpell)SpellRegistry.GUIDING_BOLT_SPELL.get(), (AbstractSpell)SpellRegistry.ELDRITCH_BLAST_SPELL.get()), List.of((AbstractSpell)SpellRegistry.GUST_SPELL.get(), (AbstractSpell)SpellRegistry.SHIELD_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.EVASION_SPELL.get())).setSingleUseSpell((AbstractSpell)SpellRegistry.RAY_OF_FROST_SPELL.get(), 160, 300, 3, 5).setIsFlying());
        this.goalSelector.addGoal(3, (Goal)new RerollScrollGoal(this, this::getSummoner, 10, 200));
    }

    @Override
    protected void clearMovementGoals() {
        super.clearMovementGoals();
        this.goalSelector.removeAllGoals(goal -> goal instanceof WizardAttackGoal || goal instanceof RerollScrollGoal);
    }

    @Override
    protected void restoreMovementGoals() {
        super.restoreMovementGoals();
        this.goalSelector.addGoal(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 30, 40).setSpells(List.of((AbstractSpell)SpellRegistry.MAGIC_MISSILE_SPELL.get(), (AbstractSpell)SpellRegistry.FIREBOLT_SPELL.get(), (AbstractSpell)SpellRegistry.ICICLE_SPELL.get(), (AbstractSpell)SpellRegistry.GUIDING_BOLT_SPELL.get(), (AbstractSpell)SpellRegistry.ELDRITCH_BLAST_SPELL.get()), List.of((AbstractSpell)SpellRegistry.GUST_SPELL.get(), (AbstractSpell)SpellRegistry.SHIELD_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.EVASION_SPELL.get())).setSingleUseSpell((AbstractSpell)SpellRegistry.RAY_OF_FROST_SPELL.get(), 160, 300, 3, 5));
        this.goalSelector.addGoal(3, (Goal)new RerollScrollGoal(this, this::getSummoner, 10, 600));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.MAX_HEALTH, 30.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.FLYING_SPEED, (double)0.1f).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    @Override
    public void tick() {
        List bullets;
        super.tick();
        if (this.tickCount % 5 == 0 && !this.level.isClientSide && !(bullets = this.level.getEntitiesOfClass(ShulkerBullet.class, this.getBoundingBox().inflate(10.0))).isEmpty()) {
            this.triggerAnim("interact_controller", "interact");
            for (ShulkerBullet bullet : bullets) {
                MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)ParticleTypes.POOF, (double)bullet.getX(), (double)bullet.getY(), (double)bullet.getZ(), (int)25, (double)0.4, (double)0.8, (double)0.4, (double)0.03, (boolean)false);
                bullet.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
    }

    @Override
    protected boolean isFood(ItemStack item) {
        return item.is((Item)ItemRegistry.MAGIC_CLOTH.get());
    }

    @Override
    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.getSummoner() != null) {
            MagicManager.spawnParticles((Level)this.level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ICE.get()).getTargetingColor(), 2.0f), (double)this.getX(), (double)(this.getY() + (double)0.165f), (double)this.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    @Override
    protected void triggerAdvancement(ServerPlayer player) {
        ((SimpleAdvancementTrigger)((Object)CriteriaTriggersRegistry.TAMING_ARCHMAGE_TRIGGER.get())).trigger(player);
    }

    protected class RerollScrollGoal
    extends Goal {
        private final AbstractSpellCastingPet controllerEntity;
        private final Supplier<LivingEntity> targetEntity;
        private final int radius;
        private final int interval;
        private int tickCounter;

        public RerollScrollGoal(AbstractSpellCastingPet controllerEntity, Supplier<LivingEntity> targetEntity, int radius, int interval) {
            this.controllerEntity = controllerEntity;
            this.targetEntity = targetEntity;
            this.radius = radius;
            this.interval = interval;
            this.tickCounter = 0;
            this.setFlags(EnumSet.noneOf(Goal.Flag.class));
        }

        public boolean canUse() {
            LivingEntity owner = this.targetEntity.get();
            if (owner == null) {
                return false;
            }
            return this.controllerEntity.isAlive() && owner.isAlive();
        }

        public void tick() {
            if (this.tickCounter < this.interval) {
                ++this.tickCounter;
            }
            if (this.tickCounter >= this.interval) {
                LivingEntity owner = this.targetEntity.get();
                BlockPos controllerPos = owner.blockPosition();
                PedestalTile nearestPedestal = null;
                double minDistance = Double.MAX_VALUE;
                for (int x = -this.radius; x <= this.radius; ++x) {
                    for (int y = -this.radius; y <= this.radius; ++y) {
                        for (int z = -this.radius; z <= this.radius; ++z) {
                            double distance;
                            PedestalTile pedestal;
                            BlockPos currentPos = controllerPos.offset(x, y, z);
                            BlockState blockState = this.controllerEntity.level().getBlockState(currentPos);
                            if (!blockState.is((Holder)BlockRegistry.PEDESTAL_BLOCK) || (pedestal = (PedestalTile)this.controllerEntity.level().getBlockEntity(currentPos)) == null || pedestal.getHeldItem() == null || pedestal.getHeldItem().isEmpty() || !(pedestal.getHeldItem().getItem() instanceof Scroll) || !((distance = controllerPos.distSqr((Vec3i)currentPos)) < minDistance)) continue;
                            minDistance = distance;
                            nearestPedestal = pedestal;
                        }
                    }
                }
                if (nearestPedestal != null) {
                    BlockState prevState = nearestPedestal.getBlockState();
                    ItemStack item = nearestPedestal.getHeldItem();
                    SpellData spellData = ISpellContainer.get((ItemStack)item).getSpellAtIndex(0);
                    ArchmagePetEntity.this.triggerAnim("interact_controller", "interact");
                    ItemStack finalItem = this.getResultSpell(spellData.getRarity());
                    SpellData spellDataFinal = ISpellContainer.get((ItemStack)finalItem).getSpellAtIndex(0);
                    nearestPedestal.setHeldItem(finalItem);
                    BlockState nextState = nearestPedestal.getBlockState();
                    ArchmagePetEntity.this.level.sendBlockUpdated(nearestPedestal.getBlockPos(), prevState, nextState, 2);
                    float radius = 2.0f;
                    MagicManager.spawnParticles((Level)ArchmagePetEntity.this.level, (ParticleOptions)new BlastwaveParticleOptions(spellDataFinal.getSpell().getSchoolType().getTargetingColor(), radius), (double)nearestPedestal.getBlockPos().getCenter().x, (double)(nearestPedestal.getBlockPos().getCenter().y + 1.0), (double)nearestPedestal.getBlockPos().getCenter().z, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
                    this.tickCounter = 0;
                }
            }
        }

        private ItemStack getResultSpell(SpellRarity rarity) {
            ItemStack resultStack = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
            resultStack.setCount(1);
            List spells = SpellRegistry.getEnabledSpells();
            List<AbstractSpell> finalSpells = spells.stream().filter(spell -> spell.allowCrafting() || spell.allowLooting() || spell.equals((Object)PetSpellRegistry.SUMMON_SHADOW.get())).toList();
            boolean spellSelected = false;
            Random random = new Random();
            int chance = random.nextInt(100);
            if (chance < 5 && rarity != SpellRarity.LEGENDARY) {
                int rarityValue = rarity.getValue() + 1;
                rarity = Arrays.stream(SpellRarity.values()).filter(rarityAux -> rarityAux.getValue() == rarityValue).findFirst().get();
            }
            while (!spellSelected) {
                Random spellRandom = new Random();
                int randomSpellIndex = spellRandom.nextInt(finalSpells.size());
                AbstractSpell spell2 = finalSpells.get(randomSpellIndex);
                if (spell2.getMaxRarity() < rarity.getValue() || spell2.getMinRarity() > rarity.getValue()) continue;
                ISpellContainer.createScrollContainer((AbstractSpell)spell2, (int)spell2.getMinLevelForRarity(rarity), (ItemStack)resultStack);
                spellSelected = true;
            }
            return resultStack;
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }
    }
}

