/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.block.entity;

import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.Set;
import javax.annotation.Nonnull;
import net.alshanex.alshanex_familiars.registry.BlockEntityRegistry;
import net.alshanex.alshanex_familiars.util.rituals.RitualHelper;
import net.alshanex.alshanex_familiars.util.rituals.RitualRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RitualCorePedestalEntity
extends BlockEntity {
    private static final String NBT_HELD_ITEM = "heldItem";
    private ItemStack heldItem = ItemStack.EMPTY;
    private boolean itemInRecipe = false;
    private boolean isValidRitual = false;
    private int counter = 0;

    public RitualCorePedestalEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntityRegistry.RITUAL_CORE.get(), pPos, pBlockState);
    }

    public ItemStack getHeldItem() {
        return this.heldItem;
    }

    public void setHeldItem(ItemStack newItem) {
        this.heldItem = newItem;
        this.setChanged();
        this.counter = 0;
        this.isValidRitual = false;
        if (!this.itemInRecipe) {
            Set<RitualRecipe> recipes = RitualHelper.getRitualRecipes().keySet();
            for (RitualRecipe recipe : recipes) {
                if (!recipe.getCentralItem().equals(newItem.getItem())) continue;
                this.itemInRecipe = true;
                break;
            }
        } else {
            Set<RitualRecipe> recipes = RitualHelper.getRitualRecipes().keySet();
            for (RitualRecipe recipe : recipes) {
                if (recipe.getCentralItem().equals(newItem.getItem())) break;
            }
            this.itemInRecipe = false;
        }
    }

    public void drops() {
        SimpleContainer simpleContainer = new SimpleContainer(new ItemStack[]{this.heldItem});
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)simpleContainer);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.readNBT(pTag, pRegistries);
    }

    protected void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider registryAccess) {
        this.writeNBT(tag, registryAccess);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    private CompoundTag writeNBT(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        if (!this.heldItem.isEmpty()) {
            nbt.put(NBT_HELD_ITEM, this.heldItem.save(pRegistries));
        } else {
            nbt.put(NBT_HELD_ITEM, (Tag)new CompoundTag());
        }
        return nbt;
    }

    private CompoundTag readNBT(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        if (nbt.contains(NBT_HELD_ITEM)) {
            this.heldItem = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)nbt.getCompound(NBT_HELD_ITEM));
        }
        return nbt;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (this.itemInRecipe && !pLevel.isClientSide()) {
            this.isValidRitual = RitualHelper.isValidRecipe(pLevel, pPos, this.getHeldItem());
        }
        if (this.isValidRitual && !pLevel.isClientSide()) {
            Item result;
            ParticleOptions particles;
            if (this.counter < 100) {
                ++this.counter;
                if (this.counter % 10 == 0 && (particles = RitualHelper.getParticleForItem(result = RitualHelper.getResultForRecipe(pLevel, pPos, this.getHeldItem()))) != null) {
                    RitualHelper.spawnParticlesAtPedestals(particles, pPos, pLevel);
                }
            }
            if (this.counter == 100) {
                result = RitualHelper.getResultForRecipe(pLevel, pPos, this.getHeldItem());
                particles = RitualHelper.getParticleForItem(result);
                MagicManager.spawnParticles((Level)pLevel, (ParticleOptions)new BlastwaveParticleOptions(RitualHelper.getColorForParticles(particles), 6.0f), (double)pPos.getX(), (double)((float)pPos.getY() + 0.165f), (double)pPos.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
                RitualHelper.clearItemsFromPedestals(pLevel, pPos);
                BlockState prevState = this.getBlockState();
                this.setHeldItem(new ItemStack((ItemLike)result));
                BlockState nextState = this.getBlockState();
                pLevel.sendBlockUpdated(pPos, prevState, nextState, 2);
                this.counter = 0;
                this.itemInRecipe = false;
                this.isValidRitual = false;
            }
        }
    }
}

