/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.alshanex.alshanex_familiars.block.entity.PetBedBlockEntity;
import net.alshanex.alshanex_familiars.item.curios.AbstractFamiliarTrinket;
import net.alshanex.alshanex_familiars.registry.DataComponentRegistry;
import net.alshanex.alshanex_familiars.registry.ItemRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PetBedBlockEntityRenderer
implements BlockEntityRenderer<PetBedBlockEntity> {
    public PetBedBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(PetBedBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack stack = blockEntity.getRenderStack();
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.3f, 0.5f);
        poseStack.scale(0.7f, 0.7f, 0.7f);
        Direction blockDirection = (Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        float rotation = 0.0f;
        switch (blockDirection) {
            case EAST: {
                rotation = 90.0f;
                break;
            }
            case SOUTH: {
                rotation = 0.0f;
                break;
            }
            case WEST: {
                rotation = 270.0f;
                break;
            }
            default: {
                rotation = 180.0f;
            }
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        if (stack != null && stack != ItemStack.EMPTY && (stack.is((Item)ItemRegistry.FAMILIAR_TOME.get()) || stack.getItem() instanceof AbstractFamiliarTrinket)) {
            boolean isSummoned;
            CompoundTag nbt;
            if (stack.has(DataComponentRegistry.FAMILIAR_TOME)) {
                nbt = (CompoundTag)stack.get(DataComponentRegistry.FAMILIAR_TOME);
                EntityType type = EntityType.byString((String)nbt.getString("entity")).orElse(null);
                Entity entity = this.getEntityFromType(blockEntity.getLevel(), PetBedBlockEntityRenderer.getPetSleeping(type));
                if (entity != null) {
                    Minecraft.getInstance().getEntityRenderDispatcher().render(entity, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, bufferSource, packedLight);
                }
            }
            if (stack.has(DataComponentRegistry.FAMILIAR_TRINKET) && !(isSummoned = (nbt = (CompoundTag)stack.get(DataComponentRegistry.FAMILIAR_TRINKET)).getBoolean("isSummoned"))) {
                EntityType type = EntityType.byString((String)nbt.getString("entity")).orElse(null);
                Entity entity = this.getEntityFromType(blockEntity.getLevel(), PetBedBlockEntityRenderer.getPetSleeping(type));
                if (entity != null) {
                    Minecraft.getInstance().getEntityRenderDispatcher().render(entity, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, bufferSource, packedLight);
                }
            }
        }
        poseStack.popPose();
    }

    public static EntityType getPetSleeping(EntityType type) {
        String familiarType = type.toString();
        String[] split = familiarType.split("\\.");
        String namespace = split[1];
        String path = split[2];
        EntityType sleepingType = EntityType.byString((String)(namespace + ":sleeping_" + path)).orElse(null);
        return sleepingType;
    }

    @Nullable
    public Entity getEntityFromType(Level world, EntityType type) {
        return type.create(world);
    }
}

