/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.block;

import com.mojang.serialization.MapCodec;
import io.redspace.ironsspellbooks.block.pedestal.PedestalBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.alshanex.alshanex_familiars.block.entity.DruidStatueEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DruidStatue
extends PedestalBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape mainBody;
    private static final VoxelShape SHAPE_NORTH;
    public static final MapCodec<DruidStatue> CODEC;

    private static VoxelShape rotateBox(VoxelShape shape, Rotation rotation) {
        List boxes = shape.toAabbs();
        VoxelShape rotatedShape = Shapes.empty();
        for (AABB box : boxes) {
            double x1 = box.minX;
            double y1 = box.minY;
            double z1 = box.minZ;
            double x2 = box.maxX;
            double y2 = box.maxY;
            double z2 = box.maxZ;
            rotatedShape = Shapes.or((VoxelShape)rotatedShape, (VoxelShape)(switch (rotation) {
                case Rotation.CLOCKWISE_90 -> Shapes.box((double)(1.0 - z2), (double)y1, (double)x1, (double)(1.0 - z1), (double)y2, (double)x2);
                case Rotation.CLOCKWISE_180 -> Shapes.box((double)(1.0 - x2), (double)y1, (double)(1.0 - z2), (double)(1.0 - x1), (double)y2, (double)(1.0 - z1));
                case Rotation.COUNTERCLOCKWISE_90 -> Shapes.box((double)z1, (double)y1, (double)(1.0 - x2), (double)z2, (double)y2, (double)(1.0 - x1));
                default -> Shapes.box((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            }));
        }
        return rotatedShape;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public DruidStatue() {
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case SOUTH: {
                return DruidStatue.rotateBox(SHAPE_NORTH, Rotation.CLOCKWISE_180);
            }
            case EAST: {
                return DruidStatue.rotateBox(SHAPE_NORTH, Rotation.CLOCKWISE_90);
            }
            case WEST: {
                return DruidStatue.rotateBox(SHAPE_NORTH, Rotation.COUNTERCLOCKWISE_90);
            }
        }
        return SHAPE_NORTH;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.getBlock() != pNewState.getBlock() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof DruidStatueEntity) {
            ((DruidStatueEntity)blockEntity).drops();
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DruidStatueEntity(pos, state);
    }

    public ItemInteractionResult useItemOn(ItemStack pStack, BlockState state, Level pLevel, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity entity;
        if (!pLevel.isClientSide() && (entity = pLevel.getBlockEntity(pos)) instanceof DruidStatueEntity) {
            DruidStatueEntity pedestalTile = (DruidStatueEntity)entity;
            ItemStack currentPedestalItem = pedestalTile.getHeldItem();
            ItemStack handItem = player.getItemInHand(hand);
            ItemStack playerItem = currentPedestalItem.copy();
            if (handItem.isEmpty() || handItem.getCount() == 1) {
                player.setItemInHand(hand, playerItem);
            } else {
                this.dropItem(playerItem, player);
            }
            pedestalTile.setHeldItem(ItemStack.EMPTY);
            currentPedestalItem = handItem.copy();
            if (!currentPedestalItem.isEmpty()) {
                currentPedestalItem.setCount(1);
                pedestalTile.setHeldItem(currentPedestalItem);
                handItem.shrink(1);
            }
            pLevel.sendBlockUpdated(pos, state, state, 2);
        }
        return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
    }

    private void dropItem(ItemStack itemstack, Player owner) {
        ServerPlayer serverplayer;
        ItemEntity itementity;
        if (owner instanceof ServerPlayer && (itementity = (serverplayer = (ServerPlayer)owner).drop(itemstack, false)) != null) {
            itementity.setNoPickUpDelay();
            itementity.setThrower((Entity)owner);
        }
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return 0.0f;
    }

    public float defaultDestroyTime() {
        return Float.MAX_VALUE;
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        return false;
    }

    static {
        SHAPE_NORTH = mainBody = Block.box((double)3.475, (double)2.0237, (double)3.74144, (double)12.475, (double)11.0237, (double)12.74144);
        CODEC = DruidStatue.simpleCodec(t -> new DruidStatue());
    }
}

