/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification;

import com.almostreliable.unified.api.unification.UnificationEntry;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public class UnificationEntryImpl<T>
implements UnificationEntry<T> {
    private final Registry<T> registry;
    private final ResourceKey<T> key;
    @Nullable
    private T value;
    @Nullable
    private TagKey<T> tag;

    public UnificationEntryImpl(Registry<T> registry, ResourceLocation key) {
        this.registry = registry;
        this.key = ResourceKey.create((ResourceKey)registry.key(), (ResourceLocation)key);
    }

    public UnificationEntryImpl(Registry<T> registry, T entry) {
        this.key = (ResourceKey)registry.getResourceKey(entry).orElseThrow(() -> new IllegalArgumentException("Entry " + String.valueOf(entry) + " does not belong to " + String.valueOf(registry)));
        this.registry = registry;
        this.value = entry;
    }

    @Override
    public ResourceKey<T> key() {
        return this.key;
    }

    @Override
    public ResourceLocation id() {
        return this.key.location();
    }

    @Override
    public T value() {
        if (this.value == null) {
            this.value = this.registry.getOptional(this.key).orElseThrow(() -> new IllegalStateException("entry " + String.valueOf(this.key) + " not found in " + String.valueOf(this.registry)));
        }
        return this.value;
    }

    @Override
    public TagKey<T> tag() {
        if (this.tag == null) {
            throw new IllegalStateException("tag not bound to " + String.valueOf(this));
        }
        return this.tag;
    }

    @Override
    public Holder.Reference<T> asHolderOrThrow() {
        return this.registry.getHolderOrThrow(this.key);
    }

    public void bindTag(TagKey<T> tag) {
        if (this.tag != null) {
            throw new IllegalStateException("tag already bound to " + String.valueOf(this.tag));
        }
        this.tag = tag;
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public boolean equals(Object other) {
        UnificationEntry holder;
        return other instanceof UnificationEntry && (holder = (UnificationEntry)other).key() == this.key();
    }

    public String toString() {
        return "UnificationEntry{" + String.valueOf(this.key()) + "}";
    }
}

