/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat.viewer;

import com.almostreliable.unified.compat.viewer.ClientRecipeTracker;
import com.almostreliable.unified.utils.Utils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

final class RecipeIndicator {
    static final int RENDER_SIZE = 10;
    private static final int TEXTURE_SIZE = 16;
    private static final ResourceLocation TEXTURE = Utils.getRL("textures/ingot.png");

    private RecipeIndicator() {
    }

    static void renderIndicator(GuiGraphics guiGraphics, int pX, int pY, int size) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)pX, (float)pY, 0.0f);
        float scale = (float)size / 16.0f;
        poseStack.scale(scale, scale, scale);
        guiGraphics.blit(TEXTURE, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        poseStack.popPose();
    }

    static List<Component> constructTooltip(ClientRecipeTracker.ClientRecipeLink link) {
        MutableComponent unified = Component.translatable((String)Utils.prefix("unified")).append(": ").withStyle(c -> c.withColor(ChatFormatting.AQUA));
        unified.append((Component)Component.translatable((String)Utils.prefix(link.isUnified() ? "yes" : "no")).withStyle(c -> c.withColor(ChatFormatting.WHITE)));
        MutableComponent duplicate = Component.translatable((String)Utils.prefix("duplicate")).append(": ").withStyle(c -> c.withColor(ChatFormatting.AQUA));
        duplicate.append((Component)Component.translatable((String)Utils.prefix(link.isDuplicate() ? "yes" : "no")).withStyle(c -> c.withColor(ChatFormatting.WHITE)));
        return List.of(Component.translatable((String)Utils.prefix("description")).withStyle(c -> c.withColor(ChatFormatting.GOLD)), Component.literal((String)" "), unified, duplicate, Component.literal((String)" "), Component.translatable((String)Utils.prefix("warning")).withStyle(c -> c.withColor(ChatFormatting.RED)));
    }

    static void renderTooltip(GuiGraphics guiGraphics, ClientRecipeTracker.ClientRecipeLink link, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        Screen screen = mc.screen;
        if (screen == null) {
            return;
        }
        List tooltip = RecipeIndicator.constructTooltip(link).stream().map(c -> font.split((FormattedText)c, screen.width - (int)mouseX - 200)).flatMap(Collection::stream).toList();
        guiGraphics.renderTooltip(font, tooltip, (int)mouseX, (int)mouseY);
    }
}

