/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.api;

import com.almostreliable.unified.api.AlmostUnifiedRuntime;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.Set;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public interface AlmostUnified {
    public static final AlmostUnified INSTANCE = ServiceLoader.load(AlmostUnified.class).findFirst().orElseGet(Empty::new);

    public boolean isRuntimeLoaded();

    @Nullable
    public AlmostUnifiedRuntime getRuntime();

    public AlmostUnifiedRuntime getRuntimeOrThrow();

    public Collection<TagKey<Item>> getTags();

    public Collection<Item> getTagEntries(TagKey<Item> var1);

    @Nullable
    public TagKey<Item> getRelevantItemTag(ItemLike var1);

    @Nullable
    public Item getVariantItemTarget(ItemLike var1);

    @Nullable
    public Item getTagTargetItem(TagKey<Item> var1);

    public static class Empty
    implements AlmostUnified {
        @Override
        public boolean isRuntimeLoaded() {
            return false;
        }

        @Override
        @Nullable
        public AlmostUnifiedRuntime getRuntime() {
            return null;
        }

        @Override
        public AlmostUnifiedRuntime getRuntimeOrThrow() {
            throw new IllegalStateException("runtime is not loaded");
        }

        @Override
        public Collection<TagKey<Item>> getTags() {
            return Set.of();
        }

        @Override
        public Collection<Item> getTagEntries(TagKey<Item> tag) {
            return Set.of();
        }

        @Override
        @Nullable
        public TagKey<Item> getRelevantItemTag(ItemLike itemLike) {
            return null;
        }

        @Override
        @Nullable
        public Item getVariantItemTarget(ItemLike itemLike) {
            return null;
        }

        @Override
        @Nullable
        public Item getTagTargetItem(TagKey<Item> tag) {
            return null;
        }
    }
}

