/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.alltheores.datagen.data.recipe.actuallyadditions;

import de.ellpeck.actuallyadditions.data.CrushingRecipeGenerator;
import de.ellpeck.actuallyadditions.mod.crafting.CrushingRecipe;
import java.util.concurrent.CompletableFuture;
import net.allthemods.alltheores.content.blocks.sets.ATOSetHelper;
import net.allthemods.alltheores.registry.ATORegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ATOAACrushingRecipeProvider
extends RecipeProvider {
    public ATOAACrushingRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    private ResourceLocation crushingRecipeDir(String type) {
        return ResourceLocation.fromNamespaceAndPath((String)"alltheores", (String)("crushing/" + type));
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ATOSetHelper.applyToAlloy(set -> new CrushingRecipeGenerator.CrushingBuilder(Ingredient.of(set.INGOT_TAG), new CrushingRecipe.CrushingResult(new ItemStack((Holder)set.DUST, 1), 1.0f)).save(recipeOutput, this.crushingRecipeDir(String.format("%s/from_dust", set.name))));
        ATOSetHelper.applyToIngot(set -> {
            new CrushingRecipeGenerator.CrushingBuilder(Ingredient.of(set.ORES.ORE_BLOCK_ITEM_TAG), new CrushingRecipe.CrushingResult(new ItemStack((Holder)set.DUST, 2), 1.0f)).addResult2(new CrushingRecipe.CrushingResult(new ItemStack((Holder)set.DUST, 1), 0.5f)).save(recipeOutput, this.crushingRecipeDir(String.format("%s/from_ore", set.name)));
            CrushingRecipeGenerator.CrushingBuilder rawBuilder = new CrushingRecipeGenerator.CrushingBuilder(Ingredient.of(set.RAW_TAG), new CrushingRecipe.CrushingResult(new ItemStack((Holder)set.DUST, 1), 1.0f));
            if (ATORegistry.getByproducts().containsKey(set.RAW.get())) {
                rawBuilder.addResult2(new CrushingRecipe.CrushingResult(new ItemStack((ItemLike)ATORegistry.getByproducts().get((Object)set.RAW.get()).first, 1), ((Float)ATORegistry.getByproducts().get((Object)set.RAW.get()).second).floatValue()));
            }
            rawBuilder.save(recipeOutput, this.crushingRecipeDir(String.format("%s/from_raw", set.name)));
            new CrushingRecipeGenerator.CrushingBuilder(Ingredient.of(set.RAW_BLOCK_ITEM_TAG), new CrushingRecipe.CrushingResult(new ItemStack((Holder)set.DUST, 12), 1.0f)).save(recipeOutput, this.crushingRecipeDir(String.format("%s/from_raw_block", set.name)));
        });
        ATOSetHelper.applyToGem(set -> {
            new CrushingRecipeGenerator.CrushingBuilder(Ingredient.of(set.ORES.ORE_BLOCK_ITEM_TAG), new CrushingRecipe.CrushingResult(new ItemStack(set.GEM, 6), 1.0f)).save(recipeOutput, this.crushingRecipeDir(String.format("%s/from_ore", set.name)));
            new CrushingRecipeGenerator.CrushingBuilder(Ingredient.of(set.GEM_TAG), new CrushingRecipe.CrushingResult(new ItemStack((Holder)set.DUST, 1), 1.0f)).addResult2(new CrushingRecipe.CrushingResult(new ItemStack((Holder)set.DUST, 1), 0.5f)).save(recipeOutput, this.crushingRecipeDir(String.format("%s/from_gem", set.name)));
        });
        ATOSetHelper.applyToVanillaIngot(set -> new CrushingRecipeGenerator.CrushingBuilder(Ingredient.of(set.INGOT_TAG), new CrushingRecipe.CrushingResult(new ItemStack((Holder)set.DUST, 1), 1.0f)).save(recipeOutput, this.crushingRecipeDir(String.format("%s/from_ingot", set.name))));
        ATOSetHelper.applyToVanillaGem(set -> new CrushingRecipeGenerator.CrushingBuilder(Ingredient.of(set.GEM_TAG), new CrushingRecipe.CrushingResult(new ItemStack((Holder)set.DUST, 1), 1.0f)).save(recipeOutput, this.crushingRecipeDir(String.format("%s/from_gem", set.name))));
    }
}

