/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.entity;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PiglichEntity
extends Piglin
implements GeoEntity {
    private final List<RawAnimation.Stage> animationStages = new ArrayList<RawAnimation.Stage>();
    private final SimpleContainer inventory = new SimpleContainer(8);
    private static final RawAnimation ANIMATION = RawAnimation.begin().then("walk.piglich.nik", Animation.LoopType.DEFAULT).then("summon.piglich.nik", Animation.LoopType.DEFAULT).then("meleeattack.piglich.nik", Animation.LoopType.DEFAULT);
    private final AnimatableInstanceCache animationCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Level level;
    private boolean isSummoning = false;

    public PiglichEntity(EntityType<? extends Piglin> type, Level world) {
        super(type, world);
        this.level = world;
        this.createAttributes();
        this.setImmuneToZombification(true);
        this.registerGoals();
    }

    public boolean canAttack(LivingEntity entity) {
        return !(entity instanceof Player) || !((Player)entity).isCreative();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_34717_, DifficultyInstance p_34718_, MobSpawnType p_34719_, @Nullable SpawnGroupData p_34720_) {
        return p_34720_;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 3.0, true));
        this.goalSelector.addGoal(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.goalSelector.addGoal(1, (Goal)new PigLichAttackGoal(this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Skeleton.class, true));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, WitherSkeleton.class, true));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public void setImmuneToZombification(boolean p_34671_) {
        super.setImmuneToZombification(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.21f).add(Attributes.ATTACK_DAMAGE, 12.0).add(Attributes.ARMOR, 24.0).add(Attributes.ARMOR_TOUGHNESS, 24.0).add(Attributes.MAX_HEALTH, 9999.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            state.getController().setAnimation(ANIMATION);
            return PlayState.CONTINUE;
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationCache;
    }

    public boolean hurt(DamageSource source, float damage) {
        if (!super.hurt(source, damage)) {
            return false;
        }
        if (!(this.level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverlevel = (ServerLevel)this.level;
        LivingEntity livingentity = this.getTarget();
        if (livingentity == null && source.getEntity() instanceof LivingEntity) {
            livingentity = (LivingEntity)source.getEntity();
        }
        if (!(livingentity instanceof Player)) {
            return false;
        }
        int i = Mth.floor((double)this.getX());
        int j = Mth.floor((double)this.getY());
        int k = Mth.floor((double)this.getZ());
        return this.spawnSupport(this, i, j, k);
    }

    protected boolean spawnSupport(PiglichEntity piglich, int i, int j, int k) {
        ServerLevel serverlevel = (ServerLevel)piglich.level;
        LivingEntity livingentity = piglich.getTarget();
        int mobType = Mth.nextInt((RandomSource)piglich.random, (int)1, (int)6);
        Monster spawnmob = (Monster)EntityType.PIGLIN_BRUTE.create(piglich.level);
        switch (mobType) {
            case 1: {
                spawnmob = (Monster)EntityType.PIGLIN_BRUTE.create(piglich.level);
            }
            case 2: {
                spawnmob = (Monster)EntityType.BLAZE.create(piglich.level);
            }
            case 3: {
                spawnmob = (Monster)EntityType.ENDERMAN.create(piglich.level);
            }
            case 4: {
                spawnmob = (Monster)EntityType.EVOKER.create(piglich.level);
            }
            case 5: {
                spawnmob = (Monster)EntityType.VINDICATOR.create(piglich.level);
            }
            case 6: {
                spawnmob = (Monster)EntityType.WITCH.create(piglich.level);
            }
        }
        for (int l = 0; l < 5; ++l) {
            int i1 = i + Mth.nextInt((RandomSource)piglich.random, (int)7, (int)40) * Mth.nextInt((RandomSource)piglich.random, (int)-1, (int)1);
            int j1 = j + Mth.nextInt((RandomSource)piglich.random, (int)7, (int)40) * Mth.nextInt((RandomSource)piglich.random, (int)-1, (int)1);
            int k1 = k + Mth.nextInt((RandomSource)piglich.random, (int)7, (int)40) * Mth.nextInt((RandomSource)piglich.random, (int)-1, (int)1);
            BlockPos blockpos = new BlockPos(i1, j1, k1);
            EntityType entitytype = spawnmob.getType();
            SpawnPlacementType spawnplacements$type = SpawnPlacements.getPlacementType((EntityType)entitytype);
            if (!NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)piglich.level, (BlockPos)blockpos, (BlockState)piglich.level().getBlockState(blockpos), (FluidState)piglich.level().getFluidState(blockpos), (EntityType)entitytype) || !SpawnPlacements.checkSpawnRules((EntityType)entitytype, (ServerLevelAccessor)serverlevel, (MobSpawnType)MobSpawnType.REINFORCEMENT, (BlockPos)blockpos, (RandomSource)piglich.level.random)) continue;
            spawnmob.setPos((double)i1, (double)j1, (double)k1);
            if (piglich.level.hasNearbyAlivePlayer((double)i1, (double)j1, (double)k1, 7.0) || !piglich.level.isUnobstructed((Entity)spawnmob) || !piglich.level.noCollision((Entity)spawnmob) || piglich.level.containsAnyLiquid(spawnmob.getBoundingBox())) continue;
            if (livingentity != null) {
                spawnmob.setTarget(livingentity);
            }
            spawnmob.finalizeSpawn((ServerLevelAccessor)serverlevel, piglich.level.getCurrentDifficultyAt(spawnmob.blockPosition()), MobSpawnType.REINFORCEMENT, (SpawnGroupData)null);
            serverlevel.addFreshEntityWithPassengers((Entity)spawnmob);
        }
        this.isSummoning = true;
        return true;
    }

    static class PigLichAttackGoal
    extends Goal {
        private final PiglichEntity piglich;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public PigLichAttackGoal(PiglichEntity p_32247_) {
            this.piglich = p_32247_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
        }

        public boolean canUse() {
            LivingEntity livingentity = this.piglich.getTarget();
            return livingentity != null && livingentity.isAlive() && this.piglich.canAttack(livingentity);
        }

        public void start() {
            this.attackStep = 0;
        }

        public void stop() {
            this.lastSeen = 0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            --this.attackTime;
            LivingEntity livingentity = this.piglich.getTarget();
            if (livingentity != null) {
                boolean flag = this.piglich.getSensing().hasLineOfSight((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.piglich.distanceToSqr((Entity)livingentity);
                if (d0 < 4.0) {
                    if (!flag) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.piglich.doHurtTarget((Entity)livingentity);
                    }
                    this.piglich.getMoveControl().setWantedPosition(livingentity.getX(), livingentity.getY(), livingentity.getZ(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    double d1 = livingentity.getX() - this.piglich.getX();
                    double d2 = livingentity.getY(0.5) - this.piglich.getY(0.5);
                    double d3 = livingentity.getZ() - this.piglich.getZ();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                        } else if (this.attackStep <= 4) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1) {
                            double d4 = Math.sqrt(Math.sqrt(d0)) * 0.5;
                            if (!this.piglich.isSilent()) {
                                this.piglich.level.levelEvent((Player)null, 1018, this.piglich.blockPosition(), 0);
                            }
                        }
                    }
                    this.piglich.getLookControl().setLookAt((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.lastSeen < 5) {
                    this.piglich.getMoveControl().setWantedPosition(livingentity.getX(), livingentity.getY(), livingentity.getZ(), 1.0);
                }
                super.tick();
            }
        }

        private double getFollowDistance() {
            return this.piglich.getAttributeValue(Attributes.FOLLOW_RANGE);
        }
    }
}

