/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.allthemodium.datagen.builder;

import com.thevortex.allthemodium.datagen.RecipeException;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ShapedArmorBuilder {
    private final String criteriaName;
    private final Criterion<InventoryChangeTrigger.TriggerInstance> criterion;
    private final EnumMap<Slot, Item> pieces = new EnumMap(Slot.class);
    private final TagKey<Item> ingot;
    private Item core;

    public ShapedArmorBuilder(TagKey<Item> ingot) {
        this.ingot = ingot;
        this.criteriaName = String.format("has_%s_ingot", ingot);
        ItemPredicate predicate = ItemPredicate.Builder.item().of(ingot).build();
        this.criterion = InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{predicate});
    }

    public static ShapedArmorBuilder builder(TagKey<Item> ingot) {
        return new ShapedArmorBuilder(ingot);
    }

    public ShapedArmorBuilder setHelmet(DeferredHolder<Item, ArmorItem> object) {
        this.pieces.put(Slot.HELMET, (Item)object.get());
        return this;
    }

    public ShapedArmorBuilder setChestplate(DeferredHolder<Item, ArmorItem> object) {
        this.pieces.put(Slot.CHESTPLATE, (Item)object.get());
        return this;
    }

    public ShapedArmorBuilder setLeggings(DeferredHolder<Item, ArmorItem> object) {
        this.pieces.put(Slot.LEGGINGS, (Item)object.get());
        return this;
    }

    public ShapedArmorBuilder setBoots(DeferredHolder<Item, ArmorItem> object) {
        this.pieces.put(Slot.BOOTS, (Item)object.get());
        return this;
    }

    protected void validate(ResourceLocation id) {
        if (this.pieces.isEmpty()) {
            throw new RecipeException(id.toString(), "recipe must have at least 1 output");
        }
    }

    public void build(RecipeOutput consumer) {
        Consumer<ShapedRecipeBuilder> register = builder -> builder.save(consumer);
        Optional.ofNullable(this.pieces.get((Object)Slot.HELMET)).map(this::helmet).map(this::addCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.CHESTPLATE)).map(this::chestplate).map(this::addCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.LEGGINGS)).map(this::leggings).map(this::addCriterion).ifPresent(register);
        Optional.ofNullable(this.pieces.get((Object)Slot.BOOTS)).map(this::boots).map(this::addCriterion).ifPresent(register);
    }

    private ShapedRecipeBuilder shaped(ItemLike provider) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)provider).group("allthemodium");
    }

    private ShapedRecipeBuilder addCriterion(ShapedRecipeBuilder builder) {
        return builder.define(Character.valueOf('a'), this.ingot).unlockedBy(this.criteriaName, this.criterion);
    }

    private ShapedRecipeBuilder helmet(ItemLike provider) {
        return this.shaped(provider).pattern("aaa").pattern("a a").pattern("   ");
    }

    private ShapedRecipeBuilder chestplate(ItemLike provider) {
        return this.shaped(provider).pattern("a a").pattern("aaa").pattern("aaa");
    }

    private ShapedRecipeBuilder leggings(ItemLike provider) {
        return this.shaped(provider).pattern("aaa").pattern("a a").pattern("a a");
    }

    private ShapedRecipeBuilder boots(ItemLike provider) {
        return this.shaped(provider).pattern("a a").pattern("a a").pattern("   ");
    }

    public static enum Slot {
        HELMET,
        CHESTPLATE,
        LEGGINGS,
        BOOTS;


        public String lower() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

