/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.mixin.core.main;

import java.lang.ref.WeakReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.loading.math.MathParser;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.util.RenderUtil;

@Mixin(value={GeoModel.class})
public class GeoModelMixin {
    @Overwrite(remap=false)
    public <T extends GeoAnimatable> void applyMolangQueries(AnimationState<T> animationState, double animTime) {
        Minecraft mc = Minecraft.getInstance();
        GeoAnimatable animatable = animationState.getAnimatable();
        if (mc.level == null) {
            return;
        }
        WeakReference<ClientLevel> level = new WeakReference<ClientLevel>(mc.level);
        MathParser.setVariable((String)"query.life_time", () -> animTime / 20.0);
        MathParser.setVariable((String)"query.actor_count", () -> ((ClientLevel)level.get()).getEntityCount());
        MathParser.setVariable((String)"query.time_of_day", () -> (float)((ClientLevel)level.get()).getDayTime() / 24000.0f);
        MathParser.setVariable((String)"query.moon_phase", () -> ((ClientLevel)level.get()).getMoonPhase());
        if (animatable instanceof Entity) {
            Entity entity = (Entity)animatable;
            WeakReference<Entity> weakEntity = new WeakReference<Entity>(entity);
            MathParser.setVariable((String)"query.distance_from_camera", () -> mc.gameRenderer.getMainCamera().getPosition().distanceTo(((Entity)weakEntity.get()).position()));
            MathParser.setVariable((String)"query.is_on_ground", () -> RenderUtil.booleanToFloat((boolean)((Entity)weakEntity.get()).onGround()));
            MathParser.setVariable((String)"query.is_in_water", () -> RenderUtil.booleanToFloat((boolean)((Entity)weakEntity.get()).isInWater()));
            MathParser.setVariable((String)"query.is_in_water_or_rain", () -> RenderUtil.booleanToFloat((boolean)((Entity)weakEntity.get()).isInWaterRainOrBubble()));
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                WeakReference<LivingEntity> weakLivingEntity = new WeakReference<LivingEntity>(livingEntity);
                MathParser.setVariable((String)"query.health", () -> ((LivingEntity)weakLivingEntity.get()).getHealth());
                MathParser.setVariable((String)"query.max_health", () -> ((LivingEntity)weakLivingEntity.get()).getMaxHealth());
                MathParser.setVariable((String)"query.is_on_fire", () -> RenderUtil.booleanToFloat((boolean)((LivingEntity)weakLivingEntity.get()).isOnFire()));
                MathParser.setVariable((String)"query.ground_speed", () -> {
                    Vec3 velocity = ((LivingEntity)weakLivingEntity.get()).getDeltaMovement();
                    return Mth.sqrt((float)((float)(velocity.x * velocity.x + velocity.z * velocity.z)));
                });
                MathParser.setVariable((String)"query.yaw_speed", () -> ((LivingEntity)weakLivingEntity.get()).getViewYRot((float)animTime - ((LivingEntity)weakLivingEntity.get()).getViewYRot((float)animTime - 0.1f)));
            }
        }
    }
}

