/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.uncandango.alltheleaks.AllTheLeaks;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.util.GsonHelper;
import net.neoforged.fml.loading.FMLPaths;

public class ATLProperties {
    private static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();
    private static final Path path = FMLPaths.CONFIGDIR.get().resolve("alltheleaks.json");
    private static final JsonElement defaultProperties = ATLProperties.getDefaultProperties();
    private static ATLProperties INSTANCE;
    public boolean ingredientDedupe;
    public boolean entitySectionCME;
    public boolean scoreboardDebug;
    public boolean debugItemStackModifications;
    public boolean debugNativeImage;
    public boolean disableSearchTree;
    public int version;
    private JsonObject properties;

    private ATLProperties() {
        this.load();
    }

    public void load() {
        if (!path.toFile().exists()) {
            ATLProperties.save();
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            this.properties = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            this.version = GsonHelper.getAsInt((JsonObject)this.properties, (String)"version", (int)0);
            this.ingredientDedupe = this.version == 0 ? false : GsonHelper.getAsBoolean((JsonObject)this.properties, (String)"ingredientDedupe", (boolean)false);
            this.scoreboardDebug = GsonHelper.getAsBoolean((JsonObject)this.properties, (String)"scoreboardDebug", (boolean)false);
            this.entitySectionCME = GsonHelper.getAsBoolean((JsonObject)this.properties, (String)"entitySectionCME", (boolean)false);
            this.debugItemStackModifications = GsonHelper.getAsBoolean((JsonObject)this.properties, (String)"debugItemStackModifications", (boolean)false);
            this.debugNativeImage = GsonHelper.getAsBoolean((JsonObject)this.properties, (String)"debugNativeImage", (boolean)false);
            this.disableSearchTree = GsonHelper.getAsBoolean((JsonObject)this.properties, (String)"disableSearchTree", (boolean)false);
        }
        catch (IOException e) {
            AllTheLeaks.LOGGER.error("Failed to load config file", (Throwable)e);
            this.properties = new JsonObject();
        }
    }

    public static void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            GSON.toJson(defaultProperties, (Appendable)writer);
        }
        catch (IOException e) {
            AllTheLeaks.LOGGER.error("Failed to save config file", (Throwable)e);
        }
    }

    public static ATLProperties get() {
        if (INSTANCE == null) {
            INSTANCE = new ATLProperties();
        }
        return INSTANCE;
    }

    private static JsonElement getDefaultProperties() {
        JsonObject properties = new JsonObject();
        properties.addProperty("ingredientDedupe", Boolean.valueOf(false));
        properties.addProperty("entitySectionCME", Boolean.valueOf(false));
        properties.addProperty("scoreboardDebug", Boolean.valueOf(false));
        properties.addProperty("debugItemStackModifications", Boolean.valueOf(false));
        properties.addProperty("version", (Number)1);
        properties.addProperty("debugNativeImage", Boolean.valueOf(false));
        properties.addProperty("disableSearchTree", Boolean.valueOf(false));
        return properties;
    }
}

