/*
 * Decompiled with CFR 0.152.
 */
package com.Pdiddy973.AllTheCompressed.overlay;

import com.Pdiddy973.AllTheCompressed.ModRegistry;
import com.Pdiddy973.AllTheCompressed.overlay.OverlayBlock;
import com.Pdiddy973.AllTheCompressed.overlay.OverlayPillarBlock;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public class OverlayEntry {
    public final ResourceLocation parent;
    public final DeferredBlock<Block> x1;
    public final DeferredBlock<Block> x2;
    public final DeferredBlock<Block> x3;
    public final DeferredBlock<Block> x4;
    public final DeferredBlock<Block> x5;
    public final DeferredBlock<Block> x6;
    public final DeferredBlock<Block> x7;
    public final DeferredBlock<Block> x8;
    public final DeferredBlock<Block> x9;
    public final List<DeferredBlock<Block>> xall;
    public final DeferredItem<BlockItem> i1;
    public final DeferredItem<BlockItem> i2;
    public final DeferredItem<BlockItem> i3;
    public final DeferredItem<BlockItem> i4;
    public final DeferredItem<BlockItem> i5;
    public final DeferredItem<BlockItem> i6;
    public final DeferredItem<BlockItem> i7;
    public final DeferredItem<BlockItem> i8;
    public final DeferredItem<BlockItem> i9;
    public final List<DeferredItem<BlockItem>> iall;
    private boolean blockLoaded = false;
    private static final BlockBehaviour.Properties defaultProperties = BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(1.0f);

    public boolean isBlockLoaded() {
        return this.blockLoaded;
    }

    public OverlayEntry(ResourceLocation parent, @Nullable String registryOverride) {
        this.parent = parent;
        String path = registryOverride == null ? parent.getPath() : registryOverride;
        Supplier<BlockBehaviour.Properties> properties = this.getProperties(parent);
        this.x1 = this.block(path, properties, 1);
        this.x2 = this.block(path, properties, 2);
        this.x3 = this.block(path, properties, 3);
        this.x4 = this.block(path, properties, 4);
        this.x5 = this.block(path, properties, 5);
        this.x6 = this.block(path, properties, 6);
        this.x7 = this.block(path, properties, 7);
        this.x8 = this.block(path, properties, 8);
        this.x9 = this.block(path, properties, 9);
        this.xall = List.of(this.x1, this.x2, this.x3, this.x4, this.x5, this.x6, this.x7, this.x8, this.x9);
        this.i1 = OverlayEntry.blockItem(this.x1);
        this.i2 = OverlayEntry.blockItem(this.x2);
        this.i3 = OverlayEntry.blockItem(this.x3);
        this.i4 = OverlayEntry.blockItem(this.x4);
        this.i5 = OverlayEntry.blockItem(this.x5);
        this.i6 = OverlayEntry.blockItem(this.x6);
        this.i7 = OverlayEntry.blockItem(this.x7);
        this.i8 = OverlayEntry.blockItem(this.x8);
        this.i9 = OverlayEntry.blockItem(this.x9);
        this.iall = List.of(this.i1, this.i2, this.i3, this.i4, this.i5, this.i6, this.i7, this.i8, this.i9);
    }

    private Supplier<BlockBehaviour.Properties> getProperties(ResourceLocation parent) {
        return Suppliers.memoize(() -> {
            Optional block;
            BlockBehaviour.Properties properties = defaultProperties;
            if (ModList.get().isLoaded(parent.getNamespace()) && (block = BuiltInRegistries.BLOCK.getOptional(parent)).isPresent()) {
                this.blockLoaded = true;
                properties = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)block.get()));
            }
            return properties;
        });
    }

    private static DeferredItem<BlockItem> blockItem(DeferredBlock<Block> block) {
        return ModRegistry.OVERLAY_ITEMS.register(block.getKey().location().getPath(), () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private DeferredBlock<Block> block(String path, Supplier<BlockBehaviour.Properties> properties, int level) {
        Supplier<Block> supplier = () -> this.isPillar() ? new OverlayPillarBlock((BlockBehaviour.Properties)properties.get(), level) : new OverlayBlock((BlockBehaviour.Properties)properties.get(), level);
        return ModRegistry.OVERLAY_BLOCKS.register(OverlayEntry.generateName(path, level), supplier);
    }

    private boolean isPillar() {
        Optional block;
        if (ModList.get().isLoaded(this.parent.getNamespace()) && (block = BuiltInRegistries.BLOCK.getOptional(this.parent)).isPresent()) {
            return block.get() instanceof RotatedPillarBlock;
        }
        return false;
    }

    private static String generateName(String path, int level) {
        return String.format(Locale.ROOT, "%s_%dx", path, level);
    }
}

