/*
 * Decompiled with CFR 0.152.
 */
package com.Pdiddy973.AllTheCompressed.data;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class LanguageUtil {
    private final Map<String, Language> languageMap = new HashMap<String, Language>();
    private final Map<String, String> translations = new HashMap<String, String>();
    private final ExistingFileHelper fileHelper;

    public LanguageUtil(ExistingFileHelper fileHelper) {
        this.fileHelper = fileHelper;
        this.languageMap.put("minecraft", Language.getInstance());
        this.languageMap.put("allthecompressed", this.loadLanguage(this.translations));
    }

    public void put(String key, String value) {
        this.translations.put(key, value);
    }

    public String getParentName(ResourceLocation parent) {
        String translationKey = String.format("block.%s.%s", parent.getNamespace(), parent.getPath());
        return this.getLanguage(parent.getNamespace()).getOrDefault(translationKey);
    }

    private Language getLanguage(String mod) {
        if (!ModList.get().isLoaded(mod)) {
            throw new IllegalArgumentException("Mod is not loaded: " + mod);
        }
        return this.languageMap.computeIfAbsent(mod, this::loadLanguage);
    }

    private Language loadLanguage(String mod) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String langFile = String.format("/assets/%s/lang/en_us.json", mod);
        try {
            Resource resource = this.fileHelper.getResource(ResourceLocation.fromNamespaceAndPath((String)mod, (String)"lang/en_us.json"), PackType.CLIENT_RESOURCES);
            InputStream is = resource.open();
            Language.loadFromJson((InputStream)is, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to load file: %s", langFile), e);
        }
        HashMap<String, String> map = new HashMap<String, String>((Map<String, String>)builder.build());
        return this.loadLanguage(map);
    }

    private Language loadLanguage(final Map<String, String> map) {
        return new Language(this){

            public String getOrDefault(String key, String fallback) {
                return map.getOrDefault(key, fallback);
            }

            public boolean has(String key) {
                return map.containsKey(key);
            }

            public boolean isDefaultRightToLeft() {
                return false;
            }

            public FormattedCharSequence getVisualOrder(FormattedText formattedText) {
                return sink -> formattedText.visit((style, text) -> StringDecomposer.iterateFormatted((String)text, (Style)style, (FormattedCharSink)sink) ? Optional.empty() : FormattedText.STOP_ITERATION, Style.EMPTY).isPresent();
            }

            public Map<String, String> getLanguageData() {
                return map;
            }
        };
    }
}

