/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.allthearcanistgear.setup.config;

import com.github.jarva.allthearcanistgear.AllTheArcanistGear;
import com.github.jarva.allthearcanistgear.common.items.armor.AddonArmorItem;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.neoforge.common.ModConfigSpec;

public record ArmorSetConfig(String name, ModConfigSpec.IntValue head, ModConfigSpec.IntValue chest, ModConfigSpec.IntValue legs, ModConfigSpec.IntValue boots, ModConfigSpec.IntValue toughness, ModConfigSpec.DoubleValue knockback, ModConfigSpec.IntValue maxMana, ModConfigSpec.DoubleValue manaRegen, ModConfigSpec.DoubleValue spellPower, ModConfigSpec.BooleanValue preventDrowning, ModConfigSpec.BooleanValue preventKinetic, ModConfigSpec.BooleanValue preventFire, ModConfigSpec.BooleanValue preventDragonsBreath, ModConfigSpec.BooleanValue preventWither, ModConfigSpec.BooleanValue preventLevitation, ModConfigSpec.BooleanValue preventFallDamage, ModConfigSpec.IntValue bonusGlyphs, ModConfigSpec.DoubleValue bonusDamageMultiplier) {
    public int getDefenseBySlot(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> (Integer)this.head().get();
            case EquipmentSlot.CHEST -> (Integer)this.chest().get();
            case EquipmentSlot.LEGS -> (Integer)this.legs().get();
            case EquipmentSlot.FEET -> (Integer)this.boots().get();
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(slot));
        };
    }

    public ItemAttributeModifiers buildAttributeMap(AddonArmorItem item) {
        EquipmentSlot slot = item.getEquipmentSlot();
        int defense = this.getDefenseBySlot(slot);
        int toughness = (Integer)this.toughness().get();
        double knockback = (Double)this.knockback().get();
        double maxMana = ((Integer)this.maxMana().get()).intValue();
        double manaRegen = (Double)this.manaRegen().get();
        double spellPower = (Double)this.spellPower().get();
        ResourceLocation modifier = AllTheArcanistGear.prefix("armor." + this.name() + "." + slot.getName());
        EquipmentSlotGroup group = EquipmentSlotGroup.bySlot((EquipmentSlot)slot);
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        if (defense != 0) {
            builder.add(Attributes.ARMOR, new AttributeModifier(modifier, (double)defense, AttributeModifier.Operation.ADD_VALUE), group);
        }
        if (toughness != 0) {
            builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(modifier, (double)toughness, AttributeModifier.Operation.ADD_VALUE), group);
        }
        if (knockback != 0.0) {
            builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(modifier, knockback, AttributeModifier.Operation.ADD_VALUE), group);
        }
        if (maxMana != 0.0) {
            builder.add((Holder)PerkAttributes.MAX_MANA, new AttributeModifier(modifier, maxMana, AttributeModifier.Operation.ADD_VALUE), group);
        }
        if (manaRegen != 0.0) {
            builder.add((Holder)PerkAttributes.MANA_REGEN_BONUS, new AttributeModifier(modifier, manaRegen, AttributeModifier.Operation.ADD_VALUE), group);
        }
        if (spellPower != 0.0) {
            builder.add((Holder)PerkAttributes.SPELL_DAMAGE_BONUS, new AttributeModifier(modifier, spellPower, AttributeModifier.Operation.ADD_VALUE), group);
        }
        return builder.build();
    }

    public static ArmorSetConfig build(ModConfigSpec.Builder builder, String name, DefenseValues values, ArcanistStats stats, Capabilities capabilities, BookStats book) {
        String localizedName = name.substring(0, 1).toUpperCase() + name.substring(1);
        builder.push(name);
        builder.define("_comment", (Object)("Config for " + localizedName + " armor"));
        builder.push("armor_values");
        ModConfigSpec.IntValue head = builder.worldRestart().comment("Hat").defineInRange("hat", values.head(), 0, Integer.MAX_VALUE);
        ModConfigSpec.IntValue chest = builder.worldRestart().comment("Robes").defineInRange("robes", values.chest(), 0, Integer.MAX_VALUE);
        ModConfigSpec.IntValue legs = builder.worldRestart().comment("Leggings").defineInRange("leggings", values.legs(), 0, Integer.MAX_VALUE);
        ModConfigSpec.IntValue boots = builder.worldRestart().comment("Boots").defineInRange("boots", values.boots(), 0, Integer.MAX_VALUE);
        ModConfigSpec.IntValue toughness = builder.worldRestart().comment("Toughness").defineInRange("toughness", values.toughness(), 0, Integer.MAX_VALUE);
        ModConfigSpec.DoubleValue knockback = builder.worldRestart().comment("Knockback Resistance").defineInRange("knockback_resistance", values.knockbackResistance(), 0.0, 2.147483647E9);
        builder.pop();
        builder.push("arcanist_stats");
        ModConfigSpec.IntValue manaBoost = builder.worldRestart().comment("Max Mana Bonus").defineInRange("mana_boost", stats.manaBoost(), 0, Integer.MAX_VALUE);
        ModConfigSpec.DoubleValue manaRegen = builder.worldRestart().comment("Mana Regen Bonus").defineInRange("mana_regen", stats.manaRegen(), 0.0, 2.147483647E9);
        ModConfigSpec.DoubleValue spellPower = builder.worldRestart().comment("Spell Power Bonus").defineInRange("spell_power", stats.spellPower(), 0.0, 2.147483647E9);
        builder.pop();
        builder.push("capabilities");
        ModConfigSpec.BooleanValue preventDrowning = builder.worldRestart().comment("Should Helmet Prevent Drowning?").define("prevent_drowning", capabilities.preventDrowning());
        ModConfigSpec.BooleanValue preventKinetic = builder.worldRestart().comment("Should Helmet Prevent Kinetic Damage?").define("prevent_kinetic", capabilities.preventKinetic());
        ModConfigSpec.BooleanValue preventFire = builder.worldRestart().comment("Should Chestplate Prevent Fire Damage?").define("prevent_fire", capabilities.preventFire());
        ModConfigSpec.BooleanValue preventDragonsBreath = builder.worldRestart().comment("Should Chestplate Prevent Dragon's Breath Damage?").define("prevent_dragons_breath", capabilities.preventDragonsBreath());
        ModConfigSpec.BooleanValue preventWither = builder.worldRestart().comment("Should Leggings Prevent Wither?").define("prevent_wither", capabilities.preventWither());
        ModConfigSpec.BooleanValue preventLevitation = builder.worldRestart().comment("Should Leggings Prevent Levitation?").define("prevent_levitation", capabilities.preventLevitation());
        ModConfigSpec.BooleanValue preventFallDamage = builder.worldRestart().comment("Should Boots Prevent Fall Damage?").define("prevent_fall_damage", capabilities.preventFallDamage());
        builder.pop();
        builder.push("spell_book");
        ModConfigSpec.IntValue bonusGlyphs = builder.worldRestart().comment("How many bonus glyph slots should the spell book provide?").defineInRange("bonus_glyphs", book.bonusGlyphs(), 0, 990);
        ModConfigSpec.DoubleValue bonusDamageMultiplier = builder.worldRestart().comment("What damage multiplier should be applied when `allthearcanistgear:bonus_damage` entities are hurt?").defineInRange("bonus_damage_multiplier", (double)book.bonusDamageMultiplier(), 1.0, 10.0);
        builder.pop();
        ArmorSetConfig config = new ArmorSetConfig(name, head, chest, legs, boots, toughness, knockback, manaBoost, manaRegen, spellPower, preventDrowning, preventKinetic, preventFire, preventDragonsBreath, preventWither, preventLevitation, preventFallDamage, bonusGlyphs, bonusDamageMultiplier);
        builder.pop();
        return config;
    }

    public record DefenseValues(int head, int chest, int legs, int boots, int toughness, double knockbackResistance) {
    }

    public record ArcanistStats(int manaBoost, double manaRegen, double spellPower) {
    }

    public record Capabilities(boolean preventDrowning, boolean preventKinetic, boolean preventFire, boolean preventDragonsBreath, boolean preventWither, boolean preventLevitation, boolean preventFallDamage) {
    }

    public record BookStats(int bonusGlyphs, float bonusDamageMultiplier) {
    }
}

