/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.allthearcanistgear.datagen;

import alexthw.ars_elemental.common.items.armor.ArmorSet;
import alexthw.ars_elemental.registry.ModItems;
import com.github.jarva.allthearcanistgear.AllTheArcanistGear;
import com.github.jarva.allthearcanistgear.common.items.armor.ArcanistArmorSet;
import com.github.jarva.allthearcanistgear.setup.registry.AddonItemRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.thevortex.allthemodium.registry.ModRegistry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemTagDatagen
extends IntrinsicHolderTagsProvider<Item> {
    public static final TagKey<Item> BASE_HAT = ItemTags.create((ResourceLocation)AllTheArcanistGear.prefix("base_hat"));
    public static final TagKey<Item> BASE_CHEST = ItemTags.create((ResourceLocation)AllTheArcanistGear.prefix("base_chest"));
    public static final TagKey<Item> BASE_LEGS = ItemTags.create((ResourceLocation)AllTheArcanistGear.prefix("base_legs"));
    public static final TagKey<Item> BASE_BOOTS = ItemTags.create((ResourceLocation)AllTheArcanistGear.prefix("base_boots"));
    public static final TagKey<Item> ELEMENTAL_HAT = ItemTags.create((ResourceLocation)AllTheArcanistGear.prefix("elemental_hat"));
    public static final TagKey<Item> ELEMENTAL_CHEST = ItemTags.create((ResourceLocation)AllTheArcanistGear.prefix("elemental_chest"));
    public static final TagKey<Item> ELEMENTAL_LEGS = ItemTags.create((ResourceLocation)AllTheArcanistGear.prefix("elemental_legs"));
    public static final TagKey<Item> ELEMENTAL_BOOTS = ItemTags.create((ResourceLocation)AllTheArcanistGear.prefix("elemental_boots"));
    public static final TagKey<Item> ALLTHEMODIUM_INGOT = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/allthemodium"));
    public static final TagKey<Item> VIBRANIUM_INGOT = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/vibranium"));
    public static final TagKey<Item> UNOBTAINIUM_INGOT = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/unobtainium"));
    public static final TagKey<Item> ALLTHEMODIUM_SMITHING_TEMPLATE = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"allthearcanistgear", (String)"allthemodium_smithing"));
    public static final TagKey<Item> VIBRANIUM_SMITHING_TEMPLATE = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"allthearcanistgear", (String)"vibranium_smithing"));
    public static final TagKey<Item> UNOBTAINIUM_SMITHING_TEMPLATE = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"allthearcanistgear", (String)"unobtainium_smithing"));

    public ItemTagDatagen(PackOutput arg, CompletableFuture<HolderLookup.Provider> future, ExistingFileHelper helper) {
        super(arg, Registries.ITEM, future, item -> item.builtInRegistryHolder().key(), "allthearcanistgear", helper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        ArmorSet[] armorSets = new ArmorSet[]{ModItems.AIR_ARMOR, ModItems.EARTH_ARMOR, ModItems.FIRE_ARMOR, ModItems.WATER_ARMOR};
        IntrinsicHolderTagsProvider.IntrinsicTagAppender elementalHats = this.tag(ELEMENTAL_HAT);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender elementalChest = this.tag(ELEMENTAL_CHEST);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender elementalLegs = this.tag(ELEMENTAL_LEGS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender elementBoots = this.tag(ELEMENTAL_BOOTS);
        for (ArmorSet armorSet : armorSets) {
            elementalHats.addOptional(this.key(armorSet.getHat()));
            elementalChest.addOptional(this.key(armorSet.getChest()));
            elementalLegs.addOptional(this.key(armorSet.getLegs()));
            elementBoots.addOptional(this.key(armorSet.getBoots()));
        }
        this.tag(BASE_HAT).add((Object)((Item)ItemsRegistry.ARCANIST_HOOD.get())).add((Object)((Item)ItemsRegistry.SORCERER_HOOD.get())).add((Object)((Item)ItemsRegistry.BATTLEMAGE_HOOD.get())).addOptionalTag(ELEMENTAL_HAT);
        this.tag(BASE_CHEST).add((Object)((Item)ItemsRegistry.ARCANIST_ROBES.get())).add((Object)((Item)ItemsRegistry.SORCERER_ROBES.get())).add((Object)((Item)ItemsRegistry.BATTLEMAGE_ROBES.get())).addOptionalTag(ELEMENTAL_CHEST);
        this.tag(BASE_LEGS).add((Object)((Item)ItemsRegistry.ARCANIST_LEGGINGS.get())).add((Object)((Item)ItemsRegistry.SORCERER_LEGGINGS.get())).add((Object)((Item)ItemsRegistry.BATTLEMAGE_LEGGINGS.get())).addOptionalTag(ELEMENTAL_LEGS);
        this.tag(BASE_BOOTS).add((Object)((Item)ItemsRegistry.ARCANIST_BOOTS.get())).add((Object)((Item)ItemsRegistry.SORCERER_BOOTS.get())).add((Object)((Item)ItemsRegistry.BATTLEMAGE_BOOTS.get())).addOptionalTag(ELEMENTAL_BOOTS);
        this.tag(ALLTHEMODIUM_SMITHING_TEMPLATE).addOptional(this.key((Item)ModRegistry.ATM_SMITHING.get()));
        this.tag(VIBRANIUM_SMITHING_TEMPLATE).addOptional(this.key((Item)ModRegistry.VIB_SMITHING.get()));
        this.tag(UNOBTAINIUM_SMITHING_TEMPLATE).addOptional(this.key((Item)ModRegistry.UNO_SMITHING.get()));
        for (ArcanistArmorSet arcanistArmorSet : AddonItemRegistry.ARMOR_SETS) {
            this.addArmorTags(arcanistArmorSet);
        }
    }

    public void addArmorTags(ArcanistArmorSet set) {
        this.tag(ItemTags.ARMOR_ENCHANTABLE).add((Object[])new Item[]{set.getHat(), set.getChest(), set.getLegs(), set.getBoots()});
        this.tag(ItemTags.EQUIPPABLE_ENCHANTABLE).add((Object[])new Item[]{set.getHat(), set.getChest(), set.getLegs(), set.getBoots()});
        this.tag(ItemTags.DURABILITY_ENCHANTABLE).add((Object[])new Item[]{set.getHat(), set.getChest(), set.getLegs(), set.getBoots()});
        this.tag(ItemTags.HEAD_ARMOR_ENCHANTABLE).add((Object)set.getHat());
        this.tag(ItemTags.HEAD_ARMOR).add((Object)set.getHat());
        this.tag(ItemTags.CHEST_ARMOR_ENCHANTABLE).add((Object)set.getChest());
        this.tag(ItemTags.CHEST_ARMOR).add((Object)set.getChest());
        this.tag(ItemTags.LEG_ARMOR_ENCHANTABLE).add((Object)set.getLegs());
        this.tag(ItemTags.LEG_ARMOR).add((Object)set.getLegs());
        this.tag(ItemTags.FOOT_ARMOR_ENCHANTABLE).add((Object)set.getBoots());
        this.tag(ItemTags.FOOT_ARMOR).add((Object)set.getBoots());
    }

    public ResourceLocation key(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }
}

