/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structurepiece.bronzedungeon;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.world.BlockLogicUtil;
import com.aetherteam.aether.world.structurepiece.bronzedungeon.BronzeBossRoom;
import com.aetherteam.aether.world.structurepiece.bronzedungeon.BronzeDungeonPiece;
import com.aetherteam.aether.world.structurepiece.bronzedungeon.BronzeDungeonRoom;
import com.aetherteam.aether.world.structurepiece.bronzedungeon.BronzeDungeonSurfaceRuins;
import com.aetherteam.aether.world.structurepiece.bronzedungeon.BronzeProcessorSettings;
import com.aetherteam.aether.world.structurepiece.bronzedungeon.BronzeTunnel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class BronzeDungeonBuilder {
    public static final Map<String, SimpleWeightedRandomList.Builder<RoomProvider<?>>> ROOM_OPTIONS_BUILDER = Map.ofEntries(Map.entry("boss_room", new SimpleWeightedRandomList.Builder()), Map.entry("chest_room", new SimpleWeightedRandomList.Builder()), Map.entry("end_corridor", new SimpleWeightedRandomList.Builder()), Map.entry("entrance", new SimpleWeightedRandomList.Builder()), Map.entry("lobby", new SimpleWeightedRandomList.Builder()), Map.entry("square_tunnel", new SimpleWeightedRandomList.Builder()));
    private static Map<String, SimpleWeightedRandomList<RoomProvider<?>>> ROOM_OPTIONS;
    private final Structure.GenerationContext context;
    private final StructureTemplateManager manager;
    private final RandomSource random;
    private final BronzeProcessorSettings processors;
    private final int nodeWidth;
    private final int edgeWidth;
    private final int edgeLength;
    private final int maxSize;
    private final List<StructurePiece> nodes = new ArrayList<StructurePiece>();
    private final Map<StructurePiece, Map<Direction, Connection>> edges = new HashMap<StructurePiece, Map<Direction, Connection>>();

    public BronzeDungeonBuilder(Structure.GenerationContext context, int maxSize, BronzeProcessorSettings processors) {
        this.context = context;
        this.manager = context.structureTemplateManager();
        this.random = context.random();
        this.processors = processors;
        Vec3i nodeSize = context.structureTemplateManager().getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"bronze_dungeon/chest_room")).getSize();
        this.nodeWidth = nodeSize.getX();
        Vec3i edgeSize = context.structureTemplateManager().getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"bronze_dungeon/square_tunnel")).getSize();
        this.edgeWidth = edgeSize.getX();
        this.edgeLength = edgeSize.getZ();
        this.maxSize = Math.max(3, maxSize);
    }

    public void initializeDungeon(BlockPos startPos, Structure.GenerationContext genContext, StructurePiecesBuilder builder) {
        ROOM_OPTIONS = ROOM_OPTIONS_BUILDER.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SimpleWeightedRandomList.Builder)e.getValue()).build()));
        StructureTemplate bossTemplate = this.context.structureTemplateManager().getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"bronze_dungeon/boss_room"));
        Rotation rotation = this.getBossRoomRotation(startPos, startPos.offset(bossTemplate.getSize()));
        if (rotation == null) {
            return;
        }
        BronzeDungeonPiece bossRoom = this.chooseRoom("boss_room", startPos, rotation, this.processors.bossSettings());
        Direction direction = bossRoom.getOrientation();
        if (direction != null) {
            BlockPos pos = BlockLogicUtil.tunnelFromEvenSquareRoom(bossRoom.getBoundingBox().moved(0, 2, 0), direction, this.edgeWidth);
            BronzeDungeonPiece hallway = this.chooseRoom("square_tunnel", pos, bossRoom.getRotation(), this.processors.roomSettings());
            pos = BlockLogicUtil.tunnelFromEvenSquareRoom(hallway.getBoundingBox(), direction, this.nodeWidth);
            BronzeDungeonPiece defaultRoom = this.chooseRoom("chest_room", pos, hallway.getRotation(), this.processors.roomSettings());
            this.nodes.add((StructurePiece)bossRoom);
            this.nodes.add((StructurePiece)defaultRoom);
            new Connection(this, (StructurePiece)bossRoom, (StructurePiece)defaultRoom, (StructurePiece)hallway, direction);
            ChunkPos chunkPos = genContext.chunkPos();
            for (int i = 2; i < this.maxSize - 1; ++i) {
                this.propagateRooms((StructurePiece)defaultRoom, chunkPos, false);
            }
            this.propagateRooms((StructurePiece)defaultRoom, chunkPos, true);
            StructurePiece lobby = this.nodes.getLast();
            this.buildEndTunnel(lobby, startPos);
            this.buildSurfaceTunnel(genContext.heightAccessor(), genContext.chunkGenerator(), genContext.randomState());
            this.populatePiecesBuilder(builder);
        }
    }

    private boolean propagateRooms(StructurePiece currentNode, ChunkPos chunkPos, boolean placeLobby) {
        Rotation rotation = currentNode.getRotation();
        ArrayList<Rotation> rotations = new ArrayList<Rotation>(3);
        rotations.add(rotation.getRotated(Rotation.COUNTERCLOCKWISE_90));
        rotations.add(rotation);
        rotations.add(rotation.getRotated(Rotation.CLOCKWISE_90));
        String roomName = placeLobby ? "lobby" : "chest_room";
        for (int i = 3; i > 0; --i) {
            boolean flag;
            rotation = (Rotation)rotations.remove(this.random.nextInt(i));
            Direction direction = rotation.rotate(Direction.SOUTH);
            if (this.hasConnection(currentNode, direction)) {
                if (!this.propagateRooms(this.edges.get((Object)currentNode).get((Object)direction).end, chunkPos, placeLobby)) continue;
                return true;
            }
            BlockPos pos = BlockLogicUtil.tunnelFromEvenSquareRoom(currentNode.getBoundingBox(), direction, this.edgeWidth);
            BronzeDungeonPiece hallway = this.chooseRoom("square_tunnel", pos, rotation, this.processors.roomSettings());
            pos = BlockLogicUtil.tunnelFromEvenSquareRoom(hallway.getBoundingBox(), direction, this.nodeWidth);
            BronzeDungeonPiece room = this.chooseRoom(roomName, pos, rotation, this.processors.roomSettings());
            StructurePiece collisionPiece = StructurePiece.findCollisionPiece(this.nodes, (BoundingBox)room.getBoundingBox());
            if (!this.isCloseToCenter(chunkPos, room.templatePosition()) || !this.isCoveredAtPos(room.getBoundingBox())) continue;
            if (collisionPiece == null) {
                new Connection(this, currentNode, (StructurePiece)room, (StructurePiece)hallway, direction);
                this.nodes.add((StructurePiece)room);
                return true;
            }
            if (collisionPiece instanceof BronzeBossRoom || (flag = this.edges.computeIfAbsent(collisionPiece, piece -> new HashMap()).values().stream().map(Connection::endPiece).anyMatch(piece -> piece == currentNode))) continue;
            new Connection(this, currentNode, (StructurePiece)room, (StructurePiece)hallway, direction);
        }
        return false;
    }

    private void buildEndTunnel(StructurePiece lobby, BlockPos origin) {
        Rotation rotation = lobby.getRotation();
        ArrayList<Rotation> rotations = new ArrayList<Rotation>(3);
        rotations.add(rotation.getRotated(Rotation.COUNTERCLOCKWISE_90));
        rotations.add(rotation);
        rotations.add(rotation.getRotated(Rotation.CLOCKWISE_90));
        ArrayList<StructurePiece> longestTunnel = null;
        for (int i = 3; i > 0; --i) {
            Direction direction;
            ArrayList<StructurePiece> tunnel = new ArrayList<StructurePiece>();
            rotation = (Rotation)rotations.remove(this.random.nextInt(i));
            if (this.buildTunnelFromRoom(lobby, tunnel, rotation, direction = rotation.rotate(Direction.SOUTH), origin)) {
                longestTunnel = tunnel;
                break;
            }
            if (longestTunnel != null && tunnel.size() <= longestTunnel.size()) continue;
            longestTunnel = tunnel;
        }
        this.nodes.addAll(longestTunnel);
    }

    @Nullable
    private StructurePiece seekLastRoomNode(int minWidth) {
        for (int i = this.nodes.size() - 1; i >= 0; --i) {
            StructurePiece piece = this.nodes.get(i);
            BoundingBox box = piece.getBoundingBox();
            if (box.getXSpan() <= minWidth || box.getZSpan() <= minWidth) continue;
            return piece;
        }
        return null;
    }

    private void buildSurfaceTunnel(LevelHeightAccessor level, ChunkGenerator chunkGenerator, RandomState randomState) {
        int shrink = 3;
        StructurePiece lobby = this.seekLastRoomNode(6);
        if (lobby == null) {
            return;
        }
        BoundingBox lobbyBounds = lobby.getBoundingBox();
        BlockPos entranceRoomCenter = lobbyBounds.getCenter();
        int topSurfaceY = chunkGenerator.getFirstOccupiedHeight(entranceRoomCenter.getX(), entranceRoomCenter.getZ(), Heightmap.Types.OCEAN_FLOOR_WG, level, randomState);
        int roomCeiling = lobbyBounds.maxY() + 1;
        if (roomCeiling > topSurfaceY) {
            return;
        }
        int ruinsTopY = Math.max(roomCeiling, topSurfaceY + 4);
        int minX = lobbyBounds.minX() + 3;
        int minZ = lobbyBounds.minZ() + 3;
        int maxX = lobbyBounds.maxX() - 3;
        int maxZ = lobbyBounds.maxZ() - 3;
        BoundingBox upwardsTunnelBox = new BoundingBox(Math.min(minX, maxX), roomCeiling, Math.min(minZ, maxZ), Math.max(minX, maxX), ruinsTopY, Math.max(minZ, maxZ));
        this.nodes.add(new BronzeDungeonSurfaceRuins(upwardsTunnelBox));
    }

    public boolean buildTunnelFromRoom(StructurePiece connectedRoom, List<StructurePiece> list, Rotation rotation, Direction direction, BlockPos origin) {
        BlockPos pos;
        StructureTemplate template = this.manager.getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"bronze_dungeon/entrance"));
        BlockPos startPos = BlockLogicUtil.tunnelFromEvenSquareRoom(connectedRoom.getBoundingBox(), direction, template.getSize().getX());
        BronzeDungeonPiece entrance = this.chooseRoom("entrance", startPos, rotation, this.processors.roomSettings());
        list.add((StructurePiece)entrance);
        startPos = startPos.relative(direction);
        int length = template.getSize().getZ();
        boolean noOverlap = false;
        boolean reachedAir = false;
        int i = 0;
        do {
            pos = startPos.relative(direction, i);
            BronzeDungeonPiece tunnel = this.chooseRoom("end_corridor", pos, rotation, this.processors.tunnelSettings());
            StructurePiece col = null;
            for (StructurePiece piece : this.nodes) {
                if (piece == null || piece == connectedRoom || !piece.getBoundingBox().intersects(tunnel.getBoundingBox())) continue;
                col = piece;
                break;
            }
            if (col != null) break;
            noOverlap = true;
            list.add((StructurePiece)tunnel);
            connectedRoom = tunnel;
            i += length;
            if (!this.checkForAirAtPos(pos.getX(), pos.getY(), pos.getZ()) || !this.checkForAirAtPos(pos.getX(), tunnel.getBoundingBox().maxY(), pos.getZ())) continue;
            reachedAir = true;
            break;
        } while (Math.abs(origin.getX() - pos.getX()) < 100 && Math.abs(origin.getZ() - pos.getZ()) < 100);
        return noOverlap && reachedAir;
    }

    public BronzeDungeonPiece chooseRoom(String name, BlockPos pos, Rotation rotation, Holder<StructureProcessorList> processors) {
        Optional option;
        SimpleWeightedRandomList<RoomProvider<?>> list = ROOM_OPTIONS.get(name);
        if (list != null && (option = list.getRandomValue(this.random)).isPresent()) {
            return ((RoomProvider)option.get()).provide(this.manager, pos, rotation, processors);
        }
        return new BronzeDungeonRoom(this.manager, name, pos, rotation, processors);
    }

    public void populatePiecesBuilder(StructurePiecesBuilder builder) {
        StructurePiece bossRoom = this.nodes.removeFirst();
        this.nodes.forEach(arg_0 -> ((StructurePiecesBuilder)builder).addPiece(arg_0));
        this.edges.values().forEach(map -> map.values().forEach(connection -> builder.addPiece(connection.hallway)));
        builder.addPiece(bossRoom);
    }

    private boolean hasConnection(StructurePiece node, Direction direction) {
        Map<Direction, Connection> map = this.edges.get(node);
        return map != null && map.containsKey(direction);
    }

    private boolean checkForAirAtPos(int x, int y, int z) {
        NoiseColumn column = this.context.chunkGenerator().getBaseColumn(x, z, this.context.heightAccessor(), this.context.randomState());
        return column.getBlock(y).isAir();
    }

    private boolean isCloseToCenter(ChunkPos chunkPos, BlockPos pos) {
        ChunkPos currentChunk = new ChunkPos(pos);
        return chunkPos.getChessboardDistance(currentChunk) <= 3;
    }

    private boolean isCoveredAtPos(BoundingBox room) {
        ChunkGenerator chunkGenerator = this.context.chunkGenerator();
        LevelHeightAccessor heightAccessor = this.context.heightAccessor();
        RandomState randomState = this.context.randomState();
        int minX = room.minX() - 1;
        int minZ = room.minZ() - 1;
        int maxX = room.maxX() + 1;
        int maxZ = room.maxZ() + 1;
        NoiseColumn[] columns = new NoiseColumn[]{chunkGenerator.getBaseColumn(minX, minZ, heightAccessor, randomState), chunkGenerator.getBaseColumn(minX, maxZ, heightAccessor, randomState), chunkGenerator.getBaseColumn(maxX, minZ, heightAccessor, randomState), chunkGenerator.getBaseColumn(maxX, maxZ, heightAccessor, randomState)};
        return BronzeDungeonBuilder.isSolidInColumns(columns, room.minY() - 1, room.maxY() + 1);
    }

    @Nullable
    private Rotation getBossRoomRotation(BlockPos minPos, BlockPos maxPos) {
        StructureTemplate template = this.context.structureTemplateManager().getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"bronze_dungeon/chest_room"));
        WorldgenRandom random = this.context.random();
        BoundingBox bossBox = new BoundingBox(minPos.getX(), minPos.getY(), minPos.getZ(), maxPos.getX(), maxPos.getY(), maxPos.getZ());
        for (Rotation rotation : Rotation.getShuffled((RandomSource)random)) {
            Direction direction = rotation.rotate(Direction.SOUTH);
            BlockPos.MutableBlockPos neighbor = BlockLogicUtil.tunnelFromEvenSquareRoom(bossBox, direction, this.nodeWidth).mutable();
            if (!this.isCoveredAtPos(template.getBoundingBox((BlockPos)(neighbor = neighbor.move(direction.getStepX() * (this.edgeLength + bossBox.getXSpan()), 0, direction.getStepZ() * (this.edgeLength + bossBox.getZSpan()))), rotation, BlockPos.ZERO, Mirror.NONE))) continue;
            return rotation;
        }
        return null;
    }

    private static boolean isSolidInColumns(NoiseColumn[] columns, int minY, int maxY) {
        for (NoiseColumn column : columns) {
            for (int y = minY; y <= maxY; ++y) {
                if (!column.getBlock(y).isAir() && !column.getBlock(y).is(AetherTags.Blocks.NON_BRONZE_DUNGEON_SPAWNABLE)) continue;
                return false;
            }
        }
        return true;
    }

    static {
        ROOM_OPTIONS_BUILDER.get("boss_room").add((manager, pos, rotation, processorList) -> new BronzeBossRoom(manager, "boss_room", pos, rotation, (Holder<StructureProcessorList>)processorList), 1);
        ROOM_OPTIONS_BUILDER.get("chest_room").add((manager, pos, rotation, processorList) -> new BronzeDungeonRoom(manager, "chest_room", pos, rotation, (Holder<StructureProcessorList>)processorList), 1);
        ROOM_OPTIONS_BUILDER.get("end_corridor").add((manager, pos, rotation, processorList) -> new BronzeTunnel(manager, "end_corridor", pos, rotation, (Holder<StructureProcessorList>)processorList), 1);
        ROOM_OPTIONS_BUILDER.get("entrance").add((manager, pos, rotation, processorList) -> new BronzeDungeonRoom(manager, "entrance", pos, rotation, (Holder<StructureProcessorList>)processorList), 1);
        ROOM_OPTIONS_BUILDER.get("lobby").add((manager, pos, rotation, processorList) -> new BronzeDungeonRoom(manager, "lobby", pos, rotation, (Holder<StructureProcessorList>)processorList), 1);
        ROOM_OPTIONS_BUILDER.get("square_tunnel").add((manager, pos, rotation, processorList) -> new BronzeDungeonRoom(manager, "square_tunnel", pos, rotation, (Holder<StructureProcessorList>)processorList), 1);
    }

    private class Connection {
        public final StructurePiece start;
        public final StructurePiece end;
        public final StructurePiece hallway;

        public Connection(BronzeDungeonBuilder bronzeDungeonBuilder, StructurePiece start, StructurePiece end, StructurePiece hallway, Direction direction) {
            this.start = start;
            this.end = end;
            this.hallway = hallway;
            bronzeDungeonBuilder.edges.computeIfAbsent(start, piece -> new HashMap()).put(direction, this);
        }

        public StructurePiece endPiece() {
            return this.end;
        }
    }

    @FunctionalInterface
    public static interface RoomProvider<T extends BronzeDungeonPiece> {
        public T provide(StructureTemplateManager var1, BlockPos var2, Rotation var3, Holder<StructureProcessorList> var4);
    }
}

