/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.processor;

import com.aetherteam.aether.world.processor.AetherStructureProcessors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class NoReplaceProcessor
extends StructureProcessor {
    public static final NoReplaceProcessor AIR = new NoReplaceProcessor(Blocks.AIR);
    public static final MapCodec<NoReplaceProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("baseblock").forGetter(o -> o.baseBlock)).apply((Applicative)instance, NoReplaceProcessor::new));
    private final Block baseBlock;

    public NoReplaceProcessor(Block baseBlock) {
        this.baseBlock = baseBlock;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos origin, BlockPos centerBottom, StructureTemplate.StructureBlockInfo originalBlockInfo, StructureTemplate.StructureBlockInfo modifiedBlockInfo, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
        BlockState state = level.getBlockState(modifiedBlockInfo.pos());
        if (state.is(this.baseBlock)) {
            return new StructureTemplate.StructureBlockInfo(modifiedBlockInfo.pos(), state, null);
        }
        return modifiedBlockInfo;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)AetherStructureProcessors.NO_REPLACE.get();
    }
}

