/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network.packet.serverbound;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.command.SunAltarWhitelist;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SunAltarUpdatePacket(long dayTime, int timeScale) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SunAltarUpdatePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"update_sun_altar"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SunAltarUpdatePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, SunAltarUpdatePacket::dayTime, (StreamCodec)ByteBufCodecs.INT, SunAltarUpdatePacket::timeScale, SunAltarUpdatePacket::new);

    public CustomPacketPayload.Type<SunAltarUpdatePacket> type() {
        return TYPE;
    }

    public static void execute(SunAltarUpdatePacket payload, IPayloadContext context) {
        Player playerEntity = context.player();
        Level level = playerEntity.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if ((!((Boolean)AetherConfig.SERVER.sun_altar_whitelist.get()).booleanValue() || playerEntity.hasPermissions(4) || SunAltarWhitelist.INSTANCE.isWhiteListed(playerEntity.getGameProfile())) && ((List)AetherConfig.SERVER.sun_altar_dimensions.get()).contains(level2.dimension().location().toString())) {
                long dayBase = level2.getDayTime() / (long)payload.timeScale();
                long dayTime = dayBase * (long)payload.timeScale() + payload.dayTime();
                level2.setDayTime(dayTime);
                level2.getServer().getPlayerList().broadcastAll((Packet)new ClientboundSetTimePacket(level2.getGameTime(), level2.getDayTime(), level2.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)), level2.dimension());
            }
        }
    }
}

