/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network.packet.clientbound;

import com.aetherteam.aether.perk.data.ClientHaloPerkData;
import com.aetherteam.aether.perk.types.Halo;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientHaloPacket {

    public record Sync(Map<UUID, Halo> halos) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Sync> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"sync_halo"));
        public static final StreamCodec<RegistryFriendlyByteBuf, Sync> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(Maps::newHashMapWithExpectedSize, (StreamCodec)UUIDUtil.STREAM_CODEC, Halo.STREAM_CODEC), Sync::halos, Sync::new);

        public CustomPacketPayload.Type<?> type() {
            return TYPE;
        }

        public static void execute(Sync payload, IPayloadContext context) {
            if (Minecraft.getInstance().player != null && Minecraft.getInstance().level != null && payload.halos() != null && !payload.halos().isEmpty()) {
                for (Map.Entry<UUID, Halo> haloEntry : payload.halos().entrySet()) {
                    ClientHaloPerkData.INSTANCE.applyPerk(haloEntry.getKey(), haloEntry.getValue());
                }
            }
        }
    }

    public record Remove(UUID playerUUID) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Remove> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"remove_halo"));
        public static final StreamCodec<RegistryFriendlyByteBuf, Remove> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, Remove::playerUUID, Remove::new);

        public CustomPacketPayload.Type<Remove> type() {
            return TYPE;
        }

        public static void execute(Remove payload, IPayloadContext context) {
            if (Minecraft.getInstance().player != null && Minecraft.getInstance().level != null && payload.playerUUID() != null) {
                ClientHaloPerkData.INSTANCE.removePerk(payload.playerUUID());
            }
        }
    }

    public record Apply(UUID playerUUID, Halo halo) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<Apply> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"apply_halo"));
        public static final StreamCodec<RegistryFriendlyByteBuf, Apply> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, Apply::playerUUID, Halo.STREAM_CODEC, Apply::halo, Apply::new);

        public CustomPacketPayload.Type<Apply> type() {
            return TYPE;
        }

        public static void execute(Apply payload, IPayloadContext context) {
            if (Minecraft.getInstance().player != null && Minecraft.getInstance().level != null && payload.playerUUID() != null && payload.halo() != null) {
                ClientHaloPerkData.INSTANCE.applyPerk(payload.playerUUID(), payload.halo());
            }
        }
    }
}

