/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.miscellaneous;

import com.aetherteam.aether.entity.miscellaneous.Parachute;
import java.util.function.Supplier;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ParachuteItem
extends Item {
    protected final Supplier<? extends EntityType<? extends Parachute>> parachuteEntity;

    public ParachuteItem(Supplier<? extends EntityType<? extends Parachute>> parachuteEntity, Item.Properties properties) {
        super(properties);
        this.parachuteEntity = parachuteEntity;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        Entity entity;
        ItemStack heldStack = player.getItemInHand(hand);
        if (!player.onGround() && !player.isInFluidType() && !player.isShiftKeyDown() && (entity = this.getParachuteEntity().get().create(level)) instanceof Parachute) {
            Parachute parachute = (Parachute)entity;
            parachute.setPos(player.getX(), player.getY() - 1.0, player.getZ());
            parachute.setDeltaMovement(player.getDeltaMovement());
            if (player.isPassenger()) {
                if (player.getVehicle() instanceof Parachute) {
                    player.getVehicle().ejectPassengers();
                } else {
                    return InteractionResultHolder.pass((Object)heldStack);
                }
            }
            if (!level.isClientSide()) {
                level.addFreshEntity((Entity)parachute);
                player.startRiding((Entity)parachute);
                heldStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            parachute.spawnExplosionParticle();
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)heldStack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)heldStack);
    }

    public Supplier<? extends EntityType<? extends Parachute>> getParachuteEntity() {
        return this.parachuteEntity;
    }
}

