/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon.boss;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.gui.screen.ValkyrieQueenDialogueScreen;
import com.aetherteam.aether.data.resources.registries.AetherStructures;
import com.aetherteam.aether.entity.AetherBossMob;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.NpcDialogue;
import com.aetherteam.aether.entity.ai.goal.NpcDialogueGoal;
import com.aetherteam.aether.entity.monster.dungeon.AbstractValkyrie;
import com.aetherteam.aether.entity.monster.dungeon.boss.BossNameGenerator;
import com.aetherteam.aether.entity.projectile.crystal.ThunderCrystal;
import com.aetherteam.aether.event.AetherEventDispatch;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.network.packet.clientbound.BossInfoPacket;
import com.aetherteam.aether.network.packet.clientbound.QueenDialoguePacket;
import com.aetherteam.nitrogen.entity.BossRoomTracker;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.shapes.Shapes;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;

public class ValkyrieQueen
extends AbstractValkyrie
implements AetherBossMob<ValkyrieQueen>,
NpcDialogue,
IEntityWithComplexSpawn {
    private static final EntityDataAccessor<Boolean> DATA_IS_READY = SynchedEntityData.defineId(ValkyrieQueen.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Component> DATA_BOSS_NAME = SynchedEntityData.defineId(ValkyrieQueen.class, (EntityDataSerializer)EntityDataSerializers.COMPONENT);
    private static final Music VALKYRIE_QUEEN_MUSIC = new Music(AetherSoundEvents.MUSIC_BOSS_VALKYRIE_QUEEN, 0, 0, true);
    public static final Map<Block, Function<BlockState, BlockState>> DUNGEON_BLOCK_CONVERSIONS = new HashMap<Block, Function<BlockState, BlockState>>(Map.ofEntries(Map.entry((Block)AetherBlocks.LOCKED_ANGELIC_STONE.get(), blockState -> ((Block)AetherBlocks.ANGELIC_STONE.get()).defaultBlockState()), Map.entry((Block)AetherBlocks.TRAPPED_ANGELIC_STONE.get(), blockState -> ((Block)AetherBlocks.ANGELIC_STONE.get()).defaultBlockState()), Map.entry((Block)AetherBlocks.LOCKED_LIGHT_ANGELIC_STONE.get(), blockState -> ((Block)AetherBlocks.LIGHT_ANGELIC_STONE.get()).defaultBlockState()), Map.entry((Block)AetherBlocks.TRAPPED_LIGHT_ANGELIC_STONE.get(), blockState -> ((Block)AetherBlocks.LIGHT_ANGELIC_STONE.get()).defaultBlockState()), Map.entry((Block)AetherBlocks.BOSS_DOORWAY_ANGELIC_STONE.get(), blockState -> Blocks.AIR.defaultBlockState()), Map.entry((Block)AetherBlocks.TREASURE_DOORWAY_ANGELIC_STONE.get(), blockState -> (BlockState)((TrapDoorBlock)AetherBlocks.SKYROOT_TRAPDOOR.get()).defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)((Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING))))));
    private final ServerBossEvent bossFight = (ServerBossEvent)new ServerBossEvent(this.getBossName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).setPlayBossMusic(true);
    @Nullable
    private BossRoomTracker<ValkyrieQueen> dungeon;
    @Nullable
    private AABB dungeonBounds;
    @Nullable
    private Player conversingPlayer;

    public ValkyrieQueen(EntityType<? extends ValkyrieQueen> type, Level level) {
        super(type, level);
        this.setBossFight(false);
        this.xpReward = 50;
        this.setPersistenceRequired();
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        this.setBossName((Component)BossNameGenerator.generateValkyrieName(this.getRandom()));
        if (reason == MobSpawnType.STRUCTURE) {
            StructureManager manager = level.getLevel().structureManager();
            manager.registryAccess().registry(Registries.STRUCTURE).ifPresent(registry -> {
                StructureStart start;
                Structure temple = (Structure)registry.get(AetherStructures.SILVER_DUNGEON);
                if (temple != null && (start = manager.getStructureAt(this.blockPosition(), temple)) != StructureStart.INVALID_START) {
                    BoundingBox box = start.getBoundingBox();
                    AABB dungeonBounds = new AABB((double)box.minX(), (double)box.minY(), (double)box.minZ(), (double)(box.maxX() + 1), (double)(box.maxY() + 1), (double)(box.maxZ() + 1));
                    this.setDungeonBounds(dungeonBounds);
                }
            });
        }
        return spawnData;
    }

    @Override
    public void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, new NpcDialogueGoal<ValkyrieQueen>(this));
        this.goalSelector.addGoal(1, (Goal)new GetUnstuckGoal(this));
        this.goalSelector.addGoal(2, (Goal)new ThunderCrystalAttackGoal((Mob)this, 450, 28.0f));
        this.goalSelector.addGoal(3, (Goal)new AbstractValkyrie.LungeGoal(this, 0.65, 0));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, livingEntity -> this.isBossFight()));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return AbstractValkyrie.createAttributes().add(Attributes.FOLLOW_RANGE, 28.0).add(Attributes.ATTACK_DAMAGE, 13.5).add(Attributes.MAX_HEALTH, 500.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_READY, (Object)false);
        builder.define(DATA_BOSS_NAME, (Object)Component.literal((String)"Valkyrie Queen"));
    }

    @Override
    public void tick() {
        super.tick();
        this.breakBlocks();
        this.evaporate();
        double motionY = this.getDeltaMovement().y();
        if (!this.onGround() && Math.abs(motionY - this.lastMotionY) > 0.07 && Math.abs(motionY - this.lastMotionY) < 0.09) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.055, 0.0));
        }
    }

    private void breakBlocks() {
        LivingEntity target = this.getTarget();
        if (!this.level().isClientSide() && target != null && EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) {
            for (int i = 0; i < 2; ++i) {
                Vec3i vector = i == 0 ? this.getMotionDirection().getNormal() : Vec3i.ZERO;
                BlockPos upperPosition = BlockPos.containing((Position)this.getEyePosition()).offset(vector);
                BlockPos lowerPosition = this.blockPosition().offset(vector);
                BlockState upperState = this.level().getBlockState(upperPosition);
                BlockState lowerState = this.level().getBlockState(lowerPosition);
                if (this.isBreakable(upperState) && (upperState.getShape((BlockGetter)this.level(), upperPosition).equals(Shapes.block()) || !upperState.getCollisionShape((BlockGetter)this.level(), upperPosition).isEmpty()) && (this.getDungeon() == null || this.getDungeon().roomBounds().contains(upperPosition.getCenter()))) {
                    this.level().destroyBlock(upperPosition, true, (Entity)this);
                    this.swing(InteractionHand.MAIN_HAND);
                    continue;
                }
                if (!this.isBreakable(lowerState) || !lowerState.getShape((BlockGetter)this.level(), lowerPosition).equals(Shapes.block()) && lowerState.getCollisionShape((BlockGetter)this.level(), lowerPosition).isEmpty() || this.getDungeon() != null && !this.getDungeon().roomBounds().contains(lowerPosition.getCenter())) continue;
                this.level().destroyBlock(lowerPosition, true, (Entity)this);
                this.swing(InteractionHand.MAIN_HAND);
            }
        }
    }

    private boolean isBreakable(BlockState blockState) {
        return !blockState.isAir() && !blockState.is(AetherTags.Blocks.VALKYRIE_QUEEN_UNBREAKABLE) && blockState.getBlock().defaultDestroyTime() >= 0.0f && blockState.getBlock().defaultDestroyTime() < 100.0f;
    }

    private void evaporate() {
        Pair minMax = this.getDefaultBounds((Mob)this);
        AetherBossMob.super.evaporate(this, (BlockPos)minMax.getLeft(), (BlockPos)minMax.getRight(), blockState -> !blockState.is(AetherTags.Blocks.VALKYRIE_QUEEN_UNBREAKABLE));
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        this.bossFight.setProgress(this.getHealth() / this.getMaxHealth());
        this.trackDungeon();
    }

    @Override
    protected boolean teleportAroundTarget(Entity target) {
        Vec2 targetVec = new Vec2(this.getRandom().nextFloat() - 0.5f, this.getRandom().nextFloat() - 0.5f).normalized();
        double x = target.getX() + (double)(targetVec.x * 7.0f);
        double y = target.getY();
        double z = target.getZ() + (double)(targetVec.y * 7.0f);
        if (this.getDungeon() != null) {
            AABB room = this.getDungeon().roomBounds();
            x = Mth.clamp((double)x, (double)(room.minX + 1.0), (double)(room.maxX - 1.0));
            y = Mth.clamp((double)y, (double)(room.minY + 1.0), (double)(room.maxY - 1.0));
            z = Mth.clamp((double)z, (double)(room.minZ + 1.0), (double)(room.maxZ - 1.0));
        }
        return this.teleport(x, y, z);
    }

    protected void teleportUnstuck(Entity target) {
        this.teleport(target.getX(), target.getY(), target.getZ());
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && !this.isBossFight() && !this.level().isClientSide()) {
            if (!this.isReady()) {
                this.lookAt((Entity)player, 180.0f, 180.0f);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (this.getConversingPlayer() == null) {
                        this.playSound(this.getInteractSound(), 1.0f, this.getVoicePitch());
                        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new QueenDialoguePacket(this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        this.setConversingPlayer((Player)serverPlayer);
                    }
                }
            } else {
                this.chatWithNearby((Component)Component.translatable((String)"gui.aether.queen.dialog.ready"), true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void openDialogueScreen() {
        Minecraft.getInstance().setScreen((Screen)new ValkyrieQueenDialogueScreen(this));
    }

    @Override
    public void handleNpcInteraction(Player player, byte interactionID) {
        block0 : switch (interactionID) {
            case 0: {
                this.chat(player, (Component)Component.translatable((String)"gui.aether.queen.dialog.answer"), true);
                break;
            }
            case 1: {
                if (this.level().getDifficulty() == Difficulty.PEACEFUL) {
                    this.chat(player, (Component)Component.translatable((String)"gui.aether.queen.dialog.peaceful"), true);
                    break;
                }
                if (player.getInventory().countItem((Item)AetherItems.VICTORY_MEDAL.get()) >= 10) {
                    this.readyUp();
                    int count = 10;
                    for (ItemStack item : player.inventoryMenu.getItems()) {
                        if (item.is((Item)AetherItems.VICTORY_MEDAL.get())) {
                            if (item.getCount() > count) {
                                item.shrink(count);
                                break block0;
                            }
                            count -= item.getCount();
                            item.setCount(0);
                        }
                        if (count > 0) continue;
                        break block0;
                    }
                    break;
                }
                this.chat(player, (Component)Component.translatable((String)"gui.aether.queen.dialog.no_medals"), true);
                break;
            }
            case 2: {
                this.chat(player, (Component)Component.translatable((String)"gui.aether.queen.dialog.deny_fight"), true);
                break;
            }
            default: {
                this.chat(player, (Component)Component.translatable((String)"gui.aether.queen.dialog.goodbye"), true);
            }
        }
        this.setConversingPlayer(null);
    }

    public void readyUp() {
        MutableComponent message = Component.translatable((String)"gui.aether.queen.dialog.begin");
        this.chatWithNearby((Component)message, true);
        this.setReady(true);
    }

    protected void chatWithNearby(Component message, boolean sound) {
        AABB room = this.dungeon == null ? this.getBoundingBox().inflate(16.0) : this.dungeon.roomBounds();
        this.level().getNearbyPlayers(NON_COMBAT, (LivingEntity)this, room).forEach(player -> this.chat((Player)player, message, sound));
    }

    @Override
    protected void chat(Player player, Component message, boolean sound) {
        player.sendSystemMessage((Component)Component.literal((String)"[").append((Component)this.getBossName().copy().withStyle(ChatFormatting.YELLOW)).append("]: ").append(message));
        this.playSound(this.getInteractSound(), 1.0f, this.getVoicePitch());
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        Entity entity;
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurt(source, amount);
        }
        if (this.isReady() && (entity = source.getEntity()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (this.level().getDifficulty() != Difficulty.PEACEFUL) {
                if (this.getDungeon() == null || this.getDungeon().isPlayerWithinRoomInterior((Entity)attacker)) {
                    if (super.hurt(source, amount) && this.getHealth() > 0.0f) {
                        if (!this.level().isClientSide() && !this.isBossFight()) {
                            this.chatWithNearby((Component)Component.translatable((String)"gui.aether.queen.dialog.fight"), false);
                            this.setHealth(this.getMaxHealth());
                            this.setBossFight(true);
                            if (this.getDungeon() != null) {
                                this.closeRoom();
                            }
                            AetherEventDispatch.onBossFightStart((Entity)this, this.getDungeon());
                        }
                        return true;
                    }
                } else if (!this.level().isClientSide() && attacker instanceof Player) {
                    Player player = (Player)attacker;
                    this.displayTooFarMessage(player);
                    return false;
                }
            }
        }
        return false;
    }

    public boolean doHurtTarget(Entity entity) {
        ServerPlayer player;
        boolean result = super.doHurtTarget(entity);
        if (entity instanceof ServerPlayer && (player = (ServerPlayer)entity).getHealth() <= 0.0f) {
            this.chat((Player)player, (Component)Component.translatable((String)"gui.aether.queen.dialog.playerdeath"), true);
        }
        return result;
    }

    public void reset() {
        this.setBossFight(false);
        this.setTarget(null);
        if (this.getDungeon() != null) {
            this.openRoom();
        }
        AetherEventDispatch.onBossFightStop((Entity)this, this.getDungeon());
    }

    public void die(DamageSource source) {
        if (!this.level().isClientSide) {
            this.bossFight.setProgress(this.getHealth() / this.getMaxHealth());
            this.chatWithNearby((Component)Component.translatable((String)"gui.aether.queen.dialog.defeated"), false);
            this.spawnExplosionParticles();
            if (this.getDungeon() != null) {
                this.getDungeon().grantAdvancements(source);
                this.tearDownRoom();
            }
        }
        super.die(source);
    }

    public void tearDownRoom() {
        for (BlockPos pos : BlockPos.betweenClosed((int)((int)this.dungeonBounds.minX), (int)((int)this.dungeonBounds.minY), (int)((int)this.dungeonBounds.minZ), (int)((int)this.dungeonBounds.maxX), (int)((int)this.dungeonBounds.maxY), (int)((int)this.dungeonBounds.maxZ))) {
            BlockState state = this.level().getBlockState(pos);
            BlockState newState = this.convertBlock(state);
            if (newState == null) continue;
            this.level().setBlock(pos, newState, 3);
        }
    }

    public void checkDespawn() {
    }

    @Nullable
    public BlockState convertBlock(BlockState state) {
        return DUNGEON_BLOCK_CONVERSIONS.getOrDefault(state.getBlock(), blockState -> null).apply(state);
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new BossInfoPacket.Display(this.bossFight.getId(), this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (this.getDungeon() == null || this.getDungeon().isPlayerTracked((Player)player)) {
            this.bossFight.addPlayer(player);
            AetherEventDispatch.onBossFightPlayerAdd((Entity)this, this.getDungeon(), player);
        }
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new BossInfoPacket.Remove(this.bossFight.getId(), this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.bossFight.removePlayer(player);
        AetherEventDispatch.onBossFightPlayerRemove((Entity)this, this.getDungeon(), player);
    }

    public void onDungeonPlayerAdded(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.bossFight.addPlayer(serverPlayer);
            AetherEventDispatch.onBossFightPlayerAdd((Entity)this, this.getDungeon(), serverPlayer);
        }
    }

    public void onDungeonPlayerRemoved(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.bossFight.removePlayer(serverPlayer);
            AetherEventDispatch.onBossFightPlayerRemove((Entity)this, this.getDungeon(), serverPlayer);
        }
    }

    public boolean isReady() {
        return (Boolean)this.getEntityData().get(DATA_IS_READY);
    }

    public void setReady(boolean ready) {
        this.getEntityData().set(DATA_IS_READY, (Object)ready);
    }

    public Component getBossName() {
        return (Component)this.getEntityData().get(DATA_BOSS_NAME);
    }

    public void setBossName(Component component) {
        this.getEntityData().set(DATA_BOSS_NAME, (Object)component);
        this.bossFight.setName(component);
    }

    @Nullable
    public BossRoomTracker<ValkyrieQueen> getDungeon() {
        return this.dungeon;
    }

    public void setDungeon(@Nullable BossRoomTracker<ValkyrieQueen> dungeon) {
        this.dungeon = dungeon;
        if (this.dungeonBounds == null) {
            this.dungeonBounds = dungeon.roomBounds();
        }
    }

    public boolean isBossFight() {
        return this.bossFight.isVisible();
    }

    public void setBossFight(boolean isFighting) {
        this.bossFight.setVisible(isFighting);
    }

    @Override
    @Nullable
    public ResourceLocation getBossBarTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"boss_bar/valkyrie_queen");
    }

    @Override
    @Nullable
    public ResourceLocation getBossBarBackgroundTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"boss_bar/valkyrie_queen_background");
    }

    @Override
    @Nullable
    public Music getBossMusic() {
        return VALKYRIE_QUEEN_MUSIC;
    }

    public void setDungeonBounds(@Nullable AABB dungeonBounds) {
        this.dungeonBounds = dungeonBounds;
    }

    @Override
    @Nullable
    public Player getConversingPlayer() {
        return this.conversingPlayer;
    }

    @Override
    public void setConversingPlayer(@Nullable Player player) {
        this.conversingPlayer = player;
    }

    public int getDeathScore() {
        return this.deathScore;
    }

    public void setCustomName(@Nullable Component pName) {
        super.setCustomName(pName);
        this.setBossName(pName);
    }

    protected SoundEvent getInteractSound() {
        return (SoundEvent)AetherSoundEvents.ENTITY_VALKYRIE_QUEEN_INTERACT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)AetherSoundEvents.ENTITY_VALKYRIE_QUEEN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AetherSoundEvents.ENTITY_VALKYRIE_QUEEN_DEATH.get();
    }

    protected boolean isAffectedByFluids() {
        return this.jumping;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.addBossSaveData(tag, (HolderLookup.Provider)this.registryAccess());
        if (this.dungeonBounds != null) {
            tag.putDouble("DungeonBoundsMinX", this.dungeonBounds.minX);
            tag.putDouble("DungeonBoundsMinY", this.dungeonBounds.minY);
            tag.putDouble("DungeonBoundsMinZ", this.dungeonBounds.minZ);
            tag.putDouble("DungeonBoundsMaxX", this.dungeonBounds.maxX);
            tag.putDouble("DungeonBoundsMaxY", this.dungeonBounds.maxY);
            tag.putDouble("DungeonBoundsMaxZ", this.dungeonBounds.maxZ);
        }
        tag.putBoolean("Ready", this.isReady());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.readBossSaveData(tag, (HolderLookup.Provider)this.registryAccess());
        if (tag.contains("DungeonBoundsMinX")) {
            double minX = tag.getDouble("DungeonBoundsMinX");
            double minY = tag.getDouble("DungeonBoundsMinY");
            double minZ = tag.getDouble("DungeonBoundsMinZ");
            double maxX = tag.getDouble("DungeonBoundsMaxX");
            double maxY = tag.getDouble("DungeonBoundsMaxY");
            double maxZ = tag.getDouble("DungeonBoundsMaxZ");
            this.dungeonBounds = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
        }
        if (tag.contains("Ready")) {
            this.setReady(tag.getBoolean("Ready"));
        }
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        CompoundTag tag = new CompoundTag();
        this.addBossSaveData(tag, (HolderLookup.Provider)this.registryAccess());
        buffer.writeNbt((Tag)tag);
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        CompoundTag tag = additionalData.readNbt();
        if (tag != null) {
            this.readBossSaveData(tag, (HolderLookup.Provider)this.registryAccess());
        }
    }

    public static class GetUnstuckGoal
    extends Goal {
        private final ValkyrieQueen valkyrie;
        protected int stuckTimer;

        public GetUnstuckGoal(ValkyrieQueen valkyrie) {
            this.valkyrie = valkyrie;
        }

        public boolean canUse() {
            LivingEntity target = this.valkyrie.getTarget();
            if (target == null) {
                return false;
            }
            if (target.getY() > this.valkyrie.getY()) {
                if (this.stuckTimer++ >= 75) {
                    this.stuckTimer = 0;
                    return true;
                }
            } else {
                this.stuckTimer = 0;
            }
            return false;
        }

        public void start() {
            if (this.valkyrie.getTarget() != null) {
                this.valkyrie.teleportUnstuck((Entity)this.valkyrie.getTarget());
            }
        }
    }

    public static class ThunderCrystalAttackGoal
    extends Goal {
        private final Mob mob;
        private final int attackInterval;
        private final float attackRadius;
        private int attackTime = 0;

        public ThunderCrystalAttackGoal(Mob mob, int attackInterval, float attackRadius) {
            this.mob = mob;
            this.attackInterval = attackInterval;
            this.attackRadius = attackRadius;
        }

        public boolean canUse() {
            LivingEntity target = this.mob.getTarget();
            if (target != null && target.isAlive()) {
                return this.mob.level().getDifficulty() != Difficulty.PEACEFUL;
            }
            return false;
        }

        public void tick() {
            double distance;
            if (this.mob.getTarget() != null && (distance = (double)this.mob.distanceTo((Entity)this.mob.getTarget())) < (double)this.attackRadius && ++this.attackTime >= this.attackInterval) {
                ThunderCrystal thunderCrystal = new ThunderCrystal((EntityType<? extends ThunderCrystal>)((EntityType)AetherEntityTypes.THUNDER_CRYSTAL.get()), this.mob.level(), (Entity)this.mob, (Entity)this.mob.getTarget());
                this.mob.level().addFreshEntity((Entity)thunderCrystal);
                this.attackTime = this.mob.getRandom().nextInt(40);
            }
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }
}

