/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.EntityUtil;
import com.aetherteam.aether.entity.MountableMob;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.EquipmentUtil;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Swet
extends Slime
implements MountableMob {
    private static final EntityDataAccessor<Boolean> DATA_PLAYER_JUMPED_ID = SynchedEntityData.defineId(Swet.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_MOUNT_JUMPING_ID = SynchedEntityData.defineId(Swet.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_MID_JUMP_ID = SynchedEntityData.defineId(Swet.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> DATA_WATER_DAMAGE_SCALE_ID = SynchedEntityData.defineId(Swet.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private int ascendTimer;
    private boolean wasOnGround;
    private int jumpTimer;
    private float swetHeight = 1.0f;
    private float swetHeightO = 1.0f;
    private float swetWidth = 1.0f;
    private float swetWidthO = 1.0f;

    public Swet(EntityType<? extends Swet> type, Level level) {
        super(type, level);
        this.moveControl = new SwetMoveControl(this);
        this.xpReward = 5;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new ConsumeGoal(this));
        this.goalSelector.addGoal(1, (Goal)new HuntGoal(this));
        this.goalSelector.addGoal(2, (Goal)new SwetRandomDirectionGoal(this));
        this.goalSelector.addGoal(4, (Goal)new SwetKeepOnJumpingGoal(this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, target -> !this.isFriendlyTowardEntity((LivingEntity)target) && !(target.getRootVehicle() instanceof Swet)));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.FOLLOW_RANGE, 14.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_PLAYER_JUMPED_ID, (Object)false);
        builder.define(DATA_MOUNT_JUMPING_ID, (Object)false);
        builder.define(DATA_MID_JUMP_ID, (Object)false);
        builder.define(DATA_WATER_DAMAGE_SCALE_ID, (Object)Float.valueOf(0.0f));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        if (DATA_WATER_DAMAGE_SCALE_ID.equals(dataAccessor)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(dataAccessor);
    }

    public static boolean checkSwetSpawnRules(EntityType<? extends Swet> swet, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(AetherTags.Blocks.SWET_SPAWNABLE_ON) && level.getRawBrightness(pos, 0) > 8 && level.getDifficulty() != Difficulty.PEACEFUL && (reason != MobSpawnType.NATURAL || !Swet.inRadiusOfBanner(level, pos, 40) && !Swet.inRadiusOfSwetCape(level, pos, 40));
    }

    private static boolean inRadiusOfBanner(LevelAccessor level, BlockPos pos, int radius) {
        for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
            for (int yOffset = -radius; yOffset <= radius; ++yOffset) {
                for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                    BannerBlockEntity bannerBlockEntity;
                    BlockEntity blockEntity;
                    BlockPos offsetPos;
                    if (xOffset * xOffset + yOffset * yOffset + zOffset * zOffset > radius * radius || !level.getBlockState(offsetPos = pos.offset(xOffset, yOffset, zOffset)).is(Blocks.BLACK_BANNER) || !((blockEntity = level.getBlockEntity(offsetPos)) instanceof BannerBlockEntity) || !ItemStack.matches((ItemStack)(bannerBlockEntity = (BannerBlockEntity)blockEntity).getItem(), (ItemStack)AetherItems.createSwetBannerItemStack((HolderGetter<BannerPattern>)level.holderLookup(Registries.BANNER_PATTERN)))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean inRadiusOfSwetCape(LevelAccessor level, BlockPos pos, int radius) {
        return !level.getEntities(EntityTypeTest.forClass(ArmorStand.class), AABB.ofSize((Vec3)pos.getCenter(), (double)(radius * 2), (double)(radius * 2), (double)(radius * 2)), EquipmentUtil::hasSwetCape).isEmpty();
    }

    public void tick() {
        if (this.isInWater()) {
            this.spawnDissolveParticles();
            if (this.getWaterDamageScale() < 0.9f) {
                this.setWaterDamageScale(this.getWaterDamageScale() + 0.02f);
            }
        }
        if (this.getWaterDamageScale() >= 0.9f && !this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
        this.tick((Mob)this);
        this.riderTick((Mob)this);
        super.tick();
        if (!this.onGround() && this.getDeltaMovement().y() < 0.05 && this.ascendTimer > 0) {
            this.setDeltaMovement(this.getDeltaMovement().x() * 1.2, 0.07, this.getDeltaMovement().z() * 1.2);
            --this.ascendTimer;
        }
        if (this.onGround()) {
            this.ascendTimer = 10;
        }
        if (!this.hasPrey() && this.canSpawnSplashParticles() && this.level().isClientSide()) {
            double d = (float)this.getX() + (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.3f;
            double d1 = (float)this.getY() + this.getBbHeight();
            double d2 = (float)this.getZ() + (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.3f;
            this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, d, d1 - 0.25, d2, 0.0, 0.0, 0.0);
        }
        if (!this.isNoAi()) {
            this.setMidJump(!this.onGround());
            if (this.level().isClientSide()) {
                this.swetHeightO = this.swetHeight;
                this.swetWidthO = this.swetWidth;
                this.jumpTimer = this.getMidJump() ? ++this.jumpTimer : 0;
                if (this.getJumpTimer() > 1) {
                    this.swetHeight = 1.425f;
                    this.swetWidth = 0.875f;
                    float scale = Math.min(this.getJumpTimer(), 10);
                    if (this.getJumpTimer() > 2) {
                        this.swetHeight -= 0.04f * scale;
                        this.swetWidth += 0.04f * scale;
                    }
                    if (this.getJumpTimer() > 3) {
                        this.swetHeight -= 0.02f * scale;
                        this.swetWidth += 0.02f * scale;
                    }
                } else {
                    this.swetHeight = this.swetHeight < 1.0f ? this.swetHeight + 0.25f : 1.0f;
                    this.swetWidth = this.swetWidth > 1.0f ? this.swetWidth - 0.25f : 1.0f;
                }
            }
            this.wasOnGround = this.onGround();
        }
        if (this.isFriendly()) {
            this.resetFallDistance();
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.getTarget() != null && (this.hasPrey() || this.isFriendlyTowardEntity(this.getTarget()) || this.getTarget().getRootVehicle() instanceof Swet)) {
            this.setTarget(null);
        }
    }

    public void travel(Vec3 vector) {
        this.travel((Mob)this, vector);
        if (this.isAlive()) {
            LivingEntity entity = this.getControllingPassenger();
            if (this.isVehicle() && entity != null) {
                if (this.onGround() && !this.getPlayerJumped() && (this.getDeltaMovement().x() != 0.0 || this.getDeltaMovement().z() != 0.0)) {
                    this.setDeltaMovement(this.getDeltaMovement().x(), 0.42f, this.getDeltaMovement().z());
                }
                this.resetFallDistance();
            }
        }
    }

    @Override
    public void travelWithInput(Vec3 motion) {
        super.travel(motion);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!this.level().isClientSide() && !this.hasPrey() && this.isFriendlyTowardEntity((LivingEntity)player) && this.getScale() >= super.getScale()) {
            this.consumePassenger((LivingEntity)player);
        }
        return InteractionResult.PASS;
    }

    public void consumePassenger(LivingEntity livingEntity) {
        this.playSound((SoundEvent)AetherSoundEvents.ENTITY_SWET_ATTACK.get(), 0.5f, (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f + 1.0f);
        EntityUtil.copyRotations((Entity)livingEntity, (Entity)this);
        this.setDeltaMovement(livingEntity.getDeltaMovement());
        livingEntity.startRiding((Entity)this, true);
    }

    public void spawnDissolveParticles() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.broadcastEntityEvent((Entity)this, (byte)70);
        }
    }

    public boolean getMidJump() {
        return (Boolean)this.getEntityData().get(DATA_MID_JUMP_ID);
    }

    public void setMidJump(boolean midJump) {
        this.getEntityData().set(DATA_MID_JUMP_ID, (Object)midJump);
    }

    public float getWaterDamageScale() {
        return ((Float)this.getEntityData().get(DATA_WATER_DAMAGE_SCALE_ID)).floatValue();
    }

    public void setWaterDamageScale(float scale) {
        this.getEntityData().set(DATA_WATER_DAMAGE_SCALE_ID, (Object)Float.valueOf(scale));
    }

    @Override
    public boolean getPlayerJumped() {
        return (Boolean)this.getEntityData().get(DATA_PLAYER_JUMPED_ID);
    }

    @Override
    public void setPlayerJumped(boolean playerJumped) {
        this.getEntityData().set(DATA_PLAYER_JUMPED_ID, (Object)playerJumped);
    }

    @Override
    public boolean isMountJumping() {
        return (Boolean)this.getEntityData().get(DATA_MOUNT_JUMPING_ID);
    }

    @Override
    public void setMountJumping(boolean isMountJumping) {
        this.getEntityData().set(DATA_MOUNT_JUMPING_ID, (Object)isMountJumping);
    }

    public float getSwetHeight() {
        return this.swetHeight;
    }

    public float getSwetHeightO() {
        return this.swetHeightO;
    }

    public float getSwetWidth() {
        return this.swetWidth;
    }

    public float getSwetWidthO() {
        return this.swetWidthO;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)AetherSoundEvents.ENTITY_SWET_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SWET_DEATH.get();
    }

    protected SoundEvent getSquishSound() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SWET_SQUISH.get();
    }

    public boolean hasPrey() {
        return this.getFirstPassenger() != null;
    }

    public boolean canSpawnSplashParticles() {
        return true;
    }

    public boolean isFriendly() {
        return this.getControllingPassenger() != null;
    }

    public boolean isFriendlyTowardEntity(LivingEntity entity) {
        return EquipmentUtil.hasSwetCape(entity);
    }

    public int getJumpTimer() {
        return this.jumpTimer;
    }

    public int getJumpDelay() {
        return this.getRandom().nextInt(20) + 10;
    }

    public float getJumpPower() {
        LivingEntity entity = this.getControllingPassenger();
        if (this.isVehicle() && entity != null) {
            return 0.5f;
        }
        return 0.325f;
    }

    @Override
    public double getMountJumpStrength() {
        return 1.2;
    }

    @Override
    public double jumpFactor() {
        return this.getBlockJumpFactor();
    }

    @Override
    public boolean canJump() {
        return this.onGround() && this.isFriendly();
    }

    @Override
    public float getSteeringSpeed() {
        return (float)(this.getAttributeValue(Attributes.MOVEMENT_SPEED) * (double)0.21f);
    }

    public float getFlyingSpeed() {
        return this.getControllingPassenger() != null ? this.getSteeringSpeed() * 0.25f : 0.02f;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return super.getPassengerRidingPosition(entity).add(0.0, 0.725, 0.0);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        LivingEntity livingEntity;
        Entity entity = this.getFirstPassenger();
        if (entity instanceof LivingEntity && this.isFriendlyTowardEntity(livingEntity = (LivingEntity)entity)) {
            return livingEntity;
        }
        return null;
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity livingEntity) {
        if (this.isFriendlyTowardEntity(livingEntity)) {
            return super.getDismountLocationForPassenger(livingEntity);
        }
        return this.position();
    }

    public int getSize() {
        return this.isVehicle() ? 2 : 1;
    }

    public void setSize(int size, boolean resetHealth) {
    }

    public float getScale() {
        return super.getScale() - super.getScale() * this.getWaterDamageScale();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(this.getScale());
    }

    protected boolean isDealsDamage() {
        return false;
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    protected boolean spawnCustomParticles() {
        return true;
    }

    public void handleEntityEvent(byte id) {
        if (id == 70) {
            for (int i = 0; i < 10; ++i) {
                double f = this.getRandom().nextFloat() * ((float)Math.PI * 2);
                double f1 = this.getRandom().nextFloat() * this.swetWidth + 0.25f;
                double f2 = (double)(this.getRandom().nextFloat() * this.swetHeight) - this.getRandom().nextGaussian() * 0.02 * 10.0;
                double f3 = (double)Mth.sin((float)((float)f)) * f1;
                double f4 = (double)Mth.cos((float)((float)f)) * f1;
                this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() + f3, this.getY() + f2, this.getZ() + f4, f3 * 1.5 + this.getDeltaMovement().x(), 4.0, f4 * 1.5 + this.getDeltaMovement().z());
            }
        } else if (id == 71) {
            this.absMoveTo(this.getX(), this.getY(), this.getZ());
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("WaterDamageScale", this.getWaterDamageScale());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("WaterDamageScale")) {
            this.setWaterDamageScale(tag.getFloat("WaterDamageScale"));
        }
    }

    public static class SwetMoveControl
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final Swet swet;
        private boolean isAggressive;
        private boolean canJump;

        public SwetMoveControl(Swet swet) {
            super((Mob)swet);
            this.swet = swet;
            this.yRot = 180.0f * swet.getYRot() / (float)Math.PI;
        }

        public void setDirection(float yRot, boolean isAggressive) {
            this.yRot = yRot;
            this.isAggressive = isAggressive;
        }

        public void setWantedMovement(double speed) {
            this.speedModifier = speed;
            this.operation = MoveControl.Operation.MOVE_TO;
        }

        public void setCanJump(boolean canJump) {
            this.canJump = canJump;
        }

        public void tick() {
            if (this.swet.isFriendly()) {
                return;
            }
            this.swet.setYRot(this.rotlerp(this.swet.getYRot(), this.yRot, 90.0f));
            this.swet.setYHeadRot(this.swet.getYRot());
            this.swet.setYBodyRot(this.swet.getYRot());
            if (this.operation != MoveControl.Operation.MOVE_TO) {
                this.swet.setZza(0.0f);
            } else {
                this.operation = MoveControl.Operation.WAIT;
                if (this.swet.onGround()) {
                    this.swet.setSpeed((float)(this.speedModifier * this.swet.getAttributeValue(Attributes.MOVEMENT_SPEED)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.swet.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 6;
                        }
                        this.swet.getJumpControl().jump();
                        this.swet.playSound((SoundEvent)AetherSoundEvents.ENTITY_SWET_JUMP.get(), 1.0f, ((this.swet.getRandom().nextFloat() - this.swet.getRandom().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                    } else {
                        this.swet.xxa = 0.0f;
                        this.swet.zza = 0.0f;
                        this.swet.setSpeed(0.0f);
                    }
                } else {
                    this.swet.setSpeed((float)(this.speedModifier * this.swet.getAttributeValue(Attributes.MOVEMENT_SPEED)));
                }
            }
        }
    }

    public static class ConsumeGoal
    extends Goal {
        private final Swet swet;
        private int jumps = 0;
        private float chosenDegrees = 0.0f;

        public ConsumeGoal(Swet swet) {
            this.swet = swet;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            LivingEntity passenger;
            Object e;
            return this.swet.hasPrey() && (e = this.swet.getPassengers().getFirst()) instanceof LivingEntity && !this.swet.isFriendlyTowardEntity(passenger = (LivingEntity)e);
        }

        public void tick() {
            if (this.jumps <= 3) {
                if (this.swet.onGround()) {
                    this.swet.level().broadcastEntityEvent((Entity)this.swet, (byte)71);
                    this.swet.playSound((SoundEvent)AetherSoundEvents.ENTITY_SWET_JUMP.get(), 1.0f, ((this.swet.getRandom().nextFloat() - this.swet.getRandom().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                    this.chosenDegrees = this.swet.getRandom().nextInt(360);
                    if (this.jumps == 0) {
                        this.swet.setDeltaMovement(this.swet.getDeltaMovement().add(0.0, 0.65, 0.0));
                    } else if (this.jumps == 1) {
                        this.swet.setDeltaMovement(this.swet.getDeltaMovement().add(0.0, 0.75, 0.0));
                    } else if (this.jumps == 2) {
                        this.swet.setDeltaMovement(this.swet.getDeltaMovement().add(0.0, 1.55, 0.0));
                    } else {
                        ((Entity)this.swet.getPassengers().getFirst()).stopRiding();
                        this.swet.spawnDissolveParticles();
                        this.swet.discard();
                    }
                    if (!this.swet.getMidJump()) {
                        ++this.jumps;
                    }
                }
                if (!this.swet.wasOnGround && this.swet.getJumpTimer() < 6) {
                    if (this.jumps == 1) {
                        this.moveHorizontal(0.0f, 0.1f, this.chosenDegrees);
                    } else if (this.jumps == 2) {
                        this.moveHorizontal(0.0f, 0.15f, this.chosenDegrees);
                    } else if (this.jumps == 3) {
                        this.moveHorizontal(0.0f, 0.3f, this.chosenDegrees);
                    }
                }
            }
        }

        public void moveHorizontal(float strafe, float forward, float rotation) {
            float f = Mth.square((float)strafe) + Mth.square((float)forward);
            if ((f = Mth.sqrt((float)f)) < 1.0f) {
                f = 1.0f;
            }
            float f1 = Mth.sin((float)(rotation * ((float)Math.PI / 180)));
            float f2 = Mth.cos((float)(rotation * ((float)Math.PI / 180)));
            this.swet.setDeltaMovement((strafe *= f) * f2 - (forward *= f) * f1, this.swet.getDeltaMovement().y(), forward * f2 + strafe * f1);
            MoveControl moveControl = this.swet.getMoveControl();
            if (moveControl instanceof SwetMoveControl) {
                SwetMoveControl swetMoveControl = (SwetMoveControl)moveControl;
                swetMoveControl.yRot = rotation % 360.0f;
            }
        }
    }

    public static class HuntGoal
    extends Goal {
        private final Swet swet;

        public HuntGoal(Swet swet) {
            this.swet = swet;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            block3: {
                block2: {
                    LivingEntity target = this.swet.getTarget();
                    if (this.swet.hasPrey() || target == null || !target.isAlive() || this.swet.isFriendlyTowardEntity(target)) break block2;
                    if (!(target instanceof Player)) break block3;
                    Player player = (Player)target;
                    if (!player.getAbilities().invulnerable) break block3;
                }
                return false;
            }
            return this.swet.getMoveControl() instanceof SwetMoveControl;
        }

        public boolean canContinueToUse() {
            LivingEntity target = this.swet.getTarget();
            if (this.swet.hasPrey() || target == null || !target.isAlive()) {
                return false;
            }
            if (target instanceof Player) {
                Player player = (Player)target;
                if (player.getAbilities().invulnerable) {
                    return false;
                }
            }
            return !this.swet.isFriendlyTowardEntity(target);
        }

        public void tick() {
            MoveControl moveControl = this.swet.getMoveControl();
            if (moveControl instanceof SwetMoveControl) {
                SwetMoveControl swetMoveControl = (SwetMoveControl)moveControl;
                LivingEntity target = this.swet.getTarget();
                if (target != null) {
                    this.swet.lookAt((Entity)target, 10.0f, 10.0f);
                    swetMoveControl.setDirection(this.swet.getYRot(), true);
                    swetMoveControl.setWantedMovement(1.0);
                    if (this.swet.getBoundingBox().intersects(target.getBoundingBox())) {
                        this.swet.consumePassenger(target);
                    }
                }
            }
        }
    }

    public static class SwetRandomDirectionGoal
    extends Goal {
        private final Swet swet;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public SwetRandomDirectionGoal(Swet swet) {
            this.swet = swet;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return this.swet.getTarget() == null && (this.swet.onGround() || this.swet.isInFluidType() || this.swet.hasEffect(MobEffects.LEVITATION)) && this.swet.getMoveControl() instanceof SwetMoveControl;
        }

        public void tick() {
            SwetMoveControl moveHelperController = (SwetMoveControl)this.swet.getMoveControl();
            float rot = moveHelperController.yRot;
            Vec3 offset = new Vec3(-Math.sin(rot * ((float)Math.PI / 180)) * 2.0, 0.0, Math.cos(rot * ((float)Math.PI / 180)) * 2.0);
            BlockPos offsetPos = BlockPos.containing((Position)this.swet.position().add(offset));
            if (this.swet.level().getHeight(Heightmap.Types.WORLD_SURFACE, offsetPos.getX(), offsetPos.getZ()) < offsetPos.getY() - this.swet.getMaxFallDistance()) {
                this.nextRandomizeTime = this.adjustedTickDelay(40 + this.swet.getRandom().nextInt(60));
                this.chosenDegrees += 180.0f;
                moveHelperController.setCanJump(false);
            } else {
                if (--this.nextRandomizeTime <= 0) {
                    this.nextRandomizeTime = this.adjustedTickDelay(40 + this.swet.getRandom().nextInt(60));
                    this.chosenDegrees = this.swet.getRandom().nextInt(360);
                }
                moveHelperController.setCanJump(true);
            }
            moveHelperController.setDirection(this.chosenDegrees, false);
        }
    }

    public static class SwetKeepOnJumpingGoal
    extends Goal {
        private final Swet swet;

        public SwetKeepOnJumpingGoal(Swet swetEntity) {
            this.swet = swetEntity;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean canUse() {
            if (this.swet.isPassenger()) return false;
            MoveControl moveControl = this.swet.getMoveControl();
            if (!(moveControl instanceof SwetMoveControl)) return false;
            SwetMoveControl moveHelperController = (SwetMoveControl)moveControl;
            if (!moveHelperController.canJump) return false;
            return true;
        }

        public void tick() {
            MoveControl movecontrol = this.swet.getMoveControl();
            if (movecontrol instanceof SwetMoveControl) {
                SwetMoveControl swetMoveControl = (SwetMoveControl)movecontrol;
                swetMoveControl.setWantedMovement(1.0);
            }
        }
    }
}

