/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.AetherSoundEvents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractWhirlwind
extends Mob {
    public static final EntityDataAccessor<Integer> DATA_COLOR_ID = SynchedEntityData.defineId(AbstractWhirlwind.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int lifeLeft;
    private int dropsTimer;
    private int stuckTick;
    private float movementAngle;
    private float movementCurve;
    private boolean isEvil = false;

    public AbstractWhirlwind(EntityType<? extends AbstractWhirlwind> type, Level level) {
        super(type, level);
        if (level.isClientSide()) {
            this.movementAngle = this.getRandom().nextFloat() * 360.0f;
            this.movementCurve = (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.1f;
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new MoveGoal(this));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.025).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_COLOR_ID, (Object)this.getDefaultColor());
    }

    public static boolean checkWhirlwindSpawnRules(EntityType<? extends AbstractWhirlwind> whirlwind, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return Mob.checkMobSpawnRules(whirlwind, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random) && level.getRawBrightness(pos, 0) > 12 && level.getDifficulty() != Difficulty.PEACEFUL;
    }

    public void tick() {
        super.tick();
        --this.lifeLeft;
        if (!this.level().isClientSide() && (this.lifeLeft <= 0 || this.isInFluidType())) {
            this.discard();
        }
    }

    public void aiStep() {
        if (!this.level().isClientSide()) {
            if (this.verticalCollision && !this.verticalCollisionBelow) {
                this.stuckTick += 4;
            } else if (this.stuckTick > 0) {
                --this.stuckTick;
            }
            if (this.getTarget() != null) {
                ++this.dropsTimer;
            }
            if (this.dropsTimer >= 128) {
                this.spawnDrops();
                this.dropsTimer = 0;
            }
        } else {
            this.spawnParticles();
        }
        super.aiStep();
        List<Entity> entityList = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(2.5, 2.5, 2.5)).stream().filter(entity -> !entity.getType().is(AetherTags.Entities.WHIRLWIND_UNAFFECTED)).toList();
        for (Entity entity2 : entityList) {
            double d1;
            double x = (float)entity2.getX();
            double y = (double)((float)entity2.getY()) - entity2.getPassengerRidingPosition((Entity)this).y() * (double)0.6f;
            double z = (float)entity2.getZ();
            double distance = this.distanceTo(entity2);
            if (distance <= 1.5 + (d1 = y - this.getY())) {
                entity2.setDeltaMovement(entity2.getDeltaMovement().x(), 0.15, entity2.getDeltaMovement().z());
                entity2.resetFallDistance();
                if (d1 > 1.5) {
                    entity2.setDeltaMovement(entity2.getDeltaMovement().x(), -0.45 + d1 * 0.35, entity2.getDeltaMovement().z());
                    distance += d1 * 1.5;
                } else {
                    entity2.setDeltaMovement(entity2.getDeltaMovement().x(), 0.125, entity2.getDeltaMovement().z());
                }
                double d2 = Math.atan2(this.getX() - x, this.getZ() - z) / 0.0175;
                entity2.setDeltaMovement(-Math.cos(0.0175 * (d2 += 160.0)) * (distance + 0.25) * 0.1, entity2.getDeltaMovement().y, Math.sin(0.0175 * d2) * (distance + 0.25) * 0.1);
                if (entity2 instanceof AbstractWhirlwind) {
                    entity2.discard();
                }
            } else {
                double d3 = Math.atan2(this.getX() - x, this.getZ() - z) / 0.0175;
                entity2.setDeltaMovement(entity2.getDeltaMovement().add(Math.sin(0.0175 * d3) * 0.01, entity2.getDeltaMovement().y, Math.cos(0.0175 * d3) * 0.01));
            }
            if (this.level().isEmptyBlock(this.blockPosition())) continue;
            this.lifeLeft -= 50;
        }
        if (this.stuckTick > 40) {
            this.lifeLeft = 0;
        }
    }

    protected void spawnDrops() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getRandom().nextInt(4) == 0) {
                LootParams parameters = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).create(LootContextParamSets.SELECTOR);
                LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(this.getLootLocation());
                ObjectArrayList list = lootTable.getRandomItems(parameters);
                for (ItemStack itemstack : list) {
                    serverLevel.playSound(null, this.blockPosition(), (SoundEvent)AetherSoundEvents.ENTITY_WHIRLWIND_DROP.get(), SoundSource.HOSTILE, 0.5f, 1.0f);
                    this.spawnAtLocation(itemstack, 1.0f);
                }
            }
        }
    }

    public boolean hurt(DamageSource source, float damage) {
        return false;
    }

    public void kill() {
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent((Holder)GameEvent.ENTITY_DIE);
    }

    public abstract void spawnParticles();

    public abstract ResourceKey<LootTable> getLootLocation();

    public int getColorData() {
        return (Integer)this.getEntityData().get(DATA_COLOR_ID);
    }

    public void setColorData(int color) {
        this.getEntityData().set(DATA_COLOR_ID, (Object)color);
    }

    public int getLifeLeft() {
        return this.lifeLeft;
    }

    public void setLifeLeft(int lifeLeft) {
        this.lifeLeft = lifeLeft;
    }

    public boolean isEvil() {
        return this.isEvil;
    }

    public void setEvil(boolean evil) {
        this.isEvil = evil;
    }

    public abstract int getDefaultColor();

    public boolean onClimbable() {
        return this.horizontalCollision;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    protected boolean shouldDespawnInPeaceful() {
        return true;
    }

    protected boolean canRide(Entity vehicle) {
        return false;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("Movement Angle", this.movementAngle);
        tag.putFloat("Movement Curve", this.movementCurve);
        tag.putInt("Life Left", this.lifeLeft);
        tag.putInt("Color", this.getColorData());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Movement Angle")) {
            this.movementAngle = tag.getFloat("Movement Angle");
        }
        if (tag.contains("Movement Curve")) {
            this.movementCurve = tag.getFloat("Movement Curve");
        }
        if (tag.contains("Life Left")) {
            this.lifeLeft = tag.getInt("Life Left");
        }
        if (tag.contains("Color")) {
            this.setColorData(tag.getInt("Color"));
        }
    }

    protected static class MoveGoal
    extends Goal {
        private final AbstractWhirlwind whirlwind;
        protected float movementAngle;
        protected float movementCurve;

        public MoveGoal(AbstractWhirlwind entity) {
            this.whirlwind = entity;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return true;
        }

        public void tick() {
            if (this.movementAngle == 0.0f) {
                this.movementAngle = this.whirlwind.movementAngle;
                this.movementCurve = this.whirlwind.movementCurve;
            }
            if (!this.whirlwind.isEvil || this.whirlwind.getTarget() == null) {
                BlockPos offset = BlockPos.containing((Position)this.whirlwind.position().add(this.whirlwind.getDeltaMovement()));
                this.movementAngle = this.whirlwind.level().getHeight(Heightmap.Types.WORLD_SURFACE, offset.getX(), offset.getZ()) < offset.getY() - this.whirlwind.getMaxFallDistance() ? (this.movementAngle += 180.0f) : (this.movementAngle += this.movementCurve);
                double modifier = 1.0;
                AttributeInstance speed = this.whirlwind.getAttribute(Attributes.MOVEMENT_SPEED);
                if (speed != null) {
                    modifier = speed.getValue();
                }
                this.whirlwind.setDeltaMovement(Math.cos(this.movementAngle * ((float)Math.PI / 180)) * modifier, this.whirlwind.getDeltaMovement().y, Math.sin(this.movementAngle * ((float)Math.PI / 180)) * modifier);
            } else {
                this.whirlwind.setDeltaMovement(Vec3.ZERO);
            }
        }
    }
}

