/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.miscellaneous;

import com.aetherteam.aether.entity.EntityUtil;
import com.aetherteam.aether.mixin.mixins.common.accessor.ServerGamePacketListenerImplAccessor;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Parachute
extends Entity {
    public Parachute(EntityType<? extends Parachute> type, Level level) {
        super(type, level);
        this.blocksBuilding = true;
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        LivingEntity passenger = this.getControllingPassenger();
        if (passenger != null) {
            this.checkSlowFallDistance();
            this.moveParachute(passenger);
            this.spawnExplosionParticle();
            if (this.onGround() || this.isInFluidType() || this.verticalCollisionBelow) {
                this.ejectPassengers();
                this.die();
            }
        } else {
            this.die();
        }
    }

    public void moveParachute(LivingEntity passenger) {
        if (this.isVehicle()) {
            this.setYRot(passenger.getYRot());
            this.yRotO = this.getYRot();
            this.setXRot(passenger.getXRot() * 0.5f);
            this.setRot(this.getYRot(), this.getXRot());
            float x = passenger.xxa * 0.5f;
            float z = passenger.zza;
            if (z <= 0.0f) {
                z *= 0.25f;
            }
            Vec3 travelVec = new Vec3((double)x, (double)passenger.yya, (double)z);
            AttributeInstance gravity = passenger.getAttribute(Attributes.GRAVITY);
            double gravityModifier = gravity != null ? gravity.getValue() : 0.08;
            Vec3 movement = this.calculateMovement(travelVec);
            double y = movement.y();
            if (!this.isNoGravity()) {
                y -= gravityModifier;
            }
            double fallSpeed = Math.max(gravityModifier * -3.125, -0.25);
            this.setDeltaMovement(movement.x() * (double)0.91f, Math.max(y *= 0.98, fallSpeed), movement.z() * (double)0.91f);
            if (passenger instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)passenger;
                ServerGamePacketListenerImplAccessor serverGamePacketListenerImplAccessor = (ServerGamePacketListenerImplAccessor)serverPlayer.connection;
                serverGamePacketListenerImplAccessor.aether$setAboveGroundTickCount(0);
                serverGamePacketListenerImplAccessor.aether$setAboveGroundVehicleTickCount(0);
            }
        }
    }

    public Vec3 calculateMovement(Vec3 vec3) {
        float speed = 0.03f;
        this.moveRelative(speed, vec3);
        this.move(MoverType.SELF, this.getDeltaMovement());
        return this.getDeltaMovement();
    }

    public void die() {
        this.spawnExplosionParticle();
        if (!this.level().isClientSide()) {
            this.kill();
        }
    }

    public void spawnExplosionParticle() {
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)70);
        }
    }

    protected boolean canRide(Entity entity) {
        return true;
    }

    public boolean canRiderInteract() {
        return false;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return super.getPassengerRidingPosition(entity).add(0.0, 0.6, 0.0);
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        Direction direction = this.getMotionDirection();
        if (direction.getAxis() == Direction.Axis.Y) {
            return this.position().add(0.0, 0.5, 0.0);
        }
        Vec3 dismountLocation = this.position().add(0.0, 0.5, 0.0);
        if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)passenger, (AABB)passenger.getType().getDimensions().makeBoundingBox(dismountLocation))) {
            return this.position().add(0.0, 1.0, 0.0).add(new Vec3((double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ()).scale(0.5).reverse());
        }
        return dismountLocation;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof LivingEntity) {
            LivingEntity rider = (LivingEntity)entity;
            return rider;
        }
        return null;
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public void handleEntityEvent(byte id) {
        if (id == 70) {
            EntityUtil.spawnMovementExplosionParticles(this);
        } else {
            super.handleEntityEvent(id);
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
    }
}

