/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.resources.registries;

import com.aetherteam.aether.data.resources.builders.AetherBiomeBuilders;
import com.aetherteam.aether.data.resources.registries.AetherNoiseSettings;
import java.util.OptionalLong;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;

public class AetherDimensions {
    private static final ResourceLocation AETHER_LEVEL_ID = ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"the_aether");
    public static final ResourceKey<DimensionType> AETHER_DIMENSION_TYPE = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)AETHER_LEVEL_ID);
    public static final ResourceKey<Level> AETHER_LEVEL = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)AETHER_LEVEL_ID);
    public static final ResourceKey<LevelStem> AETHER_LEVEL_STEM = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)AETHER_LEVEL_ID);

    public static void bootstrapDimensionType(BootstrapContext<DimensionType> context) {
        context.register(AETHER_DIMENSION_TYPE, (Object)new DimensionType(OptionalLong.empty(), true, false, false, true, 1.0, true, false, 0, 256, 256, BlockTags.INFINIBURN_OVERWORLD, ResourceLocation.fromNamespaceAndPath((String)"aether", (String)"the_aether"), 0.0f, new DimensionType.MonsterSettings(false, false, (IntProvider)UniformInt.of((int)0, (int)7), 0)));
    }

    public static void bootstrapLevelStem(BootstrapContext<LevelStem> context) {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        HolderGetter noiseSettings = context.lookup(Registries.NOISE_SETTINGS);
        HolderGetter dimensionTypes = context.lookup(Registries.DIMENSION_TYPE);
        BiomeSource source = AetherBiomeBuilders.buildAetherBiomeSource((HolderGetter<Biome>)biomes);
        NoiseBasedChunkGenerator aetherChunkGen = new NoiseBasedChunkGenerator(source, (Holder)noiseSettings.getOrThrow(AetherNoiseSettings.SKYLANDS));
        context.register(AETHER_LEVEL_STEM, (Object)new LevelStem((Holder)dimensionTypes.getOrThrow(AETHER_DIMENSION_TYPE), (ChunkGenerator)aetherChunkGen));
    }
}

